Vue.component('post',{
  template: `
  <v-sheet fluid>
    <v-toolbar>
      <v-toolbar-title>{{$t(page.title)}}</v-toolbar-title>
      <v-spacer></v-spacer>
      <v-btn fab color="success" @click="$root.Url('create-post')" small>
        <v-icon>bi-plus</v-icon>
      </v-btn>
    </v-toolbar>
    <v-data-iterator :items="posts" :items-per-page="iterator.items_per_page" :page="iterator.page" :search="iterator.search" hide-default-footer>
      <template v-slot:header>
        <v-toolbar class="mb-1" color="primary">
          <v-text-field v-model="iterator.search" clearable flat solo hide-details prepend-inner-icon="bi-search" :label="$t('action.search')"></v-text-field>
        </v-toolbar>
      </template>
      <template v-slot:default="props">
        <v-row class="mt-10">
          <v-col cols="12" sm="6" md="3" v-for="(row,r) in props.items">
            <v-card style="box-shadow:  8px 8px 16px #e8e8e8, -8px -8px 16px #ffffff">
              <v-card-title>
                <v-icon>{{row.cover}}</v-icon>{{row.title}}
              </v-card-title>
              <v-card-text>{{row.description}}</v-card-text>
              <v-card-actions class="d-flex justify-space-between">
                <v-btn @click="$root.Url(row.slug+'-'+row.active,null,'page')" color="teal" fab x-small>
                  <v-icon>{{'bi bi-eye'}}</v-icon>
                </v-btn>
                <v-btn @click="$root.Url('update-post',row.ID)" color="indigo" fab x-small>
                  <v-icon>{{'bi bi-pencil-square'}}</v-icon>
                </v-btn>
                <!--v-btn @click="$root.Url('delete-post',row.ID)" color="red" fab x-small>
                  <v-icon>{{'bi bi-trash'}}</v-icon>
                </v-btn-->
              </v-card-actions>
            </v-card>
          </v-col>
        </v-row>
      </template>
      <template v-slot:footer>
        <v-row class="mt-2" align="center" justify="center">
          <v-spacer></v-spacer>
          <v-menu offset-y>
            <template v-slot:activator="{ on, attrs }">
              <v-btn text color="primary" class="ml-2" v-bind="attrs" v-on="on">
                {{ iterator.items_per_page }}
                <v-icon>mdi-chevron-down</v-icon>
              </v-btn>
            </template>
            <v-list dense>
              <v-list-item v-for="n in 5" :key="n" @click="iterator.items_per_page=(n*iterator.items_per_page)">
                <v-list-item-title>{{ n*iterator.items_per_page }}</v-list-item-title>
              </v-list-item>
            </v-list>
          </v-menu>
          <v-spacer></v-spacer>
          <v-btn fab color="blue darken-3" class="mr-1" @click="prevPage" :disabled="iterator.page>1?false:true">
            <v-icon>bi-chevron-left</v-icon>
          </v-btn>
          <v-btn fab color="blue darken-3" class="mr-1" @click="nextPage" :disabled="iterator.page<number_of_pages?false:true">
            <v-icon>bi-chevron-right</v-icon>
          </v-btn>
          <v-spacer></v-spacer>
        </v-row>
      </template>
    </v-data-iterator>
  </v-sheet>
  `,
  data:()=>{
    return {
      page:{
        title:'module.module'
      },
      iterator:{
        items_per_page:12,
        page:1,
        search:null
      },
      posts:[]
    }
  },
  props:['action','title'],
  computed:{
    number_of_pages(){
      return Math.ceil(this.posts.length/this.iterator.items_per_page)
    }
  },
  methods:{
    Data:function() {
      this.$emit('loading-screen')
      axios.post('Post/get')
      .then((response)=>{
        this.posts = response.data
        this.$emit('loading-screen',false)
      })
    },
    prevPage () {
      if (this.iterator.page-1 >= 1) this.iterator.page -= 1
    },
    nextPage () {
      if (this.iterator.page+1 <= this.number_of_pages) this.iterator.page += 1
    },
  },
  created:function() {
    this.Data();
  }
})
Vue.component('create-post',{
  template: `
  <v-form v-on:submit.prevent="Save()">
    <v-row class="mb-2">
      <v-col cols="12" md="12">
        <v-card>
          <v-card-title>{{title}} "{{form.title}}"</v-card-title>
          <v-card-text>
            <v-row>
              <v-col cols="12" sm="12" md="6">
                <v-text-field v-model="form.title" label="Nombre del Modulo"></v-text-field>
              </v-col>
              <v-col cols="12" sm="12" md="3">
                <v-text-field v-model="form.cover" :prepend-icon="form.cover" label="Icono"></v-text-field>
              </v-col>
              <v-col cols="12" sm="12" md="3">
                <v-checkbox v-model="form.is_visible" label="Mostrar en el Menu"></v-checkbox>
              </v-col>
              <v-col cols="12" sm="12" md="12">
                <v-textarea v-model="form.description" label="Descripcion" counter rows="2" :value="form.description"></v-textarea>
              </v-col>
            </v-row>
          </v-card-text>
        </v-card>
      </v-col>
      <v-col cols="12" md="12">
        <v-chip-group show-arrows>
          <v-chip v-for="(btn,b) in form.variable" :key="btn.id" :color="btn.color" close :outlined="!btn.visible" :close-icon="btn.visible?'ri-eye-line':'ri-eye-close-line'" @click:close="btn.visible=!btn.visible" @click="selectActive('btn',[b])">
            <v-avatar left>
              <v-icon>{{btn.icon}}</v-icon>
            </v-avatar>{{btn.text}}
          </v-chip>
        </v-chip-group>
      </v-col>
    </v-row>
    <v-row dense>
      <v-col cols="12" md="12">
        <v-row>
          <v-col cols="12" md="11">
            <v-chip-group v-model="toggle.tab" show-arrows mandatory>
              <v-chip v-for="(item,i) in form.content" :value="'screen-'+item.id" :color="toggle.tab=='screen-'+item.id?'red':'teal'" close close-icon="bi-trash" @click:close="deleteRow(i,item.id)">
                {{item.name}}
              </v-chip>
            </v-chip-group>
          </v-col>
          <v-col cols="12" md="1">
            <v-btn text color="success" @click="pushRow()" fab class="align-self-center mr-4" small> 
              <v-icon>ri-add-box-line</v-icon>
            </v-btn>
          </v-col>
        </v-row>
        <v-sheet fluid v-for="(row,r) in form.content" v-show="toggle.tab=='screen-'+row.id">
          <v-row dense>
            <v-col cols="12" md="12">
              <v-card flat outlined class="mb-3">
                <v-card-title class="d-flex justify-space-between">
                  <v-btn rounded small color="primary" @click="form.content[r].content.push({...{id:$root.GenerateID('alnum',8),props:{md:'12',render:'section'},content:[]}})">
                    <v-icon>ri-insert-row-bottom</v-icon> {{$t('action.add')}} {{$t('section.section')}}
                  </v-btn>
                  <v-menu offset-y>
                    <template v-slot:activator="{ on, attrs }">
                      <v-btn color="primary" v-bind="attrs" v-on="on" fab x-small>
                        <v-icon>ri-list-settings-line</v-icon>
                      </v-btn>
                    </template>
                    <v-list dense>
                      <v-list-item link @click="selectActive('row',[r])">
                        <v-list-item-icon><v-icon>bi-sliders</v-icon></v-list-item-icon>
                        <v-list-item-title>{{$t('action.setting')}}</v-list-item-title>
                      </v-list-item>
                      <v-divider></v-divider>
                      <v-list-item link @click="deleteRow(r,row.id)">
                        <v-list-item-icon><v-icon color="red">bi-trash</v-icon></v-list-item-icon>
                        <v-list-item-title>{{$t('action.delete')}}</v-list-item-title>
                      </v-list-item>
                    </v-list>
                  </v-menu>
                </v-card-title>
                <v-card-text>
                  <draggable :list="form.content[r].content" group="components" handle=".move-component" :class="'row d-flex justify-'+row.props.justify+' align-'+row.props.align">
                    <v-col v-for="(col,c) in row.content" :key="col.id" cols="12" :md="col.props.md">
                      <v-card flat outlined>
                        <v-card-title class="d-flex justify-space-between">
                          <v-btn fab x-small color="primary" @click="selectActive('node',[r,c])">
                            <v-icon>bi-node-plus</v-icon>
                          </v-btn>
                          <v-btn x-small color="teal" icon class="move-component">
                            <v-icon>ri-drag-drop-line</v-icon>
                          </v-btn>
                          <v-menu offset-y>
                            <template v-slot:activator="{ on, attrs }">
                              <v-btn color="primary" v-bind="attrs" v-on="on" fab x-small>
                                <v-icon>ri-list-settings-line</v-icon>
                              </v-btn>
                            </template>
                            <v-list dense>
                              <v-list-item link @click="selectActive('col',[r,c])">
                                <v-list-item-icon><v-icon>bi-sliders</v-icon></v-list-item-icon>
                                <v-list-item-title>{{$t('action.setting')}}</v-list-item-title>
                              </v-list-item>
                              <v-divider></v-divider>
                              <v-list-item link @click="$delete(form.content[r].content,c)">
                                <v-list-item-icon><v-icon color="red">bi-trash</v-icon></v-list-item-icon>
                                <v-list-item-title>{{$t('action.delete')}}</v-list-item-title>
                              </v-list-item>
                            </v-list>
                          </v-menu>
                        </v-card-title>
                        <v-card-text>
                          <draggable :list="form.content[r].content[c].content" group="items" handle=".move-item" class="row">
                            <v-col v-for="(item,i) in col.content" :key="item.id" cols="12" md="12">
                              <v-card flat outlined class="move-item">
                                <v-card-title>
                                  <v-icon>ri-drag-drop-line</v-icon>&nbsp;&nbsp;{{item.name}}
                                  <v-spacer></v-spacer>
                                  <v-btn icon x-small fab color="error" @click="$delete(form.content[r].content[c].content,i)">
                                    <v-icon>mdi-delete-outline</v-icon>
                                  </v-btn>
                                  <v-btn icon x-small fab color="info" @click="selectActive('component',[r,c,i])">
                                    <v-icon>ri-list-settings-line</v-icon>
                                  </v-btn>
                                </v-card-title>
                                <v-card-subtitle>Componente: {{item.id}}</v-card-subtitle>
                              </v-card>
                            </v-col>
                          </draggable>
                        </v-card-text>
                        <v-card-actions class="d-flex justify-space-between">
                        </v-card-actions>
                      </v-card>
                    </v-col>
                  </draggable>
                </v-card-text>
                <v-card-actions>
                  <v-btn fab v-if="form.active==row.id" x-small color="warning">
                    <v-icon>ri-star-s-fill</v-icon> 
                  </v-btn>
                  <v-btn rounded v-else small @click="form.active=row.id">
                    <v-icon color="warning">ri-star-s-fill</v-icon> Hacer principal
                  </v-btn>
                </v-card-actions>
              </v-card>
            </v-col>
          </v-row>
        </v-sheet>
        <v-row>
          <v-col class="d-flex justify-center">
            <v-btn rounded small color="success" @click="pushRow()"> 
              <v-icon>ri-add-box-line</v-icon> Agregar Pantalla
            </v-btn>
          </v-col>
        </v-row>
      </v-col>
      <v-dialog v-model="toggle.set_btn" persistent width="30%">
        <v-card v-if="active.length>0 && toggle.set_btn">
          <v-card-title>{{form.variable[active[0]].text}}</v-card-title>
          <v-card-text>
            <v-text-field dense v-model="form.variable[active[0]].icon" label="Icono"></v-text-field>
            <v-text-field dense v-model="form.variable[active[0]].color" label="Color"></v-text-field>
          </v-card-text>
          <v-card-actions>
            <v-btn rounded color="red ligthen-2" @click="deselectActive('btn')" block>
              <v-icon>bi-x</v-icon> {{$t('action.close')}}
            </v-btn>
          </v-card-actions>
        </v-card>
      </v-dialog>
      <v-dialog v-model="toggle.set_row" persistent width="30%">
        <v-card v-if="active.length>0 && toggle.set_row">
          <v-card-title>{{$t('action.setting')}} <small class="text-xs">{{form.content[active[0]].name}}</small></v-card-title>
          <v-card-text>
            <v-text-field dense v-model="form.content[active[0]].name" label="Nombre de la Pantalla" @input="editButton(form.content[active[0]].id,'text',form.content[active[0]].name)"></v-text-field>
            <v-select dense v-model="form.content[active[0]].props.justify" :items="['start','center','end','space-between','space-around']" label="Horizontal"></v-select>
            <v-select dense v-model="form.content[active[0]].props.align" :items="['start','center','end','baseline ','stretch']" label="Vertical"></v-select>
          </v-card-text>
          <v-card-actions>
            <v-btn rounded color="red ligthen-2" @click="deselectActive('row')" block>
              <v-icon>bi-x</v-icon> {{$t('action.close')}}
            </v-btn>
          </v-card-actions>
        </v-card>
      </v-dialog>
      <v-dialog v-model="toggle.set_col" persistent width="30%">
        <v-card v-if="active.length>0 && toggle.set_col">
          <v-card-title>{{$t('action.setting')}}</v-card-title>
          <v-card-text>
            <v-select dense v-model="form.content[active[0]].content[active[1]].props.render" label="Tipo de Render" :items="['section','maps']"></v-select>
            <v-select dense v-model="form.content[active[0]].content[active[1]].props.md" label="Ancho" :items="['auto',2,3,4,5,6,7,8,9,10,11,12]"></v-select>
          </v-card-text>
          <v-card-actions>
            <v-btn rounded color="red ligthen-2" @click="deselectActive('col')" block>
              <v-icon>bi-x</v-icon> {{$t('action.close')}}
            </v-btn>
          </v-card-actions>
        </v-card>
      </v-dialog>
      <v-dialog v-model="toggle.set_component" persistent width="50%">
        <v-card v-if="active.length>0 && toggle.set_component">
          <v-card-title>{{$t('action.setting')}} {{form.content[active[0]].content[active[1]].content[active[2]].name}}</v-card-title>
          <v-card-text>
            <element-setting v-if="form.content[active[0]].content[active[1]].content[active[2]].type=='element'" :template="form.content[active[0]].content[active[1]].content[active[2]].template" :content="form.content[active[0]].content[active[1]].content[active[2]]" :pages="form"></element-setting>
            <component-setting v-else :template="form.content[active[0]].content[active[1]].content[active[2]].template" :content="form.content[active[0]].content[active[1]].content[active[2]]" :pages="form"></component-setting>
          </v-card-text>
          <v-card-actions>
            <v-btn rounded color="red ligthen-2" @click="deselectActive('component')" block>
              <v-icon>bi-x</v-icon> {{$t('action.close')}}
            </v-btn>
          </v-card-actions>
        </v-card>
      </v-dialog>
      <v-dialog v-model="toggle.set_node" persistent width="50%" scrollable>
        <v-card v-if="active.length>0 && toggle.set_node">
          <v-card-title>{{$t('action.add')}} {{$t('section.component')}}</v-card-title>
          <v-card-text>
            <v-tabs v-model="toggle.tabs" centered icons-and-text dense>
              <v-tabs-slider></v-tabs-slider>
              <v-tab>
                Components
                <v-icon>mdi-puzzle-plus-outline</v-icon>
              </v-tab>
              <v-tab>
                Elements
                <v-icon>mdi-sticker-plus-outline</v-icon>
              </v-tab>
            </v-tabs>
            <v-tabs-items v-model="toggle.tabs">
              <v-tab-item :key="0" :value="0">
                <v-list dense>
                  <v-list-item-group>
                    <v-list-item v-for="(component,c) in components" :key="component.codename+'-'+component.keyname" @click="cloneNode(component)">
                      <v-list-item-icon v-if="component.template=='create'"><v-icon>ri-add-line</v-icon></v-list-item-icon>
                      <v-list-item-icon v-else-if="component.template=='read'"><v-icon>ri-list-check-2</v-icon></v-list-item-icon>
                      <v-list-item-icon v-else-if="component.template=='update'"><v-icon>ri-edit-line</v-icon></v-list-item-icon>
                      <v-list-item-icon v-else-if="component.template=='delete'"><v-icon>ri-delete-bin-2-line</v-icon></v-list-item-icon>
                      <v-list-item-icon v-else-if="component.template=='view'"><v-icon>ri-eye-line</v-icon></v-list-item-icon>
                      <v-list-item-icon v-else-if="component.template=='chart'"><v-icon>{{'ri-'+component.type+'-chart-line'}}</v-icon></v-list-item-icon>
                      <v-list-item-icon v-else><v-icon>bi-node-plus</v-icon></v-list-item-icon>
                      <v-list-item-content>{{component.name}}</v-list-item-content>
                      <v-list-item-icon v-if="node_active==component"><v-icon color="green">ri-check-line</v-icon></v-list-item-icon>
                    </v-list-item>
                  </v-list-item-group>
                </v-list>
              </v-tab-item>
              <v-tab-item :key="1" :value="1">
                <v-list dense>
                  <v-list-item-group>
                    <v-list-item v-for="(component,c) in elements" :key="component.codename+'-'+component.keyname" @click="cloneNode(component)">
                      <v-list-item-icon v-if="component.template=='carousel'"><v-icon>mdi-view-carousel-outline</v-icon></v-list-item-icon>

                      <v-list-item-icon v-else><v-icon>bi-node-plus</v-icon></v-list-item-icon>
                      <v-list-item-content>{{component.name}}</v-list-item-content>
                      <v-list-item-icon v-if="node_active==component"><v-icon color="green">ri-check-line</v-icon></v-list-item-icon>
                    </v-list-item>
                  </v-list-item-group>
                </v-list>
              </v-tab-item>
            </v-tabs-items>
          </v-card-text>
          <v-card-actions>
            <v-btn rounded color="red ligthen-2" @click="deselectActive('node')" block>
              <v-icon>bi-x</v-icon> {{$t('action.close')}}
            </v-btn>
          </v-card-actions>
        </v-card>
      </v-dialog>
    </v-row>
    <v-card-actions class="text-center">
      <v-btn type="submit" color="success">
        <v-icon>bi bi-cloud-arrow-up</v-icon> Guardar
      </v-btn>
    </v-card-actions>
  </v-form>
  `,
  data:()=>{
    return {
      tab:null,
      toggle:{
        tab:'',
        tabs:'',
        set_btn:false,
        set_row:false,
        set_col:false,
        set_component:false
      },
      active:[],
      row_active:null,
      col_active:null,
      ite_active:null,
      btn_active:null,
      node_active:null,
      set_modal:false,
      global_id:0,
      form:{
        type:'page',
        active:null,
        title:'',
        slug:'',
        cover:'',
        description:'',
        variable:[],
        content:[],
        is_visible:true
      },
      variable:{
        icon:'bx-pointer',
        color:'primary',
        text:'',
        id:null,
        master:null
      },
      keynames:{
        key:'',
        value:null
      },
      components:[],
      modules:[],
      elements:[]
    }
  },
  props:['title'],
  methods:{
    Save:function() {
      this.$emit('loading-screen')
      var final_form = this.form
      axios.post('Post/add',final_form)
      .then((response)=>{
        this.$root.Url('post');
        this.$emit('loading-screen',false)
      })
    },
    tableFields:function() {
      axios.post(this.$root.p+'/get_tables/'+this.form.table)
      .then((response)=>{
        this.form.data = response.data
      })
    },
    fillOptions:function(table=null) {
      if (table!==null && table!=='') {
        if (this.database.tables.includes(table)) {
          axios.post(this.$root.p+'/get_tables/'+this.form.table+'?field=name')
          .then((response)=>{
            this.database.options = response.data
          })
        } else{
          this.database.options = []
        }
      } else {
        this.database.options = []
      }
    },
    selectActive(s='btn',a=[]) {
      this.toggle['set_'+s] = true
      this.active = a
    },
    deselectActive(s='btn') {
      this.toggle['set_'+s] = false
      this.active = []
    },
    selectNode(node=null) {
      this.node_active = node
    },
    cloneNode(node) {
      node.id = this.$root.GenerateID('alnum',8)
      this.form.content[this.active[0]].content[this.active[1]].content.push({...node})
      this.setButton()
    },
    pushRow() {
      var id_gen = this.$root.GenerateID('alnum',16)
      var data = {
        props:{
          justify:undefined,
          align:undefined
        },
        id:id_gen,
        name:'Pantalla '+(this.global_id+1),
        content:[]
      }
      this.global_id++
      if (this.form.content.length==0) {
        this.form.active = id_gen
      }
      this.form.content.push({...data})
      this.setButton()
    },
    deleteRow(i,id) {
      this.$delete(this.form.content,i)
      let del = this.form.variable.map(item=>item.master).indexOf(id)
      this.form.variable.splice(del,1)
    },
    setButton(){
      var button 
      this.form.content.map((el,i)=>{
        var cc = this.form.variable.find((e)=> e.master==el.id)
        var data = this.variable
        data.id = this.$root.GenerateID('alnum',8)
        data.master = el.id
        data.text = el.name
        data.visible = true
        if (!cc) {
          this.form.variable.push({...data})
        }
      })
    },
    editButton(id,key,value){
      this.form.variable.map((el,i)=>{
        if (el.master==id) {
          el[key] = value
        }
      })
    }
  },
  mounted:function() {
    this.form.slug = 'MOD'+this.$root.GenerateID('alpha',16)
    axios.post('Component/get')
    .then((response)=>{
      this.components = response.data
    })
    axios.post('Element/get')
    .then((response)=>{
      this.elements = response.data
    })
    this.$emit('loading-screen',false)
  }
})
Vue.component('read-post',{
  template: `
  <div class="page-content">
    <div class="container">
      <div class="row">
        <div class="col-md">
          <div class="card">
            <div class="card-body">
              <h5 class="card-title">{{read.name}}</h5>
              <div class="row mb-2">
                <div class="col-md-6">
                  <dt>COD</dt>
                  <dd>{{read.COD}}</dd>
                </div>
                <div class="col-md-6">
                  <dt>Vagoneta</dt>
                  <dd>{{read.name}}</dd>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  `,
  data:()=>{
    return {
      read:[],
    }
  },
  props:['action'],
  methods:{
    Data:function() {
      axios.post(this.$root.p+'/get/'+this.$root.pk)
      .then((response)=>{
        this.read = response.data.results
      })
    }
  },
  created:function() {
    this.Data();
  }
})
Vue.component('update-post',{
  template: `
  <v-form v-on:submit.prevent="Save()">
    <v-row class="mb-2">
      <v-col cols="12" md="12">
        <v-card>
          <v-card-title>{{title}} "{{form.title}}"</v-card-title>
          <v-card-text>
            <v-row>
              <v-col cols="12" sm="12" md="6">
                <v-text-field v-model="form.title" label="Nombre del Modulo"></v-text-field>
              </v-col>
              <v-col cols="12" sm="12" md="3">
                <v-text-field v-model="form.cover" :prepend-icon="form.cover" label="Icono"></v-text-field>
              </v-col>
              <v-col cols="12" sm="12" md="3">
                <v-checkbox v-model="form.is_visible" label="Mostrar en el Menu"></v-checkbox>
              </v-col>
              <v-col cols="12" sm="12" md="12">
                <v-textarea v-model="form.description" label="Descripcion" counter rows="2" :value="form.description"></v-textarea>
              </v-col>
            </v-row>
          </v-card-text>
        </v-card>
      </v-col>
      <v-col cols="12" md="12">
        <v-chip-group show-arrows>
          <v-chip v-for="(btn,b) in form.variable" :key="btn.id" :color="btn.color" close :outlined="!btn.visible" :close-icon="btn.visible?'ri-eye-line':'ri-eye-close-line'" @click:close="btn.visible=!btn.visible" @click="selectActive('btn',[b])">
            <v-avatar left>
              <v-icon>{{btn.icon}}</v-icon>
            </v-avatar>{{btn.text}}
          </v-chip>
        </v-chip-group>
      </v-col>
    </v-row>
    <v-row dense>
      <v-col cols="12" md="12">
        <v-row>
          <v-col cols="12" md="11">
            <v-chip-group v-model="toggle.tab" show-arrows mandatory>
              <v-chip v-for="(item,i) in form.content" :value="'screen-'+item.id" :color="toggle.tab=='screen-'+item.id?'red':'teal'" close close-icon="bi-trash" @click:close="deleteRow(i,item.id)">
                {{item.name}}
              </v-chip>
            </v-chip-group>
          </v-col>
          <v-col cols="12" md="1">
            <v-btn text color="success" @click="pushRow()" fab class="align-self-center mr-4" small> 
              <v-icon>ri-add-box-line</v-icon>
            </v-btn>
          </v-col>
        </v-row>
        <v-sheet fluid v-for="(row,r) in form.content" v-show="toggle.tab=='screen-'+row.id">
          <v-row dense>
            <v-col cols="12" md="12">
              <v-card flat outlined class="mb-3">
                <v-card-title class="d-flex justify-space-between">
                  <v-btn rounded small color="primary" @click="form.content[r].content.push({...{id:$root.GenerateID('alnum',8),props:{md:'12',render:'section'},content:[]}})">
                    <v-icon>ri-insert-row-bottom</v-icon> {{$t('action.add')}} {{$t('section.section')}}
                  </v-btn>
                  <v-menu offset-y>
                    <template v-slot:activator="{ on, attrs }">
                      <v-btn color="primary" v-bind="attrs" v-on="on" fab x-small>
                        <v-icon>ri-list-settings-line</v-icon>
                      </v-btn>
                    </template>
                    <v-list dense>
                      <v-list-item link @click="selectActive('row',[r])">
                        <v-list-item-icon><v-icon>bi-sliders</v-icon></v-list-item-icon>
                        <v-list-item-title>{{$t('action.setting')}}</v-list-item-title>
                      </v-list-item>
                      <v-divider></v-divider>
                      <v-list-item link @click="deleteRow(r,row.id)">
                        <v-list-item-icon><v-icon color="red">bi-trash</v-icon></v-list-item-icon>
                        <v-list-item-title>{{$t('action.delete')}}</v-list-item-title>
                      </v-list-item>
                    </v-list>
                  </v-menu>
                </v-card-title>
                <v-card-text>
                  <draggable :list="form.content[r].content" group="components" handle=".move-component" :class="'row d-flex justify-'+row.props.justify+' align-'+row.props.align">
                    <v-col v-for="(col,c) in row.content" :key="col.id" cols="12" :md="col.props.md">
                      <v-card flat outlined>
                        <v-card-title class="d-flex justify-space-between">
                          <v-btn fab x-small color="primary" @click="selectActive('node',[r,c])">
                            <v-icon>bi-node-plus</v-icon>
                          </v-btn>
                          <v-btn x-small color="teal" icon class="move-component">
                            <v-icon>ri-drag-drop-line</v-icon>
                          </v-btn>
                          <v-menu offset-y>
                            <template v-slot:activator="{ on, attrs }">
                              <v-btn color="primary" v-bind="attrs" v-on="on" fab x-small>
                                <v-icon>ri-list-settings-line</v-icon>
                              </v-btn>
                            </template>
                            <v-list dense>
                              <v-list-item link @click="selectActive('col',[r,c])">
                                <v-list-item-icon><v-icon>bi-sliders</v-icon></v-list-item-icon>
                                <v-list-item-title>{{$t('action.setting')}}</v-list-item-title>
                              </v-list-item>
                              <v-divider></v-divider>
                              <v-list-item link @click="$delete(form.content[r].content,c)">
                                <v-list-item-icon><v-icon color="red">bi-trash</v-icon></v-list-item-icon>
                                <v-list-item-title>{{$t('action.delete')}}</v-list-item-title>
                              </v-list-item>
                            </v-list>
                          </v-menu>
                        </v-card-title>
                        <v-card-text>
                          <draggable :list="form.content[r].content[c].content" group="items" handle=".move-item" class="row">
                            <v-col v-for="(item,i) in col.content" :key="item.id" cols="12" md="12">
                              <v-card flat outlined class="move-item">
                                <v-card-title>
                                  <v-icon>ri-drag-drop-line</v-icon>&nbsp;&nbsp;{{item.name}}
                                  <v-spacer></v-spacer>
                                  <v-btn icon x-small fab color="error" @click="$delete(form.content[r].content[c].content,i)">
                                    <v-icon>mdi-delete-outline</v-icon>
                                  </v-btn>
                                  <v-btn icon x-small fab color="info" @click="selectActive('component',[r,c,i])">
                                    <v-icon>ri-list-settings-line</v-icon>
                                  </v-btn>
                                </v-card-title>
                                <v-card-subtitle>Componente: {{item.id}}</v-card-subtitle>
                              </v-card>
                            </v-col>
                          </draggable>
                        </v-card-text>
                        <v-card-actions class="d-flex justify-space-between">
                        </v-card-actions>
                      </v-card>
                    </v-col>
                  </draggable>
                </v-card-text>
                <v-card-actions>
                  <v-btn fab v-if="form.active==row.id" x-small color="warning">
                    <v-icon>ri-star-s-fill</v-icon> 
                  </v-btn>
                  <v-btn rounded v-else small @click="form.active=row.id">
                    <v-icon color="warning">ri-star-s-fill</v-icon> Hacer principal
                  </v-btn>
                </v-card-actions>
              </v-card>
            </v-col>
          </v-row>
        </v-sheet>
        <v-row>
          <v-col class="d-flex justify-center">
            <v-btn rounded small color="success" @click="pushRow()"> 
              <v-icon>ri-add-box-line</v-icon> Agregar Pantalla
            </v-btn>
          </v-col>
        </v-row>
      </v-col>
      <v-dialog v-model="toggle.set_btn" persistent width="30%">
        <v-card v-if="active.length>0 && toggle.set_btn">
          <v-card-title>{{form.variable[active[0]].text}}</v-card-title>
          <v-card-text>
            <v-text-field dense v-model="form.variable[active[0]].icon" label="Icono"></v-text-field>
            <v-text-field dense v-model="form.variable[active[0]].color" label="Color"></v-text-field>
          </v-card-text>
          <v-card-actions>
            <v-btn rounded color="red ligthen-2" @click="deselectActive('btn')" block>
              <v-icon>bi-x</v-icon> {{$t('action.close')}}
            </v-btn>
          </v-card-actions>
        </v-card>
      </v-dialog>
      <v-dialog v-model="toggle.set_row" persistent width="30%">
        <v-card v-if="active.length>0 && toggle.set_row">
          <v-card-title>{{$t('action.setting')}} <small class="text-xs">{{form.content[active[0]].name}}</small></v-card-title>
          <v-card-text>
            <v-text-field dense v-model="form.content[active[0]].name" label="Nombre de la Pantalla" @input="editButton(form.content[active[0]].id,'text',form.content[active[0]].name)"></v-text-field>
            <v-select dense v-model="form.content[active[0]].props.justify" :items="['start','center','end','space-between','space-around']" label="Horizontal"></v-select>
            <v-select dense v-model="form.content[active[0]].props.align" :items="['start','center','end','baseline ','stretch']" label="Vertical"></v-select>
            <!--v-row>
              <v-col cols="12" md="8">
                {{form.content[active[0]]}}
                <v-row no-gutters v-if="form.content[active[0]].props">
                  <v-col cols="12" md="4" v-for="(item,i) in Object.keys(form.content[active[0]].props)">
                    <v-text-field v-model="form.content[active[0]].props[item]" :label="item" outlined append-icon="mdi-delete-outline" @click:append="Vue.delete(form.content[active[0]].props, item);"></v-text-field>
                  </v-col>
                </v-row>
              </v-col>
              <v-col cols="12" md="4">
                <v-text-field append-icon="mdi-plus" v-model="param.key" @click:append="AddParam(active[0])"></v-text-field>
              </v-col>
            </v-row-->
          </v-card-text>
          <v-card-actions>
            <v-btn rounded color="red ligthen-2" @click="deselectActive('row')" block>
              <v-icon>bi-x</v-icon> {{$t('action.close')}}
            </v-btn>
          </v-card-actions>
        </v-card>
      </v-dialog>
      <v-dialog v-model="toggle.set_col" persistent width="30%">
        <v-card v-if="active.length>0 && toggle.set_col">
          <v-card-title>{{$t('action.setting')}}</v-card-title>
          <v-card-text>
            <v-select dense v-model="form.content[active[0]].content[active[1]].props.render" label="Tipo de Render" :items="['section','maps']"></v-select>
            <v-select dense v-model="form.content[active[0]].content[active[1]].props.md" label="Ancho" :items="['auto',2,3,4,5,6,7,8,9,10,11,12]"></v-select>
          </v-card-text>
          <v-card-actions>
            <v-btn rounded color="red ligthen-2" @click="deselectActive('col')" block>
              <v-icon>bi-x</v-icon> {{$t('action.close')}}
            </v-btn>
          </v-card-actions>
        </v-card>
      </v-dialog>
      <v-dialog v-model="toggle.set_component" persistent width="50%">
        <v-card v-if="active.length>0 && toggle.set_component">
          <v-card-title>{{$t('action.setting')}} {{form.content[active[0]].content[active[1]].content[active[2]].name}}</v-card-title>
          <v-card-text>
            <element-setting v-if="form.content[active[0]].content[active[1]].content[active[2]].type=='element'" :template="form.content[active[0]].content[active[1]].content[active[2]].template" :content="form.content[active[0]].content[active[1]].content[active[2]]" :pages="form"></element-setting>
            <component-setting v-else :template="form.content[active[0]].content[active[1]].content[active[2]].template" :content="form.content[active[0]].content[active[1]].content[active[2]]" :pages="form"></component-setting>
          </v-card-text>
          <v-card-actions>
            <v-btn rounded color="red ligthen-2" @click="deselectActive('component')" block>
              <v-icon>bi-x</v-icon> {{$t('action.close')}}
            </v-btn>
          </v-card-actions>
        </v-card>
      </v-dialog>
      <v-dialog v-model="toggle.set_node" persistent width="50%" scrollable>
        <v-card v-if="active.length>0 && toggle.set_node">
          <v-card-title>{{$t('action.add')}} {{$t('section.component')}}</v-card-title>
          <v-card-text>
            <v-tabs v-model="toggle.tabs" centered icons-and-text dense>
              <v-tabs-slider></v-tabs-slider>
              <v-tab>
                Components
                <v-icon>mdi-puzzle-plus-outline</v-icon>
              </v-tab>
              <v-tab>
                Elements
                <v-icon>mdi-sticker-plus-outline</v-icon>
              </v-tab>
            </v-tabs>
            <v-tabs-items v-model="toggle.tabs">
              <v-tab-item :key="0" :value="0">
                <v-list dense>
                  <v-list-item-group>
                    <v-list-item v-for="(component,c) in components" :key="component.codename+'-'+component.keyname" @click="cloneNode(component)">
                      <v-list-item-icon v-if="component.template=='create'"><v-icon>ri-add-line</v-icon></v-list-item-icon>
                      <v-list-item-icon v-else-if="component.template=='read'"><v-icon>ri-list-check-2</v-icon></v-list-item-icon>
                      <v-list-item-icon v-else-if="component.template=='update'"><v-icon>ri-edit-line</v-icon></v-list-item-icon>
                      <v-list-item-icon v-else-if="component.template=='delete'"><v-icon>ri-delete-bin-2-line</v-icon></v-list-item-icon>
                      <v-list-item-icon v-else-if="component.template=='view'"><v-icon>ri-eye-line</v-icon></v-list-item-icon>
                      <v-list-item-icon v-else-if="component.template=='chart'"><v-icon>{{'ri-'+component.type+'-chart-line'}}</v-icon></v-list-item-icon>
                      <v-list-item-icon v-else><v-icon>bi-node-plus</v-icon></v-list-item-icon>
                      <v-list-item-content>{{component.name}}</v-list-item-content>
                      <v-list-item-icon v-if="node_active==component"><v-icon color="green">ri-check-line</v-icon></v-list-item-icon>
                    </v-list-item>
                  </v-list-item-group>
                </v-list>
              </v-tab-item>
              <v-tab-item :key="1" :value="1">
                <v-list dense>
                  <v-list-item-group>
                    <v-list-item v-for="(component,c) in elements" :key="component.codename+'-'+component.keyname" @click="cloneNode(component)">
                      <v-list-item-icon v-if="component.template=='carousel'"><v-icon>mdi-view-carousel-outline</v-icon></v-list-item-icon>

                      <v-list-item-icon v-else><v-icon>bi-node-plus</v-icon></v-list-item-icon>
                      <v-list-item-content>{{component.name}}</v-list-item-content>
                      <v-list-item-icon v-if="node_active==component"><v-icon color="green">ri-check-line</v-icon></v-list-item-icon>
                    </v-list-item>
                  </v-list-item-group>
                </v-list>
              </v-tab-item>
            </v-tabs-items>
          </v-card-text>
          <v-card-actions>
            <v-btn rounded color="red ligthen-2" @click="deselectActive('node')" block>
              <v-icon>bi-x</v-icon> {{$t('action.close')}}
            </v-btn>
          </v-card-actions>
        </v-card>
      </v-dialog>
    </v-row>
    <v-card-actions class="text-center">
      <v-btn type="submit" color="success">
        <v-icon>bi bi-cloud-arrow-up</v-icon> Guardar
      </v-btn>
    </v-card-actions>
  </v-form>
  `,
  data:()=>{
    return {
      tab:'',
      tabs:'',
      toggle:{
        tab:'',
        set_btn:false,
        set_row:false,
        set_col:false,
        set_component:false
      },
      active:[],
      row_active:null,
      col_active:null,
      ite_active:null,
      btn_active:null,
      node_active:null,
      set_modal:false,
      global_id:0,
      form:{
        type:'page',
        active:null,
        title:'',
        slug:'',
        cover:'',
        description:'',
        variable:[],
        content:[],
        is_visible:true
      },
      variable:{
        icon:'bx-pointer',
        color:'primary',
        text:'',
        id:null,
        master:null
      },
      keynames:{
        key:'',
        value:null
      },
      param:{
        key:'',
        value:''
      },
      components:[],
      modules:[],
      elements:[]
    }
  },
  props:['title'],
  methods:{
    Data:function() {
      this.$emit('loading-screen')
      axios.post('Post/get',{
        where:{
          ID:this.$root.url.id
        },
        result:'row'
      })
      .then((response)=>{
        this.form = response.data
        this.$emit('loading-screen',false)
      })
    },
    Save:function() {
      var final_form = this.form
      axios.post('Post/set/'+this.$root.url.id,final_form)
      .then((response)=>{
        this.$root.Url('post');
      })
    },
    AddParam(n){
      if (this.form.content[n].props == null) {
        this.content.attr.card = {}
      }
      this.$set(this.form.content[n].props,this.param.key,this.param.value)
      this.$root.toast.show({
        message:"Rule added successfully",
        color:'cyan'
      })
      this.param.key = ''
      this.param.value = ''
    },
    addGeoJSON(geo,r,c,i){
      this.geo_data = {}
      geo.forEach((value,index) => {
        this.$set(this.geo_data,value.$attrs.name,value.lazyValue)
        //this.$set(this.geo_data,'')geo_data.push({})
      });
      console.log(this.geo_data)
      this.form.content[r].content[c].content[i].props.maps.geojson.push(this.geo_data)
    },
    selectActive(s='btn',a=[]) {
      this.toggle['set_'+s] = true
      this.active = a
    },
    deselectActive(s='btn') {
      this.toggle['set_'+s] = false
      this.active = []
    },
    cloneNode(node) {
      node.id = this.$root.GenerateID('alnum',8)
      this.form.content[this.active[0]].content[this.active[1]].content.push({...node})
      this.setButton()
    },
    pushRow() {
      var id_gen = this.$root.GenerateID('alnum',16)
      var data = {
        props:{
          justify:undefined,
          align:undefined
        },
        id:id_gen,
        name:'Pantalla '+(this.global_id+1),
        content:[]
      }
      this.global_id++
      if (this.form.content.length==0) {
        this.form.active = id_gen
      }
      this.form.content.push({...data})
      this.setButton()
    },
    deleteRow(i,id) {
      this.$delete(this.form.content,i)
      let del = this.form.variable.map(item=>item.master).indexOf(id)
      this.form.variable.splice(del,1)
    },
    setButton(){
      var button 
      this.form.content.map((el,i)=>{
        var cc = this.form.variable.find((e)=> e.master==el.id)
        var data = this.variable
        data.id = this.$root.GenerateID('alnum',8)
        data.master = el.id
        data.text = el.name
        data.visible = true
        if (!cc) {
          this.form.variable.push({...data})
        }
      })
    },
    editButton(id,key,value){
      this.form.variable.map((el,i)=>{
        if (el.master==id) {
          el[key] = value
        }
      })
    },
    RenderFile(r,i){
      if (this.$refs[r+i[i.length-1]][0].lazyValue!==null) {
        const file = this.$refs[r+i[i.length-1]][0].lazyValue
        const reader = new FileReader()
        reader.onload = (e)=>{
          this.form.content[i[0]].content[i[1]].content[i[2]].props.maps.icons[i[3]].icon = e.target.result
        }
        reader.readAsDataURL(file)
      } else {
        this.form.content[i[0]].content[i[1]].content[i[2]].props.maps.icons[i[3]].icon = null
      }
    }
  },
  created:function() {
    this.Data();
    axios.post('Component/get')
    .then((response)=>{
      this.components = response.data
    })
    axios.post('Element/get')
    .then((response)=>{
      this.elements = response.data
    })
  }
})
Vue.component('render-post',{
  template: `
  <v-sheet>
    <v-row>
      <v-col cols="12">
        <v-btn v-for="(btn,b) in page.variable" @click="$root.Url($root.url.c+'-'+btn.master,null,'page');loaded=[]"
          v-if="($root.page.active!=btn.master && btn.visible==true)" class="mr-1" :color="btn.color" :key="btn.key">
          <v-icon>{{btn.icon}}</v-icon> {{btn.text}}
        </v-btn>
      </v-col>
    </v-row>
    <v-row v-for="screen in page.content" :align="screen.props.align?screen.props.align:undefined" v-if="$root.page.active==screen.id" no-gutters class="fill-height">
      <v-col cols="12" v-for="section in screen.content" :md="section.props.md?section.props.md:false">
        <div v-if="section.props.render=='section'">
          <v-sheet v-for="node in section.content">
            <div v-if="node.type=='element'">
              <component :is="node.codename" :content="node.content" v-bind="{attr:node.attr}" @loading-screen="addLoaded"></component>
            </div>
            <div v-else>
              <component :is="node.codename" v-bind="$router.history.current.query" :key="'CHART-'+node.id+'-'+$root.t_key" @loading-screen="addLoaded" v-if="node.template=='chart'"></component>
              <component :is="node.codename" v-bind="node.props" @loading-screen="addLoaded" v-else></component>
            </div>
          </v-sheet>
        </div>
        <div v-if="section.props.render=='maps'">
          <v-card style="height: calc(74vh);">
            <l-map :center="[6.795535,-64.379883]" :zoom="5">
              <l-control-layers position="topleft"></l-control-layers>
              <l-tile-layer v-for="(tilelayer,t) in tilelayers" :url="tilelayer.url" :key="'tile-'+t" :name="tilelayer.name" :visible="tilelayer.visible" :attribution="tilelayer.attribution" layer-type="base"></l-tile-layer>
              <component v-for="node in section.content" :is="node.codename" v-bind="node.props" @loading-screen="addLoaded"></component>
            </l-map>
          </v-card>
        </div>
      </v-col>
    </v-row>
  </v-sheet>
  `,
  data:()=>{
    return {
      loaded:[],
      tilelayers:[
        {
          name:'OpenStreetMap Standard',
          visible:true,
          url:'http://a.tile.openstreetmap.org/{z}/{x}/{y}.png',
          attribution:'&copy; <a target="_blank" href="http://osm.org/copyright">OpenStreetMap</a>'
        },
        {
          name:'OpenStreetMap Mapnick',
          visible:false,
          url:'http://tile.openstreetmap.org/{z}/{x}/{y}.png',
          attribution:'&copy; <a target="_blank" href="http://osm.org/copyright">OpenStreetMap</a>'
        },
        {
          name:'ESRI Topo',
          visible:false,
          url:'https://server.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer/tile/{z}/{y}/{x}',
          attribution:'&copy; ESRI'
        },
        {
          name:'ESRI Terrain',
          visible:false,
          url:'https://server.arcgisonline.com/ArcGIS/rest/services/World_Terrain_Base/MapServer/tile/{z}/{y}/{x}',
          attribution:'&copy; ESRI'
        },
        {
          name:'ESRI Physical',
          visible:false,
          url:'https://server.arcgisonline.com/ArcGIS/rest/services/World_Physical_Map/MapServer/tile/{z}/{y}/{x}',
          attribution:'&copy; ESRI'
        },
        {
          name:'Google Satellite',
          visible:false,
          url:'http://www.google.cn/maps/vt?lyrs=s@189&gl=cn&x={x}&y={y}&z={z}',
          attribution:'&copy; Google'
        },
        {
          name:'Google Maps',
          visible:false,
          url:'https://mt1.google.com/vt/lyrs=r&x={x}&y={y}&z={z}',
          attribution:'&copy; Google'
        },
        {
          name:'Stamen Terrain',
          visible:false,
          url:'http://a.tile.stamen.com/terrain/{z}/{x}/{y}.png',
          attribution:'&copy; Google'
        },
      ],
      tilelayer_active:0
    }
  },
  props:['page'],
  methods:{
    addLoaded:function(c){
      this.loaded.push(c)
    }
  },
  created:function() {
  }
})
Vue.component('render-page',{
  template: `
  <v-container fluid class="px-0 pt-9">
    <v-row v-for="screen in page.content" :align="screen.props.align?screen.props.align:undefined" no-gutters class="fill-height">
      <v-col cols="12" v-for="section in screen.content" :md="section.props.md?section.props.md:false">
        <div v-if="section.props.render=='section'">
          <v-sheet v-for="node in section.content">
            <div v-if="node.type=='element'">
              <component :is="node.codename" :content="node.content" v-bind="{attr:node.attr}" :attr="node.attr"></component>
            </div>
            <div v-else>
              <component :is="node.codename" v-bind="$router.history.current.query" :key="'CHART-'+node.id+'-'+$root.t_key" @loading-screen="addLoaded" v-if="node.template=='chart'"></component>
              <component :is="node.codename" v-bind="node.props" v-else></component>
            </div>
          </v-sheet>
        </div>
        <div v-if="section.props.render=='maps'">
          <v-card style="height: calc(74vh);">
            <l-map :center="[6.795535,-64.379883]" :zoom="5">
              <l-control-layers position="topleft"></l-control-layers>
              <l-tile-layer v-for="(tilelayer,t) in tilelayers" :url="tilelayer.url" :key="'tile-'+t" :name="tilelayer.name" :visible="tilelayer.visible" :attribution="tilelayer.attribution" layer-type="base"></l-tile-layer>
              <component v-for="node in section.content" :is="node.codename" v-bind="node.props"></component>
            </l-map>
          </v-card>
        </div>
      </v-col>
    </v-row>
  </v-container>
  `,
  data:()=>{
    return {
      loaded:[],
      tilelayers:[
        {
          name:'OpenStreetMap Standard',
          visible:true,
          url:'http://a.tile.openstreetmap.org/{z}/{x}/{y}.png',
          attribution:'&copy; <a target="_blank" href="http://osm.org/copyright">OpenStreetMap</a>'
        },
        {
          name:'OpenStreetMap Mapnick',
          visible:false,
          url:'http://tile.openstreetmap.org/{z}/{x}/{y}.png',
          attribution:'&copy; <a target="_blank" href="http://osm.org/copyright">OpenStreetMap</a>'
        },
        {
          name:'ESRI Topo',
          visible:false,
          url:'https://server.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer/tile/{z}/{y}/{x}',
          attribution:'&copy; ESRI'
        },
        {
          name:'ESRI Terrain',
          visible:false,
          url:'https://server.arcgisonline.com/ArcGIS/rest/services/World_Terrain_Base/MapServer/tile/{z}/{y}/{x}',
          attribution:'&copy; ESRI'
        },
        {
          name:'ESRI Physical',
          visible:false,
          url:'https://server.arcgisonline.com/ArcGIS/rest/services/World_Physical_Map/MapServer/tile/{z}/{y}/{x}',
          attribution:'&copy; ESRI'
        },
        {
          name:'Google Satellite',
          visible:false,
          url:'http://www.google.cn/maps/vt?lyrs=s@189&gl=cn&x={x}&y={y}&z={z}',
          attribution:'&copy; Google'
        },
        {
          name:'Google Maps',
          visible:false,
          url:'https://mt1.google.com/vt/lyrs=r&x={x}&y={y}&z={z}',
          attribution:'&copy; Google'
        },
        {
          name:'Stamen Terrain',
          visible:false,
          url:'http://a.tile.stamen.com/terrain/{z}/{x}/{y}.png',
          attribution:'&copy; Google'
        },
      ],
      tilelayer_active:0,
      page:[]
    }
  },
  props:['slug'],
  methods:{
    Data:function() {
      this.$emit('loading-screen',true)
      axios.post('Post/get',{
        where:{
          slug:this.slug
        },
        result:'row'
      })
      .then((response)=>{
        this.page = response.data
        this.$emit('loading-screen',false)
      })
    },
  },
  created:function() {
    this.Data()
  }
})