Vue.component('importer',{
  template: `
  <v-form v-on:submit.prevent="!data?Upload():Save()">
    <v-row class="mb-2">
      <v-col cols="12" md="12">
        <v-card>
          <v-card-title>{{$t('module.importer')}} "{{name}}"</v-card-title>
          <v-card-text>
            <v-row v-show="!data">
              <v-col cols="12" sm="12" md="12">
                <v-file-input v-model="file" label="Archivo"></v-file-input>
              </v-col>
            </v-row>
            <v-row v-show="data">
              <v-col cols="12" sm="12" md="12">
                <v-file-input v-model="file" label="Archivo"></v-file-input>
              </v-col>
              <v-col cols="12" sm="12" md="12">
                <v-chip-group v-model="fields" mandatory multiple>
                  <v-chip v-for="field in fields_list" :value="field" :color="fields.includes(field)?'primary':'red'" :outlined="!fields.includes(field)">
                    <v-icon v-if="fields.includes(field)">bi-check</v-icon>{{field}}
                  </v-chip>
                </v-chip-group>
              </v-col>
            </v-row>
            <v-card-actions class="text-center">
              <v-btn type="submit" color="success" v-if="!data">
                <v-icon>bi bi-cloud-arrow-up</v-icon> Subir Archivo
              </v-btn>
              <v-btn type="submit" color="primary" v-if="data">
                <v-icon>bi bi-cloud-arrow-up</v-icon> Importar Data
              </v-btn>
              <v-btn @click="Clean()" color="yellow" v-if="data">
                <v-icon>bi-trash</v-icon> Limpiar Campos
              </v-btn>
            </v-card-actions>
          </v-card-text>
        </v-card>
      </v-col>
    </v-row>
  </v-form>
  `,
  data:()=>{
    return {
      name:'',
      file:'',
      data:'',
      fields:[],
      fields_list:[],

    }
  },
  props:['title','loader'],
  methods:{
    Upload:function() {
      this.$emit('loading-screen')
      var formData = new FormData()
      formData.append('name',this.name)
      formData.append('file',this.file)
      axios.post('Importer/add',formData)
      .then((response)=>{
        this.invertCoordinates(response.data)
        this.fields_list = Object.keys(response.data.features[0].properties)
        this.fields = Object.keys(response.data.features[0].properties)
        this.data = response.data.features
        this.name = response.data.name
        this.$emit('loading-screen',false)
      })
    },
    Save:function() {
      this.$emit('loading-screen')
      axios.post('Importer/execute_import',{
        fields:this.fields,
        data:this.data,
        name:this.name
      }).then((response)=>{
        var code = response.data.code
        var message = code==200?response.data.message:response.data.message.message
        this.$root.toast.show({
          message:message,
          color:code==200?'teal':'red',
          icon:code==200?'bi-check':'bi-exclamation-circle',
          system:true
        })
        if (code==200) {
          this.Clean();
        }
        this.$emit('loading-screen',false)
      })
    },
    Clean:function() {
      this.name=''
      this.file=''
      this.data=''
      this.fields=[]
      this.fields_list=[]
    },
    invertCoordinates:function(geojson) {
      if (geojson.type==='Feature') {
        return {
          ...geojson,
          geometry:this.invertGeometryCoordinates(geojson.geometry)
        }
      }
      if (geojson.type==='FeatureCollection') {
        return {
          ...geojson,
          features:geojson.features.map(feature=>this.invertCoordinates(feature))
        }
      }
    },
    invertCoordinatesArray:function(coordinates) {
      return coordinates.reverse()
    },
    invertGeometryCoordinates:function(geometry) {
      const type = geometry.type
      switch(type){
        case 'Point':
        return {
          ...geometry,
          coordinates:this.invertCoordinatesArray(geometry.coordinates)
        };
        case 'MultiPoint':
        case 'LineString':
        return {
          ...geometry,
          coordinates:this.invertCoordinatesArray(geometry.coordinates)
        };
        case 'MultiLineString':
        case 'Polygon':
        return {
          ...geometry,
          coordinates:geometry.coordinates.map(coordinates=>coordinates.map(coords=>coords.reverse()))
        };
        case 'MultiPolygon':
        return {
          ...geometry,
          coordinates:geometry.coordinates.map(polygons=>polygons.map(coordinates=>coordinates.map(coords=>this.invertCoordinatesArray(coords))))
        };
        case 'GeometryCollection':
        return {
          ...geometry,
          geometries:geometry.geometries.map(geometry=>this.invertGeometryCoordinates(geometry))
        };
      }
    }
  },
  mounted:function() {
    this.$emit('loading-screen',false)
  }
})
Vue.component('toponimia',{
  template: `
  <div class="page-content">
    <div class="container">
      <div class="row">
        <div class="col-md">
          <pre>{{locations}}</pre>
        </div>
      </div>
    </div>
  </div>
  `,
  data:()=>{
    return {
      locations:[],
    }
  },
  props:['action'],
  methods:{
    Data:function() {
      const latitude = 10.4880
      const longitude = -66.8792
      const radius = 100
      const query = `[out:json];(node(around:${radius},${latitude},${longitude});way(around:${radius},${latitude},${longitude});relation(around:${radius},${latitude},${longitude}););out;`;
      axios.get(`https://overpass-api.de/api/interpreter?data=${encodeURIComponent(query)}`).then((response)=>{
        const data = response.data
        if (data && data.elements) {
          data.elements.map((element)=>{
            if (element.lat && element.lon) {
              this.getPoint(element.lat,element.lon)
            }
          })
        }
      })
    },
    async getPoint(lat,lon) {
      await axios.post('https://nominatim.openstreetmap.org/reverse?format=json&lat='+lat+'&lon='+lon).then((response)=>{
        const point = response.data
        console.log(point)
        this.locations.push({... {id:point.place_id,name:point.display_name,lat:point.x,lon:point.y} })
      })
    }
  },
  created:function() {
    this.$emit('loading-screen',false)
    this.Data();
  }
})