<?php
$db = db_connect();
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <title><?=env('APP_NAME')?></title>
  <meta name="description" content="The small framework with powerful features">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, minimal-ui">
  <link rel="shortcut icon" type="image/png" href="/favicon.ico" />
  <!-- Favicons -->
  <link href="<?= base_url('public/theme') ?>/assets/img/favicon.png" rel="icon">
  <link href="<?= base_url('public/theme') ?>/assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Vendor CSS Files -->
  <link href="<?= base_url('public/theme') ?>/assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/assets/css/icon-ui.css" rel="stylesheet">

  <!--link href="https://fonts.googleapis.com/css?family=Roboto:100,300,400,500,700,900" rel="stylesheet"-->
  <link href="https://cdn.jsdelivr.net/npm/@mdi/font@6.x/css/materialdesignicons.min.css" rel="stylesheet">
  <link href="<?= base_url('public/theme/vue') ?>/css/vuetify.min.css" rel="stylesheet">
  <link rel="stylesheet" href="<?= base_url('public/theme/leaflet') ?>/leaflet.css" />
  <script src="<?= base_url('public/theme/leaflet') ?>/leaflet.js"></script>


  <script src="<?= base_url('public/theme/vue/vue.js') ?>"></script>
  <script src="<?= base_url('public/theme/vue/axios.min.js') ?>"></script>

  <script src="<?= base_url('public/plugins/jspdf.min.js') ?>"></script>
  <script src="<?= base_url('public/plugins/jspdf.plugin.autotable.js') ?>"></script>

  <script src="<?= base_url('public/plugins/echart.js') ?>"></script>
  <script src="<?= base_url('public/plugins/vue-echarts.js') ?>"></script>

  <?php
  $js_folder = "public/theme/vue/js";
  $files = array_diff(scandir(FCPATH . "/{$js_folder}"), array('.', '..'));
  ?>
  <?php foreach ($files as $filename): ?>
  <script src="<?= base_url("{$js_folder}/{$filename}") ?>"></script>
  <?php endforeach ?>

  <script src="<?= base_url('public/node_modules/ckeditor4/ckeditor.js') ?>"></script>
  <script src="<?= base_url('public/node_modules/ckeditor4-vue/dist/ckeditor.js') ?>"></script>
  <script>
    const router = new VueRouter({
      mode: 'history',
      base: '',
      routes: []
    })
    //window.Vue2Transitions
    //Vue.use(Vue2Transitions)
  </script>
  <?php
  $components_folder = FCPATH . "/public/components";
  $files = array_diff(scandir($components_folder), array('.', '..'));
  $components = [];
  $components['security'] = 'security';
  ?>
  <?php foreach ($files as $filename): ?>
  <script src="<?= base_url("public/components/{$filename}") ?>"></script>
  <?php endforeach ?>
  <?php
  $files = $db->table('sys_component')->get()->getResultArray();
  ?>
  <?php foreach ($files as $filename): ?>
  <?php $components[$filename['codename']] = $filename['codename'] ?>
  <script src="<?= base_url("Module/renders/{$filename['ID']}") ?>"></script>
  <?php endforeach ?>

  <style>
    .bg_pattern {
      background: linear-gradient(135deg, #3b3b3b 0%, #121212 100%)
    }
  </style>
  <!-- Template Main CSS File -->
</head>
<?php
$set = $security;
$model = [];
$model[$set['fields']['user']] = '';
$model[$set['fields']['password']] = '';

$email_label = $set['fields']['email']?"o Correo":"";
$label[$set['fields']['user']] = "Usuario {$email_label}";
$label[$set['fields']['password']] = 'Contraseña';

$reg_label[$set['fields']['name']] = 'Nombre';
$reg_label[$set['fields']['user']] = 'Usuario';
$reg_label[$set['fields']['email']] = 'Correo';
$reg_label[$set['fields']['password']] = 'Contraseña';

$reg_model[$set['fields']['name']] = '';
$reg_model[$set['fields']['user']] = '';
$reg_model[$set['fields']['email']] = '';
$reg_model[$set['fields']['password']] = '';

$rec_label[$set['fields']['email']] = 'Correo';
$rec_label[$set['fields']['password']] = 'Contraseña';
$rec_label['token'] = 'Token';

$rec_model[$set['fields']['email']] = '';
$rec_model[$set['fields']['password']] = '';
$rec_model['token'] = '';
?>
<body>
  <div id="app">
    <v-app>
      <v-main app>
        <v-container fill-height fluid :style="<?= str_replace('"',"'",json_encode($interface['session']['style']))?>">
          <v-row class="d-flex justify-center">
            <v-col cols="12" md="4" v-show="tab=='login'">
              <v-card elevation="12" outlined color="<?=$interface['session']['color']?>" <?=$interface['session']['dark']?'dark':''?>>
                <?php if ($interface['logo']['file']): ?>
                  <v-img src="<?=$interface['logo']['file']?>"></v-img>
                <?php endif ?>
                <v-card-title class="text-center">
                  INICIO DE SESION
                </v-card-title>
                <v-card-subtitle><?= $_ENV['APP_NAME']?></v-card-subtitle>
                <v-divider></v-divider>
                <v-card-text>
                  <v-row>
                    <v-col cols="12">
                      <v-text-field v-model="login.<?= $set['fields']['user']?>" :label="label_login.<?= $set['fields']['user']?>"></v-text-field>
                      <v-text-field :type="hide?'password':'text'" v-model="login.<?= $set['fields']['password']?>" :label="label_login.<?= $set['fields']['password']?>" :append-icon="hide?'ri-eye-line':'ri-eye-close-line'" @click:append="hide=!hide"></v-text-field>
                      <v-row>
                        <v-col>
                          <v-btn color="primary" block @click="Login()" :disabled="login.<?= $set['fields']['user']?>!=='' && login.<?= $set['fields']['password']?>!==''?false:true">
                            <v-icon>ri-door-open-line</v-icon> ENTRAR
                          </v-btn>
                        </v-col>
                        <?php if ($set['allow_register']): ?>
                          <v-col>
                            <v-btn color="teal" block @click="tab='register'">
                              <v-icon>bi-person-plus</v-icon> REGISTRARME
                            </v-btn>
                          </v-col>
                        <?php endif ?>
                      </v-row>
                      <v-row>
                        <v-col>
                          <v-btn color="teal" text block @click="tab='recovery'" class="font-weight-black">
                            <v-icon>bi-info</v-icon> Cambiar contraseña
                          </v-btn>
                        </v-col>
                      </v-row>
                    </v-col>
                  </v-row>
                </v-card-text>
              </v-card>
            </v-col>
            <v-col cols="12" md="5" v-show="tab=='register'">
              <v-card elevation="5" outlined color="<?=$interface['session']['color']?>" <?=$interface['session']['dark']?'dark':''?>>
                <v-card-title>
                  REGISTRO DE USUARIO
                </v-card-title>
                <v-card-subtitle><?= $_ENV['APP_NAME']?></v-card-subtitle>
                <v-divider></v-divider>
                <v-card-text>
                  <form v-on:submit.prevent="Register()">
                    <v-row>
                      <v-col cols="12">
                        <v-text-field required v-model="register.<?= $set['fields']['name']?>" :label="label_register.<?= $set['fields']['name']?>"></v-text-field>
                        <v-text-field required v-model="register.<?= $set['fields']['user']?>" :label="label_register.<?= $set['fields']['user']?>"></v-text-field>
                        <v-text-field required v-model="register.<?= $set['fields']['email']?>" :label="label_register.<?= $set['fields']['email']?>"></v-text-field>
                        <v-row>
                          <v-col cols="12" md="6">
                            <v-text-field :type="hide?'password':'text'" required v-model="register.<?= $set['fields']['password']?>" :label="label_login.<?= $set['fields']['password']?>" :append-icon="hide?'ri-eye-line':'ri-eye-close-line'" @click:append="hide=!hide"></v-text-field>
                          </v-col>
                          <v-col cols="12" md="6">
                            <v-text-field :type="hide?'password':'text'" v-model="valid_password" :label="label_login.<?= $set['fields']['password']?>" :append-icon="hide?'ri-eye-line':'ri-eye-close-line'" @click:append="hide=!hide"></v-text-field>
                          </v-col>
                        </v-row>
                        <v-row>
                          <v-col>
                            <v-btn color="teal" block @click="tab='login'">
                              <v-icon>ri-door-open-line</v-icon> INICIAR SESION
                            </v-btn>
                          </v-col>
                          <v-col>
                            <v-btn color="primary" type="submit" :disabled="register.<?= $set['fields']['password']?> && (register.<?= $set['fields']['password']?>==valid_password)?false:true" block>
                              <v-icon>bi-person-plus</v-icon> GUARDAR DATOS
                            </v-btn>
                          </v-col>
                        </v-row>
                      </v-col>
                    </v-row>
                  </form>
                </v-card-text>
              </v-card>
            </v-col>
            <v-col cols="12" md="5" v-show="tab=='recovery'">
              <v-card elevation="5" outlined color="<?=$interface['session']['color']?>" <?=$interface['session']['dark']?'dark':''?>>
                <v-card-title>
                  RECUPERACION DE CONTRASEÑA
                </v-card-title>
                <v-card-subtitle><?= $_ENV['APP_NAME']?></v-card-subtitle>
                <v-divider></v-divider>
                <v-card-text>
                  <form v-on:submit.prevent="Recovery()">
                    <v-row>
                      <v-col cols="12">
                        <v-row>
                          <v-col cols="8">
                            <v-text-field required v-model="recovery.<?= $set['fields']['email']?>" :label="label_register.<?= $set['fields']['email']?>"></v-text-field>
                          </v-col>
                          <v-col cols="4">
                            <v-btn color="primary" :disabled="recovery.<?= $set['fields']['email']?>?false:true" block @click="SendToken()">
                              <v-icon>mdi-send-circle-outline</v-icon> Enviar
                            </v-btn>
                          </v-col>
                        </v-row>
                        <v-text-field v-if="send_token==true" required v-model="recovery.token" label="Token"></v-text-field>
                        <v-row v-if="send_token==true">
                          <v-col cols="12" md="6">
                            <v-text-field :type="hide?'password':'text'" required v-model="recovery.<?= $set['fields']['password']?>" :label="label_recovery.<?= $set['fields']['password']?>" :append-icon="hide?'ri-eye-line':'ri-eye-close-line'" @click:append="hide=!hide"></v-text-field>
                          </v-col>
                          <v-col cols="12" md="6">
                            <v-text-field :type="hide?'password':'text'" v-model="valid_password" :label="label_recovery.<?= $set['fields']['password']?>" :append-icon="hide?'ri-eye-line':'ri-eye-close-line'" @click:append="hide=!hide"></v-text-field>
                          </v-col>
                        </v-row>
                        <v-row v-if="send_token==true">
                          <v-col>
                            <v-btn color="primary" type="submit" :disabled="recovery.<?= $set['fields']['password']?> && (recovery.<?= $set['fields']['password']?>==valid_password)?false:true" block>
                              <v-icon>bi-lock</v-icon> Cambiar contraseña
                            </v-btn>
                          </v-col>
                        </v-row>
                        <v-row>
                          <v-col>
                            <v-btn color="teal" block @click="tab='login'">
                              <v-icon>ri-door-open-line</v-icon> INICIAR SESION
                            </v-btn>
                          </v-col>
                          <v-col>
                            <v-btn color="teal" block @click="tab='register'">
                              <v-icon>bi-person-plus</v-icon> Registrarme
                            </v-btn>
                          </v-col>
                        </v-row>
                      </v-col>
                    </v-row>
                  </form>
                </v-card-text>
              </v-card>
            </v-col>
          </v-row>
        </v-container>
        <v-toast ref="toast"/>
      </v-main>
    </v-app>
  </div>

  <script>
    const messages = {
      en: {
        action: {
          add: 'Add',
          read:'List',
          view: 'Details',
          delete: 'Delete',
          update: 'Update',
          open: 'Open',
          close: 'Close',
          save: 'Save',
        },
        section: {
          module: 'Module',
          component: 'Component',
          element: 'Element',
          record: 'Record'
        },
        form: {
          response:{
            success:"Success!"
          }
        },
        status:{
          active:"Active",
          inactive:"Inactive"
        },
        alert: {
          delete: "This {el} will be permanently removed"
        }
      },
      es: {
        action: {
          add: 'Agregar',
          read:'Listado',
          view: 'Detalles',
          delete: 'Eliminar',
          update: 'Actualizar',
          open: 'Abrir',
          close: 'Cerrar',
          save: 'Guardar',
        },
        section: {
          module: 'Modulo',
          component: 'Componente',
          element: 'Elemento',
          record: 'Registro'
        },
        form: {
          response:{
            success:"Éxito!"
          }
        },
        status:{
          active:"Activo",
          inactive:"Inactivo"
        },
        alert: {
          delete: "Este {el} sera eliminado de forma permanente"
        }
      }
    }
    const i18n = new VueI18n({
      locale: 'en',
      messages
    })
  </script>
  <script>
    var app = new Vue({
      router,
      i18n,
      el: "#app",
      vuetify: new Vuetify(),
      data: {
        tab:'login',
        login: <?= json_encode($model)?>,
        register: <?= json_encode($reg_model)?>,
        recovery: <?= json_encode($rec_model)?>,
        label_login: <?= json_encode($label)?>,
        label_register: <?= json_encode($reg_label)?>,
        label_recovery: <?= json_encode($rec_label)?>,
        valid_password:'',
        send_token:false,
        token:'',
        hide:true,
        dark_mode: false,
        t_key: 1
      },
      methods: {
        Login: function(){
          axios.post('Session/LogIn',{
            data:this.login
          }).then((res) => {
            this.toast.show({
              message:res.data.message,
              color: res.data.success? 'success': 'error',
              icon: res.data.success? 'ri-check-line': 'ri-error-warning-line',
            })
            if (res.data.success) {
              setTimeout(()=>{
                if (res.data.session.role == 'admin') {
                  window.location = '<?= site_url() ?>Admin'
                } else {
                  window.location = '<?= site_url() ?>Web'
                }
              },(this.toast.timer/3))
            }
          })
        },
        Register: function(){
          axios.post('Session/Register',{
            data:this.register
          }).then((res) => {
            this.toast.show({
              message:res.data.message,
              color: res.data.success? 'success': 'error',
              icon: res.data.success? 'ri-check-line': 'ri-error-warning-line',
            })
            if (res.data.success) {
              this.tab='login'
            }
          })
        },
        Recovery: function(){
          if(this.recovery.token == this.token){
            axios.post('Session/Recovery',{
              data:this.recovery
            }).then((res) => {
              this.toast.show({
                message:res.data.message,
                color: res.data.success? 'success': 'error',
                icon: res.data.success? 'ri-check-line': 'ri-error-warning-line',
              })
              if (res.data.success) {
                this.tab='login'
              }
            })
          } else {
            this.toast.show({
              message:'El Token es invalido',
              color: 'error',
              icon:'ri-error-warning-line',
            })
          }
        },
        SendToken: function(){
          axios.post('Security/SendToken',{
            data:this.recovery
          }).then((res) => {
            this.token = res.data.token
            this.send_token = true
            this.toast.show({
              message:res.data.message,
              color: res.data.success? 'success': 'error',
              icon: res.data.success? 'ri-check-line': 'ri-error-warning-line',
            })
          })
        },
        DarkMode: function (onoff) {
          this.$vuetify.theme.dark = onoff
        }
      },
      created: function () {
        this.$vuetify.theme.dark = this.dark_mode
        document.title = '<?= $_ENV['APP_NAME']?>'
      },
      mounted() {
        this.toast = this.$refs.toast
      },
    })
  </script>
</body>

</html>