Vue.component('security-create',{
  template: `
  <v-card>
    <v-card-title>{{title}} - Crear tabla "{{form.name}}"</v-card-title>
    <v-card-text>
      <v-form v-on:submit.prevent="Save()">
        <v-row class="mb-2">
          <v-col cols="12" md="12">
            <v-text-field v-model="form.name" label="Nombre de la Tabla"></v-text-field>
          </v-col>
          <v-col cols="12" md="12">
            <v-simple-table>
              <template v-slot:default>
                <thead>
                  <tr>
                    <td colspan="8" class="text-center"><strong>CAMPOS</strong></td>
                  </tr>
                  <tr>
                    <td>Nombre</td>
                    <td>Tipo</td>
                    <td>Longitud</td>
                    <td>Sin Signo</td>
                    <td><i>NULL</i>?</td>
                    <td>Auto-Incrementar</td>
                    <td>Predeterminado</td>
                    <td></td>
                  </tr>
                </thead>
                <tbody>
                  <tr v-for="(field,f) in form.fields">
                    <td><v-text-field v-model="form.fields[f]['name']" dense></v-text-field></td>
                    <td>
                      <v-select v-model="form.fields[f]['type']" :items="option.type" item-text="item" item-value="item" dense></v-select>
                    </td>
                    <td><v-text-field v-model="form.fields[f]['length']" dense></v-text-field></td>
                    <td><v-checkbox v-model="form.fields[f]['unsigned']" dense></v-checkbox></td>
                    <td><v-checkbox v-model="form.fields[f]['nullable']" dense></v-checkbox></td>
                    <td><v-checkbox v-model="form.fields[f]['auto_increment']" dense></v-checkbox></td>
                    <td><v-text-field v-model="form.fields[f]['default']" dense></v-text-field></td>
                    <td></td>
                  </tr>
                </tbody>
                <tfoot>
                  <tr>
                    <td colspan="6" class="text-center"></td>
                    <td colspan="2" class="text-center">
                      <v-btn @click="addField">CAMPOS</v-btn>
                    </td>
                  </tr>
                </tfoot>
              </template>
            </v-simple-table>
          </v-col>
          <v-col cols="12" md="12">
            <v-simple-table>
              <template v-slot:default>
                <thead>
                  <tr>
                    <td colspan="8" class="text-center"><strong>CLAVES PRIMARIAS</strong></td>
                  </tr>
                  <tr>
                    <td width="20%">Indice</td>
                    <td width="80%">Campos</td>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td>Primary</td>
                    <td>
                      <v-select v-model="form.index.primary" :items="form.fields" item-text="name" item-value="name" multiple dense small-chips="true" prepend-icon="bi-key" chips color="orange" item-color="orange">
                        <template v-slot:selection="{item}">
                          <v-chip color="orange" small>{{item.name}}</v-chip>
                        </template>
                      </v-select>
                    </td>
                  </tr>
                  <tr>
                    <td>Key</td>
                    <td>
                      <v-select v-model="form.index.key" :items="form.fields" item-text="name" item-value="name" multiple dense small-chips="true" prepend-icon="bi-key" chips color="green" item-color="green">
                        <template v-slot:selection="{item}">
                          <v-chip color="green" small>{{item.name}}</v-chip>
                        </template>
                      </v-select>
                    </td>
                  </tr>
                  <tr>
                    <td>Unique</td>
                    <td>
                      <v-select v-model="form.index.unique" :items="form.fields" item-text="name" item-value="name" multiple dense small-chips="true" prepend-icon="bi-key" chips color="red" item-color="red">
                        <template v-slot:selection="{item}">
                          <v-chip color="red" small>{{item.name}}</v-chip>
                        </template>
                      </v-select>
                    </td>
                  </tr>
                </tbody>
              </template>
            </v-simple-table>
          </v-col>
          <v-col cols="12" md="12">
            <v-simple-table>
              <template v-slot:default>
                <thead>
                  <tr>
                    <td colspan="7" class="text-center"><strong>CLAVES FORANEAS</strong></td>
                  </tr>
                  <tr>
                    <td>Campos</td>
                    <td>Referencia</td>
                    <td>Campos foraneos</td>
                    <td>En <strong>UPDATE</strong></td>
                    <td>En <strong>DELETE</strong></td>
                    <td></td>
                  </tr>
                </thead>
                <tbody>
                  <tr v-for="(key,k) in form.keys">
                    <td>{{form.keys[k]['fields']}}</td>
                    <td>{{form.keys[k]['table']}}</td>
                    <td>{{form.keys[k]['foreign_fields']}}</td>
                    <td>{{form.keys[k]['on_update']}}</td>
                    <td>{{form.keys[k]['on_delete']}}</td>
                    <td></td>
                  </tr>
                </tbody>
                <tfoot>
                  <tr>
                    <td><v-select v-model="key.fields" :items="form.fields" item-text="name" item-value="name" small-chips chips multiple dense></v-select></td>
                    <td><v-select v-model="key.table" @change="fillOptions(key.table)" :items="option.tables" item-text="item" item-value="item" dense></v-select></td>
                    <td><v-select v-model="key.foreign_fields" :items="option.fields" item-text="item" item-value="item" multiple dense></v-select></td>
                    <td><v-select v-model="key.on_update" :items="option.on_action" item-text="item" item-value="item" dense></v-select></td>
                    <td><v-select v-model="key.on_delete" :items="option.on_action" item-text="item" item-value="item" dense></v-select></td>
                    <td><v-btn @click="addKey(key)" fab x-small><v-icon>ri-save-3-line</v-icon></v-btn></td>
                  </tr>
                </tfoot>
              </template>
            </v-simple-table>
          </v-col>
        </v-row>
        <v-card-actions class="text-center">
          <v-btn type="submit" color="success">
            <v-icon>bi bi-cloud-arrow-up</v-icon> Guardar
          </v-btn>
        </v-card-actions>
      </v-form>
    </v-card-text>
  </v-card>
  `,
  data:()=>{
    return {
      form:{
        name:'Tabla',
        fields:[],
        index:{
          primary:[],
          key:[],
          unique:[],
        },
        keys:[]
      },
      key:{
        fields:[],
        table:'',
        foreign_fields:[],
        on_update:'RESTRICT',
        on_delete:'RESTRICT'
      },
      option:{
        type:[
          'TINYINT',
          'SMALLINT',
          'MEDIUMINT',
          'INT',
          'BIGINT',
          'BIT',

          'FLOAT',
          'DOUBLE',
          'DECIMAL',

          'VARCHAR',
          'CHAR',
          'TINYTEXT',
          'TEXT',
          'MEDIUMTEXT',
          'LONGTEXT',
          'JSON',

          'DATE',
          'TIME',
          'YEAR',
          'DATETIME',
          'TIMESTAMP'
        ],
        tables:[],
        fields:[],
        on_action:['RESTRICT','CASCADE','SET NULL','NO ACTION']
      }
    }
  },
  props:['title'],
  methods:{
    Save:function() {
      axios.post(this.$root.p+'/add',{
        data:this.form
      })
      .then((response)=>{
        if (response.data.status==500) {
          alert('Error '+response.data.message.code+': '+response.data.message.message)
        } else{
          router.push({query:{p:this.$root.p}})
        }
      })
    },
    tableFields:function() {
      axios.post(this.$root.p+'/get_tables/'+this.form.table)
      .then((response)=>{
        this.option.tables = response.data
      })
    },
    fillOptions:function(table=null) {
      axios.post(this.$root.p+'/get_tables/'+this.key.table+'?field=name')
      .then((response)=>{
        this.option.fields = response.data
      })
    },
    addField() {
      var count = this.form.fields.length+1
      this.form.fields.push({...{
        name:'campo_'+count,
        type:'VARCHAR',
        length:'255',
        unsigned:false,
        nullable:true,
        auto_increment:false,
        default:''
      }})
    },
    addKey(data) {
      var count = this.form.keys.length+1
      this.form.keys.push({... data })
      this.key = {
        fields:[],
        table:'',
        foreign_fields:[],
        on_update:'RESTRICT',
        on_delete:'RESTRICT'
      }
    }
  },
  created:function() {
    axios.post(this.$root.p+'/get_tables')
    .then((response)=>{
      this.option.tables = response.data
    })
  }
})