Vue.component('element',{
  template: `
  <v-sheet fluid>
    <v-toolbar>
      <v-toolbar-title>{{$t(page.title)}}</v-toolbar-title>
      <v-spacer></v-spacer>
      <v-btn fab color="success" small v-if="$root.url.permission.includes('create')">
        <v-icon>bi-plus</v-icon>
      </v-btn>
    </v-toolbar>
    <v-data-iterator :items="tables" :items-per-page="iterator.items_per_page" :page="iterator.page" :search="iterator.search" hide-default-footer>
      <template v-slot:header>
        <v-toolbar class="mb-1" color="primary">
          <v-text-field v-model="iterator.search" clearable flat solo hide-details prepend-inner-icon="bi-search" :label="$t('action.search')"></v-text-field>
        </v-toolbar>
      </template>
      <template v-slot:default="props">
        <v-row>
          <v-col cols="12" sm="6" md="3" v-for="(row,r) in props.items">
            <v-card dense flat outlined>
              <v-card-title>{{row.name}}</v-card-title>
              <v-divider></v-divider>
              <v-card-text>
                <v-list dense>
                  <v-subheader>CAMPOS</v-subheader>
                  <v-list-item v-for="field in row.fields" dense>
                    <v-list-item-icon>
                      <v-icon v-if="field.type=='varchar'">ri-text</v-icon>
                      <v-icon v-else-if="field.type=='text' || field.type=='longtext'">ri-file-text-line</v-icon>
                      <v-icon v-else-if="field.type=='int' || field.type=='bigint'">bi-sort-numeric-down</v-icon>
                      <v-icon v-else-if="field.type=='date'">ri-calendar-event-line</v-icon>
                      <v-icon v-else>{{field.type}}</v-icon>
                    </v-list-item-icon>
                    <v-list-item-title>{{field.name}}</v-list-item-title>
                  </v-list-item>
                </v-list>
              </v-card-text>
              <v-card-actions class="d-flex justify-space-between" v-if="$root.url.permission">
                <v-btn v-if="$root.url.permission.includes('read')" @click="$root.Url('read-'+$root.url.c,row.name)" color="teal" icon dark x-small>
                  <v-icon>{{'bi bi-eye'}}</v-icon>
                </v-btn>
                <v-btn v-if="$root.url.permission.includes('update')" @click="$root.Url('update-'+$root.url.c,row.name)" color="indigo" icon dark x-small>
                  <v-icon>{{'bi bi-pencil-square'}}</v-icon>
                </v-btn>
                <v-btn v-if="$root.url.permission.includes('delete')" @click="$root.Url('delete-'+$root.url.c,row.name)" color="red" icon dark x-small>
                  <v-icon>{{'bi bi-trash'}}</v-icon>
                </v-btn>
              </v-card-actions>
            </v-card>
          </v-col>
        </v-row>
      </template>
      <template v-slot:footer>
        <v-row class="mt-2" align="center" justify="center">
          <v-spacer></v-spacer>
          <v-menu offset-y>
            <template v-slot:activator="{ on, attrs }">
              <v-btn text color="primary" class="ml-2" v-bind="attrs" v-on="on">
                {{ iterator.items_per_page }}
                <v-icon>mdi-chevron-down</v-icon>
              </v-btn>
            </template>
            <v-list dense>
              <v-list-item v-for="n in 5" :key="n" @click="iterator.items_per_page=(n*iterator.items_per_page)">
                <v-list-item-title>{{ n*iterator.items_per_page }}</v-list-item-title>
              </v-list-item>
            </v-list>
          </v-menu>
          <v-spacer></v-spacer>
          <v-btn fab color="blue darken-3" class="mr-1" @click="prevPage" :disabled="iterator.page>1?false:true">
            <v-icon>bi-chevron-left</v-icon>
          </v-btn>
          <v-btn fab color="blue darken-3" class="mr-1" @click="nextPage" :disabled="iterator.page<number_of_pages?false:true">
            <v-icon>bi-chevron-right</v-icon>
          </v-btn>
          <v-spacer></v-spacer>
        </v-row>
      </template>
    </v-data-iterator>
  </v-sheet>
  `,
  data:()=>{
    return {
      page:{
        title:'module.database'
      },
      iterator:{
        items_per_page:12,
        page:1,
        search:null
      },
      tables:[],
    }
  },
  props:['action'],
  computed:{
    number_of_pages(){
      return Math.ceil(this.tables.length/this.iterator.items_per_page)
    }
  },
  methods:{
    Data:function() {
      this.$emit('loading-screen')
      axios.post(this.$root.url.c+'/get')
      .then((response)=>{
        this.tables = response.data
        this.$emit('loading-screen',false)
      })
    },
    editItem (item) {
      this.editedIndex = this.desserts.indexOf(item)
      this.editedItem = Object.assign({}, item)
      this.dialog = true
    },
    prevPage () {
      if (this.iterator.page-1 >= 1) this.iterator.page -= 1
    },
    nextPage () {
      if (this.iterator.page+1 <= this.number_of_pages) this.iterator.page += 1
    },
  },
  created:function() {
    this.Data();
  }
})
Vue.component('create-option',{
  template: `
  <v-card>
    <v-card-title>{{form.name}}</v-card-title>
    <v-divider horizontal></v-divider>
    <v-card-text>
      <v-form v-on:submit.prevent="Save()" class="card">
        <v-subheader>DATOS DEL COMPONENTE</v-subheader>
        <v-row class="mb-2">
          <v-col cols="12" sm="12" md="3">
            <v-select v-model="form.table" label="Tabla Principal" :items="database.tables" item-text="item" item-value="item" @change="tableFields()"></v-select>
          </v-col>
          <v-col cols="12" sm="12" md="3">
            <v-text-field v-model="form.name" label="Nombre del Componente"></v-text-field>
          </v-col>
          <v-col cols="12" sm="12" md="3">
            <v-text-field v-model="form.data.var" @keypress="isLetter($event)" label="Variable a exportar"></v-text-field>
          </v-col>
          <v-col cols="12" sm="12" md="3">
            <v-select v-model="form.type" :items="type_templates" item-text="text" item-value="value" label="Tipo de Nav"></v-select>
          </v-col>
        </v-row>
        <v-subheader>CONSTRUCTOR DE CONSULTA</v-subheader>
        <v-row class="mb-2 mt-2">
          <v-col cols="12" md="12">
            <v-row>
              <v-col>
                <v-btn color="primary" @click="form.query.rule.push({... {key:form.data[0].name,comparator:'Igual',value:'value',conector:null,escape:true}})"> Agregar Regla</v-btn>
                <v-btn color="info" @click="form.query.group.push({... {rule:[{key:form.data[0].name,comparator:'Igual',value:'value',conector:null,escape:true}],conector:null}})"> Agregar Grupo</v-btn>
              </v-col>
            </v-row>
            <v-row class="mb-2">
              <v-col cols="12" md="4" v-for="(rule,r) in form.query.rule" :key="'R'+r">
                <v-card :color="form.query.rule[r].conector?undefined:'blue lighten-5'" :shaped="form.query.rule[r].conector?true:false" outlined>
                  <v-card-subtitle>
                    <span class="lime--text text--darken-2 mr-1">{{form.query.rule[r].key}}</span>
                    <span class="blue--text text--darken-4 mr-1">{{query_exp[form.query.rule[r].comparator]}}</span>
                    <span :class="rule.escape?'green--text text--darken-2':'lime--text text--darken-2'">
                      {{rule.escape?"'"+form.query.rule[r].value+"'":form.query.rule[r].value}}
                    </span>
                    <span class="blue--text text--darken-4 mr-1" v-if="(r+1)!==form.query.rule.length">{{form.query.rule[r].conector?'OR':'AND'}}</span>
                  </v-card-subtitle>
                  <v-card-text class="pa-2" v-if="group_edit==null && rule_edit==r">
                    <v-row>
                      <v-col cols="12" sm="7">
                        <v-select dense solo v-model="form.query.rule[r].key" label="Campo" :items="form.data" item-text="name" item-value="name" ></v-select>
                      </v-col>
                      <v-col cols="12" sm="5">
                        <v-select dense solo v-model="form.query.rule[r].comparator" label="Operador" :items="['Igual','No Igual','Menor','Mayor','Menor o Igual','Mayor o Igual','Contiene']" item-text="item" item-value="item" ></v-select>
                      </v-col>
                    </v-row>
                    <v-select dense solo v-if="form.query.rule[r].escape==false" v-model="form.query.rule[r].value" label="Campo" :items="form.data" item-text="name" item-value="name" append-icon="bi-diamond" @click:append="form.query.rule[r].escape=!form.query.rule[r].escape"></v-select>
                    <v-text-field dense solo v-else v-model="form.query.rule[r].value" label="Valor" :items="form.data" item-text="name" item-value="name" append-icon="bi-filter-circle" @click:append="form.query.rule[r].escape=!form.query.rule[r].escape"></v-text-field>
                  </v-card-text>
                  <v-card-actions class="justify-space-between">
                    <v-btn fab color="info" x-small @click="group_edit==null && rule_edit==r?editQuery():editQuery(r)">
                      <v-icon>bi-pencil-square</v-icon>
                    </v-btn>
                    <v-btn fab color="error" x-small @click="$delete(form.query.rule,r)">
                      <v-icon>bi-trash</v-icon>
                    </v-btn>
                    <v-btn-toggle v-model="form.query.rule[r].conector" shaped v-if="(r+1)!==form.query.rule.length">
                      <v-btn color="info" value="OR" small>
                        OR
                      </v-btn>
                    </v-btn-toggle>
                  </v-card-actions>
                </v-card>
              </v-col>
            </v-row>
            <v-row>
              <v-col cols="12" md="12" v-for="(group,g) in form.query.group" :key="'G'+g">
                <v-card :color="form.query.group[g].conector?undefined:'blue lighten-4'" :shaped="form.query.group[g].conector?true:false" outlined>
                  <v-card-subtitle>
                    <span class="blue--text text--darken-4 mr-1">WHERE (</span>
                    <span class="lime--text text--darken-2 mr-1">{{form.query.group[g].rule.length}} Regla{{form.query.group[g].rule.length>1?'s':''}}</span>
                    <span class="blue--text text--darken-4 mr-1">)</span>
                    <span class="blue--text text--darken-4 mr-1" v-if="(g+1)!==form.query.group.length">{{form.query.group[g].conector?'OR':'AND'}}</span>
                  </v-card-subtitle> 
                  <v-card-text>
                    <v-row>
                      <v-col cols="12" md="4">
                        <v-btn color="primary" @click="form.query.group[g].rule.push({... {key:form.data[0].name,comparator:'Igual',value:'value',conector:null,escape:true}})"> Agregar Regla</v-btn>
                        <v-btn fab x-small color="error" @click="$delete(form.query.group,g)"><v-icon>bi bi-trash</v-icon></v-btn>
                        <v-btn-toggle v-model="form.query.group[g].conector" shaped v-if="(g+1)!==form.query.group.length">
                          <v-btn color="info" value="OR" small>
                            OR
                          </v-btn>
                        </v-btn-toggle>
                      </v-col>
                    </v-row>
                    <v-row>
                      <v-col cols="12" md="4" v-for="(rule,r) in form.query.group[g].rule" :key="'G'+g+'R'+r">
                        <v-card :color="form.query.group[g].rule[r].conector?undefined:'blue lighten-5'" :shaped="form.query.group[g].rule[r].conector?true:false" outlined>
                          <v-card-subtitle>
                            <span class="lime--text text--darken-2 mr-1">{{form.query.group[g].rule[r].key}}</span>
                            <span class="blue--text text--darken-4 mr-1">{{query_exp[form.query.group[g].rule[r].comparator]}}</span>
                            <span :class="rule.escape?'green--text text--darken-2':'lime--text text--darken-2'">
                              {{rule.escape?"'"+form.query.group[g].rule[r].value+"'":form.query.group[g].rule[r].value}}
                            </span>
                            <span class="blue--text text--darken-4 mr-1" v-if="(r+1)!==form.query.group[g].rule.length">{{form.query.group[g].rule[r].conector?'OR':'AND'}}</span>
                          </v-card-subtitle>
                          <v-card-text class="pa-2" v-if="group_edit==g && rule_edit==r">
                            <v-row>
                              <v-col cols="12" sm="7">
                                <v-select dense solo v-model="form.query.group[g].rule[r].key" label="Campo" :items="form.data" item-text="name" item-value="name" ></v-select>
                              </v-col>
                              <v-col cols="12" sm="5">
                                <v-select dense solo v-model="form.query.group[g].rule[r].comparator" label="Operador" :items="['Igual','No Igual','Menor','Mayor','Menor o Igual','Mayor o Igual','Contiene']" item-text="item" item-value="item" ></v-select>
                              </v-col>
                            </v-row>
                            <v-select dense solo v-if="form.query.group[g].rule[r].escape==false" v-model="form.query.group[g].rule[r].value" label="Campo" :items="form.data" item-text="name" item-value="name" append-icon="bi-diamond" @click:append="form.query.group[g].rule[r].escape=!form.query.group[g].rule[r].escape"></v-select>
                            <v-text-field dense solo v-else v-model="form.query.group[g].rule[r].value" label="Valor" :items="form.data" item-text="name" item-value="name" append-icon="bi-filter-circle" @click:append="form.query.group[g].rule[r].escape=!form.query.group[g].rule[r].escape"></v-text-field>
                          </v-card-text>
                          <v-card-actions class="justify-space-between">
                            <v-btn fab color="info" x-small @click="group_edit==g && rule_edit==r?editQuery():editQuery(r,g)">
                              <v-icon>bi-pencil-square</v-icon>
                            </v-btn>
                            <v-btn fab color="error" x-small @click="$delete(form.query.group[g].rule,r)">
                              <v-icon>bi-trash</v-icon>
                            </v-btn>
                            <v-btn-toggle v-model="form.query.group[g].rule[r].conector" shaped v-if="(r+1)!==form.query.group[g].rule.length">
                              <v-btn color="info" value="OR" small>
                                OR
                              </v-btn>
                            </v-btn-toggle>
                          </v-card-actions>
                        </v-card>
                      </v-col>
                    </v-row>
                  </v-card-text>
                </v-card>
              </v-col>
            </v-row>
          </v-col>
        </v-row>

        <v-subheader>CONFIGURACION DE DATOS</v-subheader>
        <v-row>
          <v-col cols="12" md="4">
            <v-select v-model="form.data.key" :items="database.fields" item-text="name" item-value="name" label="Valor"></v-select>
          </v-col>
          <v-col cols="12" md="4">
            <v-select v-model="form.data.value" :items="database.fields" item-text="name" item-value="name" label="Etiqueta"></v-select>
          </v-col>
          <v-col cols="12" md="4">
            <v-text-field v-model="form.data.default" label="Valor por defecto"></v-text-field>
          </v-col>
        </v-row>
        <v-card-actions class="justify-space-between">
          <v-btn type="submit" color="success">
            <v-icon>bi bi-cloud-arrow-up</v-icon> Guardar
          </v-btn>
        </v-card-actions>
      </v-form>
    </v-card-text>
  </v-card>
  `,
  data:()=>{
    return {
      dragging:false,
      field_active:null,
      group_edit:null,
      rule_edit:null,
      search:null,
      fields:[
        {text:'Texto',value:'text'},
        {text:'Texto Largo',value:'textarea'},
        {text:'Numero',value:'number'},
        {text:'Fecha',value:'date'},
        {text:'Hora',value:'time'},
        {text:'Checkbox',value:'checkbox'},
        {text:'Lista desplegable',value:'select'},
        {text:'Lista Autocomplete',value:'combobox'},
        {text:'Radio',value:'radio'},
        {text:'Marcador (Mapa)',value:'marker'},
        {text:'Poligono (Mapa)',value:'polygon'}
      ],
      render_fields:[
        {text:'Imagen',value:'image'},
        {text:'Archivo',value:'file'},
        {text:'Checkbox',value:'checkbox'},
        {text:'Marcador (Mapa)',value:'marker'},
        {text:'Poligono (Mapa)',value:'polygon'}
      ],
      type_templates:[
        {
          icon:'bi-table',
          value:'select',
          text:'Lista desplegable',
        },
        {
          icon:'bi-card-text',
          value:'navbar',
          text:'Menu horizontal',
        },
        {
          icon:'bi-map',
          value:'sidebar',
          text:'Menu vertical',
        },
        {
          icon:'bi-map',
          value:'btn',
          text:'Botones',
        }
      ],
      default_value:[
        '--date--',
        '--time--',
        '--datetime--'
      ],
      filter_value:[
        'capitalize',
        'decimals',
        'date',
        "truncate(100,'...')"
      ],
      query_exp:{
        "Igual":"=",
        "No Igual":"!=",
        "Menor":"<",
        "Mayor":">",
        "Menor o Igual":"<=",
        "Mayor o Igual":">=",
        "Contiene":"LIKE",
      },
      form:{
        name:'Nav',
        codename:'',
        data:{
          key:'',
          value:'',
          default:'',
          var:'option'
        },
        table:'',
        template:'option',
        type:'select',
        query:{
          from:[],
          rule:[],
          group:[]
        },
        props:{
          view:true,
          update:null,
          remove:true,
          md:6,
          maps:{
            center:{lat:6.795535,lng:-64.379883},
            zoom:5,
            layers:['https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png']
          }
        }
      },
      modules:[],
      database:{
        tables:[],
        options:[],
        fields:[]
      }
    }
  },
  props:['title'],
  methods:{
    Save:function() {
      axios.post(this.$root.p+'/add',{
        data:this.form
      })
      .then((response)=>{
        router.push({query:{p:this.$root.p}})
      })
    },
    tableFields:function() {
      axios.post('Database/fields/'+this.form.table)
      .then((response)=>{
        this.form.name = 'Nav '+this.form.table
        this.database.fields = response.data
        this.form.data.var = 'option_'+this.form.table+'_'+this.$root.GenerateID('alnum',4);

      })
    },
    fillOptions:function(table=null) {
      if (table!==null && table!=='') {
        if (this.database.tables.includes(table)) {
          axios.post(this.$root.p+'/get_tables/'+this.form.table+'?field=name')
          .then((response)=>{
            this.database.options = response.data
          })
        } else{
          this.database.options = []
        }
      } else {
        this.database.options = []
      }
    },
    setFieldQuery() {
      axios.post(this.$root.p+'/get_fields/'+this.form.table,{
        data:this.form.query
      })
      .then((response)=>{
        this.database.options = response.data
      })
    },
    isLetter(e) {
      let char = String.fromCharCode(e.keyCode);
      if (/^[A-Za-z]+$/.test(char)) return true;
      else e.preventDefault();
    },
    toWidth(f) {
      var pre_width = (f/12)*100;
      return (pre_width*90)/100;
    },
    editQuery(r=null,g=null) {
      this.rule_edit = r
      this.group_edit = g
    }
  },
  created:function() {
    this.form.codename = 'C'+this.$root.GenerateID('alpha',16);
    this.form.type = this.type_templates[0].value

    axios.post('Database/get')
    .then((response)=>{
      this.database.tables = response.data
      this.form.table = response.data[0].name
      this.form.name += ' '+response.data[0].name;
      this.form.data.var += '_'+response.data[0].name+'_'+this.$root.GenerateID('alnum',4);
      this.tableFields()
    })
    axios.post('Post/get')
    .then((response)=>{
      this.modules = response.data.results
    })
    this.$emit('loading-screen',false)
  }
})