<?php
  $this->uri = service('uri');
  $this->db = db_connect();

  $methods = [];
  $created = [];

  $models['clean_serie'] = [];
  $models['option'] = null;
  $models['data'] = [];
  $models['loading'] = true;

  foreach ($response['data'] as $serie) {
    $models['clean_serie'][] = [
      'title'=>$serie['title'],
      'source'=>$serie['source'],
      'color'=>$serie['color'],
    ];
    $models['chart_attr'] = $response['attr'];
  }

  $models['title']['text'] = $response['name'];
  $models['title']['subtext'] = $response['data'][0]['title'];
  $models['title']['left'] = "center";

  $models['tooltip']['trigger'] = 'item';
  if ($response['attr']['tooltip']['formatter']) {
    $models['tooltip']['formatter'] = $response['attr']['tooltip']['formatter'];
  }

  $models['legend']['orient'] = 'horizontal';
  $models['legend']['bottom'] = 'bottom';
?>

Vue.component('<?=$response['codename']?>',{template: `
  <v-card :loading="loading">
    <template slot="progress">
      <v-progress-linear
        color="primary"
        height="10"
        indeterminate
      ></v-progress-linear>
    </template>
    <v-card-text style="height:400px">
      <v-chart autoresize :option="option" v-if="option" v-show="loading==false" />
      <v-skeleton-loader v-show="loading==true"
      type="card"
    ></v-skeleton-loader>
    </v-card-text>
  </v-card>
  `,
  data(){return <?= json_encode($models) ?>},
  created(){
    var text = ''
    var keys = Object.keys(this.$router.history.current.query)
    for(let i = 0;i < this.clean_serie.length;i++){
      text = this.clean_serie[i].source
      for(let x = 0;x < keys.length;x++){
        var to_replace = this.$router.history.current.query[keys[x]]
        var _replace = '{'+keys[x]+'}'

        let textStripped = text.replace(/[,.!=]/g,'')
        let words = textStripped.split(' ')

        let uses = 0
        for (let u = 0; u < words.length; u++){
          if (words[u] == _replace){
            text = text.replace(_replace,to_replace)
          }
        }
      }
      this.clean_serie[i].source = text
    }
  },
  mounted(){
    axios.post('Chart/render/<?=$response['type']?>',{
      data:this.clean_serie,
      attr:this.chart_attr
    }).then((response)=>{
      if(response.data.status==500){
        this.$set(this.data,'title',this.title)
        this.$set(this.data,'tooltip',this.tooltip)
        this.$set(this.data,'xAxis',{
          type:'category',
          data:['Grafico en espera']
        })
        this.$set(this.data,'yAxis',{type:'value'})
        this.$set(this.data,'series',{
          "type": "line",
          "data": [999]
        })
      } else{
        this.$set(this.data,'title',this.title)
        this.$set(this.data,'tooltip',this.tooltip)
        this.$set(this.data,'legend',this.legend)
        this.$set(this.data,'series',response.data.dataset.series)
        this.$set(this.data,'xAxis',response.data.dataset.xAxis)
        this.$set(this.data,'yAxis',response.data.dataset.yAxis)
      }
      this.option = {... this.data}
      this.loading = false
    })
  }
})