<?php
$db = db_connect();
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <title><?=base_url()?> </title>
  <meta name="description" content="The small framework with powerful features">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, minimal-ui">
  <link rel="shortcut icon" type="image/png" href="/favicon.ico" />
  <!-- Favicons -->
  <link href="<?= base_url('public/theme') ?>/assets/img/favicon.png" rel="icon">
  <link href="<?= base_url('public/theme') ?>/assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Vendor CSS Files -->
  <link href="<?= base_url('public/theme') ?>/assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/assets/css/icon-ui.css" rel="stylesheet">

  <!--link href="https://fonts.googleapis.com/css?family=Roboto:100,300,400,500,700,900" rel="stylesheet"-->
  <link href="https://cdn.jsdelivr.net/npm/@mdi/font@6.x/css/materialdesignicons.min.css" rel="stylesheet">
  <link href="<?= base_url('public/theme/vue') ?>/css/vuetify.min.css" rel="stylesheet">
  <link rel="stylesheet" href="<?= base_url('public/theme/leaflet') ?>/leaflet.css" />
  <script src="<?= base_url('public/theme/leaflet') ?>/leaflet.js"></script>


  <script src="<?= base_url('public/theme/vue/vue.js') ?>"></script>
  <script src="<?= base_url('public/theme/vue/axios.min.js') ?>"></script>

  <script src="<?= base_url('public/plugins/jspdf.min.js') ?>"></script>
  <script src="<?= base_url('public/plugins/jspdf.plugin.autotable.js') ?>"></script>

  <script src="<?= base_url('public/plugins/echart.js') ?>"></script>
  <script src="<?= base_url('public/plugins/vue-echarts.js') ?>"></script>

  <?php
  $js_folder = "public/theme/vue/js";
  $files = array_diff(scandir(FCPATH . "/{$js_folder}"), array('.', '..'));
  ?>
  <?php foreach ($files as $filename): ?>
  <script src="<?= base_url("{$js_folder}/{$filename}") ?>"></script>
  <?php endforeach ?>

  <script src="<?= base_url('public/node_modules/ckeditor4/ckeditor.js') ?>"></script>
  <script src="<?= base_url('public/node_modules/ckeditor4-vue/dist/ckeditor.js') ?>"></script>
  <script>
    const router = new VueRouter({
      mode: 'history',
      base: '',
      routes: []
    })
    //window.Vue2Transitions
    //Vue.use(Vue2Transitions)
  </script>
</head>

<body>
  <div id="app">
    <v-app>
      <v-main app class="mb-5">
        <v-container fluid class="mb-5">
          <v-card>
            <v-card-title>
              {{title}} - {{env.APP_NAME}}
            </v-card-title>
            <v-card-text>
              <form action="<?=site_url('Install/start_installation')?>" method="POST">
                <v-row>
                  <v-col cols="12" md="4" v-for="field in env_fields" v-if="field!=='APP_INSTALLED'">
                    <v-text-field v-model="env[field]" :label="field" :name="field" dense></v-text-field>
                  </v-col>
                </v-row>
                <v-btn color="primary" type="submit">Install</v-btn>  
              </form>
            </v-card-text>
            <v-card-actions>
              
            </v-card-actions>
          </v-card>
        </v-container>
      </v-main>
    </v-app>
  </div>

  <script>
    Vue.filter('capitalize', function (value) {
      if (!value) return ''
      value = value.toString()
      return value.charAt(0).toUpperCase() + value.slice(1)
    })
    Vue.filter('decimals', function (value) {
      if (!value) return ''
      return Number(value).toFixed(2)
    })
    Vue.filter('filesize', function (value) {
      if (value < 1024) return value + ' B'
      let i = Math.floor(Math.log(value) / Math.log(1024))
      let num = (value / Math.pow(1024, i))
      let round = Math.round(num)
      num = round < 10 ? num.toFixed(2) : round < 100 ? num.toFixed(1) : round
      return `${num} ${'KMGTPEZY'[i - 1]}B`
    })
    Vue.filter('date', function (value) {
      if (!value) return ''
      let date_time = value.split(' ');
      let date = date_time[0]
      let time = date_time[1]
      let new_date = date.split('-')
      return new_date[2] + '/' + new_date[1] + '/' + new_date[0]
    })
    Vue.filter('truncate', function (value, length, suffix) {
      if (!value) return ''
      if (value.length > length) {
        return value.substring(0, length) + suffix;
      } else {
        return value
      }
    })

    Vue.use(CKEditor);
    CKEDITOR.config.extraPlugins = 'base64image';
    CKEDITOR.config.removePlugins = 'about,image';
  </script>
  <script>
    const messages = {
      en: {
        action: {
          add: 'Add',
          view: 'View',
          delete: 'Delete',
          update: 'Update',
          open: 'Open',
          close: 'Close'
        },
        section: {
          module: 'Module',
          component: 'Component',
          element: 'Element',
          record: 'Record'
        },
        alert: {
          delete: "This {el} will be permanently removed"
        }
      },
      es: {
        action: {
          add: 'Agregar',
          view: 'Ver Listado',
          delete: 'Eliminar',
          update: 'Actualizar',
          open: 'Abrir',
          close: 'Cerrar'
        },
        section: {
          module: 'Modulo',
          component: 'Componente',
          element: 'Elemento',
          record: 'Registro'
        },
        alert: {
          delete: "Este {el} sera eliminado de forma permanente"
        }
      }
    }
    const i18n = new VueI18n({
      locale: 'en',
      messages
    })
  </script>
  <script>
    var app = new Vue({
      router,
      i18n,
      el: "#app",
      vuetify: new Vuetify(),
      data: {
        title: "Installation and Configuration",
        env:{
          "APP_INSTALLED":"false",
          "APP_NAME":"Brokkr",
          "CI_ENVIRONMENT":"production",
          "app.sessionCookieName":"brokkr_session",
          "app.sessionExpiration":"0",
          "database.default.hostname":"localhost",
          "database.default.database":"brokkr",
          "database.default.username":"root",
          "database.default.password":"",
          "database.default.DBDriver":"MySQLi"
        },
        env_fields:[
          "APP_INSTALLED",
          "APP_NAME",
          "CI_ENVIRONMENT",
          "app.sessionCookieName",
          "app.sessionExpiration",
          "database.default.hostname",
          "database.default.database",
          "database.default.username",
          "database.default.password",
          "database.default.DBDriver"
        ],
        session : '',
        menu: [],
        modules: [],
        p: '',
        a: '',
        pk: '',
        t: '',
        page: [],
        page_vars: [],
        sidebar: false,
        footerbar: false,
        settings: {
          languages: [
            {
              label: 'English',
              value: 'en'
            },
            {
              label: 'Spanish',
              value: 'es'
            }
          ]
        },
        dark_mode: true,
        t_key: 1
      },
      watch: {
        $route(to, from) {
          if (to.query.p !== undefined) {
            this.p = to.query.p
          } else {
            this.p = 'Home'
          }
          if (to.query.a !== undefined) {
            this.a = to.query.a
          } else {
            this.a = ''
          }
          if (to.query.pk !== undefined) {
            this.pk = to.query.pk
          } else {
            this.pk = ''
          }
          if (to.query.t !== undefined) {
            this.t = to.query.t
          } else {
            this.t = 'component'
          }
          this.GetPage(this.p, this.a, this.pk, this.t)
        }
      },
      methods: {
        Install(){
          axios.post('installation',this.env)
          .then((res)=>{
            console.log(res)
          })
        },
        GenerateID: function (type = 'alnum', len = 8) {
          var charset = "";
          if (type == "alpha") {
            charset += "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
          }
          if (type == "alnum") {
            charset += "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            charset += "0123456789";
          }
          if (type == "numeric") {
            charset += "0123456789";
          }
          var ret = "";
          for (var i = 0, n = charset.length; i < len; ++i) {
            ret += charset.charAt(Math.floor(Math.random() * n));
          }
          return ret;
        },
        DarkMode: function (onoff) {
          this.$vuetify.theme.dark = onoff
        }
      },
      created: function () {
        this.$vuetify.theme.dark = this.dark_mode
        var to = this.$route;
        if (to.query.p !== undefined) {
          this.p = to.query.p
        } else {
          this.p = 'Home'
        }
        if (to.query.a !== undefined) {
          this.a = to.query.a
        } else {
          this.a = ''
        }
        if (to.query.pk !== undefined) {
          this.pk = to.query.pk
        } else {
          this.pk = ''
        }
        if (to.query.t !== undefined) {
          this.t = to.query.t
        } else {
          this.t = 'component'
        }
        document.title = "<?= $_ENV['APP_NAME'] ?>"
      }
    })
  </script>
</body>

</html>