<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class Modules extends Seeder
{
	public function run()
	{
		$this->db = db_connect();
		$data = [
			[
				'controller' => 'database',
				'data' => '{"title":"Base de Datos","icon":"ri-database-2-line","action":["create","update","delete"]}'
			],
			[
				'controller' => 'home',
				'data' => '{"title":"Inicio","icon":"bi bi-house-door","action":["create","read","update","delete"]}'
			],
			[
				'controller' => 'post',
				'data' => '{"title":"Modulos","icon":"bi bi-columns-gap","action":["create","update","delete"]}'
			],
			[
				'controller' => 'importer',
				'data' => '{"title":"Importador de datos","icon":"bi-save","action":[]}'
			],
			[
				'controller' => 'settings',
				'data' => '{"title":"Ajustes","icon":"ri-settings-4-line","action":["create","update","delete"]}'
			],
			[
				'controller' => 'module-addChart',
				'data' => '{"title":"Indicadores","icon":"bi-pie-chart","action":["create","update","delete"]}'
			]

		];
		$this->db->table('sys_modules')->insertBatch($data);
	}
}