<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Components extends Migration
{
	public function up()
	{
		$this->forge = \Config\Database::forge();
		$this->forge->addField([
			'ID' => [
				'type' => 'INT',
				'constraint' => 4,
				'auto_increment' => true,
				'null' => false
			],
			'name' => [
				'type' => 'VARCHAR',
				'constraint' => 50,
				'null' => true
			],
			'codename' => [
				'type' => 'VARCHAR',
				'constraint' => 50,
				'null' => true
			],
			'template' => [
				'type' => 'VARCHAR',
				'constraint' => 100,
				'null' => true
			],
			'type' => [
				'type' => 'VARCHAR',
				'constraint' => 100,
				'null' => true
			],
			'table' => [
				'type' => 'VARCHAR',
				'constraint' => 100,
				'null' => true
			],
			'data' => [
				'type' => 'TEXT',
				'null' => true
			],
			'props' => [
				'type' => 'TEXT',
				'null' => true
			],
			'attr' => [
				'type' => 'TEXT',
				'null' => true
			],
			'query' => [
				'type' => 'TEXT',
				'null' => true
			]
		]);
		$this->forge->addKey('ID', true);
		$this->forge->createTable('sys_component');
	}

	public function down()
	{
		$this->forge->dropTable('sys_component');
	}
}