<?php

namespace App\Controllers;

class Session extends BaseController
{
  public function index()
  {

    $session = $this->session->get();
    unset($session['__ci_last_regenerate']);
    unset($session['_ci_previous_url']);
    if (!empty($session)) {
      echo json_encode($session);
    }else{
      echo '';
    }
  }
  public function LogIn()
  {
    $form = json_decode(file_get_contents('php://input'),true);
    $input = $form['data'];

    $security = $this->db->table('sys_settings')->where('key','security')->get()->getRowArray();
    $dec = json_decode($security['config'],true);
    $table = $dec['table'];
    $fields = $dec['fields'];
    
    $logged = false;
    $message = "Datos invalidos, verifique e intente nuevamente.";
    if ($logged==false) {
      $users = $this->db->table($table)->where("{$fields['user']}",$input[$fields['user']])->orWhere("{$fields['email']}",$input[$fields['user']])->get()->getRowArray();
      if (!empty($users)) {
        if (password_verify($input[$fields['password']], $users[$fields['password']])) {
          $sess_data = [];
          foreach ($users as $key => $value) {
            if ($key !== $input[$fields['password']]) {
              $sess_data[$key] = $value;
            }else{
              unset($sess_data[$key]);
            }
          }
          $this->session->set($sess_data);
          $logged = true;
          $message = "Datos correctos, Inicando sesion.";
        }
      }
    }

    $ret['success'] = $logged;
    $ret['message'] = $message;
    $ret['session'] = $sess_data;

    echo json_encode($ret);
  }
  public function Register()
  {
    $form = json_decode(file_get_contents('php://input'),true);
    $input = $form['data'];

    $security = $this->db->table('sys_settings')->where('key','security')->get()->getRowArray();
    $dec = json_decode($security['config'],true);
    $table = $dec['table'];
    $fields = $dec['fields'];
    
    $where[$fields['user']] = $input[$fields['user']];
    $where[$fields['email']] = $input[$fields['email']];
    $users = $this->db->table($table)->where($where)->get()->getRowArray();
    if (empty($users)) {
      $data[$fields['name']] = $input[$fields['name']];
      $data[$fields['user']] = $input[$fields['user']];
      $data[$fields['email']] = $input[$fields['email']];
      $data[$fields['password']] = password_hash($input[$fields['password']], PASSWORD_DEFAULT);
      $reg = $this->db->table($table)->set($data)->insert();
      if ($reg) {
        $logged = true;
        $message = "Usuario Registrado, ya puede iniciar sesion.";
      }
    } else {
      $logged = false;
      $message = "Usuario y/o Correo ya esta en uso";
    }
    $ret['success'] = $logged;
    $ret['message'] = $message;
    echo json_encode($ret);
  }

  public function Recovery()
  {
    $form = json_decode(file_get_contents('php://input'),true);
    $input = $form['data'];

    $security = $this->db->table('sys_settings')->where('key','security')->get()->getRowArray();
    $dec = json_decode($security['config'],true);
    $table = $dec['table'];
    $fields = $dec['fields'];
    
    $where[$fields['email']] = $input[$fields['email']];
    $users = $this->db->table($table)->where($where)->get()->getRowArray();
    if (!empty($users)) {
      $set = $this->db->table($table)->set("{$fields['password']}", password_hash($input[$fields['password']], PASSWORD_DEFAULT))->where($where)->update();
      if ($set) {
        $logged = true;
        $message = "Contraseña actualizada";
      }
    } else {
      $logged = false;
      $message = "Usuario y/o Correo no existe";
    }
    $ret['success'] = $logged;
    $ret['message'] = $message;
    echo json_encode($ret);
  }

  public function LogOut()
  {
    $session = $this->session->get();
    $this->session->destroy();
    echo json_encode($this->session->get());
  }
  public function AddUser($type="admin")
  {
    $form = json_decode(file_get_contents('php://input'),true);
    $input = $form['data'];
    $users[] = $this->admin->select('COUNT(*) AS total')->where('user',$input['user'])->first()['total'];
    $users[] = $this->customer->select('COUNT(*) AS total')->where('email',$input['email'])->first()['total'];
    //$users[] = $this->staff->select('COUNT(*) AS total')->where('user',$input['user'])->first()['total'];
    if (array_sum($users)==0) {
      if($type=="admin"){
        $data['name'] = "{$input['name']} {$input['lastname']}";
        $data['phone'] = $input['phone'];
        $data['email'] = $input['email'];
        $data['app_name'] = 'e-Commerce System';
        $data['app_logo'] = null;
        $data['user'] = $input['user'];
        $data['password'] = password_hash($input['password'], PASSWORD_DEFAULT);
        $st = $this->admin->insert($data);
      }
      if($type=="customer"){
        $data['ID'] = $input['ID'];
        $data['name'] = $input['name'];
        $data['address'] = $input['address'];
        $data['phone'] = $input['phone'];
        $data['email'] = $input['email'];
        $data['user'] = $input['user'];
        $data['password'] = password_hash($input['password'], PASSWORD_DEFAULT);
        $st = $this->business->insert($data);
      }
      if($type=="staff"){
        $data['ID'] = $input['ID'];
        $data['_company'] = $input['_company'];
        $data['name'] = $input['name'];
        $data['position'] = $input['position'];
        $data['phone'] = $input['phone'];
        $data['email'] = $input['email'];
        $data['_department'] = $input['_department'];
        $data['user'] = $input['user'];
        $data['password'] = password_hash($input['password'], PASSWORD_DEFAULT);
        $st = $this->staff->insert($data);
      }
      if ($st) {
        $ret['success'] = true;
        $ret['route'] = 'RegisterSuccess';
      }else{
        $ret['success'] = false;
        $ret['route'] = 'RegisterFailed';
      }
    }else{
      $ret['success'] = false;
      $ret['route'] = 'RegisterFailed';
    }
    echo json_encode($ret);
  }
  public function Menu($type="left",$source="shop")
  {
    $session = $this->session->get();
    if (!empty($session['role'])) {
      $ret = $this->menu->where(['role'=>$this->session->role,'type'=>$type,'source'=>$source])->first();
    }else{
      $ret = $this->menu->where(['role'=>'admin','type'=>'nav','source'=>$source])->first();
    }
    $menu = json_decode($ret['modules'],true);
    $menu_finish = [];
    foreach ($menu as $item) {
      $mod = $this->db->table('sys_modules')->where('controller',$item['controller'])->get()->getRowArray();
      $dec = json_decode($mod['data'],true);
      $menu_finish[] = [
        'title'=>$dec['title'],
        'icon'=>$dec['icon'],
        'controller'=>$mod['controller'],
        'action'=>$item['action']
      ];
    }
    echo json_encode($menu_finish);
  }
}
