<?php

namespace App\Controllers;

class Module extends BaseController
{
  public function get($id = null)
  {
    if ($id == null) {
      $input = json_decode(file_get_contents('php://input'), true);
      if (isset($input['q'])) {
        $q = array_filter($input['q']);
      } else {
        $q = [];
      }

      if (isset($input['pagination']) and $input['pagination']['per_page'] !== 0) {
        $pagination['per_page'] = $input['pagination']['per_page'];
        $pagination['page'] = $input['pagination']['page'];
        $pagination['page_firts_result'] = round(($pagination['page'] - 1) * $pagination['per_page']);
      } else {
        $pagination = null;
      }

      $response = $this->component->GetAll($q, $pagination);
      for ($i = 0; $i < count($response); $i++) {
        $response[$i]['data'] = json_decode($response[$i]['data']);
        $response[$i]['props'] = json_decode($response[$i]['props']);
        $response[$i]['query'] = json_decode($response[$i]['query']);
        $response[$i]['width'] = 6;
      }
      $results = $this->component->GetCountAll($q);
    } else {
      $pagination = null;
      $response = $this->component->where('ID', $id)->first();
      $response['data'] = json_decode($response['data']);
      $response['props'] = json_decode($response['props']);
      $response['query'] = json_decode($response['query']);
      $response['width'] = 6;
    }

    //echo $this->db->getLastQuery();
    if ($pagination !== null) {
      echo json_encode(['results' => $response, 'page' => $pagination['page'], 'per_page' => $pagination['per_page'], 'total_rows' => intval($results['total'])]);
    } else {
      echo json_encode(['results' => $response, 'page' => 1, 'per_page' => 1, 'total_rows' => 0]);
    }
  }
  public function add()
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $form['data']['data'] = is_array($form['data']['data'])?json_encode($form['data']['data']):$form['data']['data'];
    $form['data']['props'] = json_encode($form['data']['props']);
    $form['data']['attr'] = json_encode($form['data']['attr']);
    $form['data']['query'] = json_encode($form['data']['query']);
    $st = $this->component->set($form['data'])->insert();
  }
  public function set($id)
  {
    $form = json_decode(file_get_contents('php://input'), true);

    $where['ID'] = $id;
    $st = $this->component->set($form['data'])->where($where)->update();
  }
  public function renders($id,$type="component")
  {
    $where['ID'] = $id;

    $response = $this->db->table("sys_{$type}")->where($where)->get()->getRowArray();
    $data['response'] = json($response,false,false);
    if ($type==="element") {
      return view("render/{$response['type']}/{$response['template']}", $data);
    } else {
      return view("render/{$response['template']}/{$response['type']}", $data);
    }
  }
  
  public function render_global($type="component"){

    $modules = $this->db->table("sys_{$type}")->get()->getResultArray();
    $code = "";
    foreach ($modules as $response) {
      $data['response'] = json($response,false,false);
      if ($type==="element") {
        $code .= view("render/{$response['type']}/{$response['template']}", $data);
      } else {
        $code .= view("render/{$response['template']}/{$response['type']}", $data);
      }
    }
    return $code;
  }

  public function render($id)
  {
    $where['ID'] = $id;
    $response = $this->db->table('sys_component')->where($where)->get()->getRowArray();
    $response['data'] = json_decode($response['data'], true);
    $response['methods'] = json_decode($response['methods'], true);
    $response['props'] = json_decode($response['props'], true);
    $response['query'] = json_decode($response['query'], true);

    $template = "Vue.component('{$response['codename']}',{template: `";

    ## HTML TEMPLATE
    if ($response['template'] == 'create') {
      $methods = [];
      $created = [];
      $models['title'] = $response['name'];
      $models['formHasErrors'] = false;
      $valid['required'] = false;
      $valid['multipart'] = false;
      foreach ($response['data'] as $key => $value) {
        if ($value['visible'] == true and $value['required'] == true) {
          $valid['required'] = false;
        }
        if ($value['visible'] == true and ($value['type'] == 'image' || $value['type'] == 'file')) {
          $valid['multipart'] = true;
        }
        if ($value['visible'] == true and $value['type'] == 'marker') {
          $methods[] = "{$value['name']}_marker:function(e){this.form.{$value['name']} = [e.latlng.lat,e.latlng.lng]}";
          $methods[] = "ready_{$value['name']}_marker:function(e){this.form.{$value['name']} = [6.795535,-64.379883]}";
          $created[] = "this.ready_{$value['name']}_marker()";
        }
        if ($value['visible'] == true and $value['type'] == 'polygon') {
          $methods[] = "{$value['name']}_polygon:function(e){this.form.{$value['name']}.push([... [e.latlng.lat,e.latlng.lng] ])}";
          $methods[] = "ready_{$value['name']}_{$value['type']}:function(e){this.form.{$value['name']} = []}";
          $created[] = "this.ready_{$value['name']}_{$value['type']}()";
        }
      }
      ;
      $template .= "<v-row><v-col cols='12' md='12'><v-card><v-card-title>{{title}}</v-card-title><v-card-text><v-form ref='form' v-on:submit.prevent='Save()'><v-row>";
      foreach ($response['data'] as $field) {
        $attr = [];
        if ($field['visible'] == true) {

          $attr['required'] = (boolval($field['required']) ? "required :rules=\"[() => !!form.{$field['name']} || 'El Campo {$field['label']} es obligatorio']\" append-icon='bi-asterisk' color='error'" : '');
          $attr['disabled'] = (boolval($field['disabled']) ? "disabled append-icon='bi-lock'" : '');
          $attr['hidden'] = (boolval($field['hidden']) ? 'hidden' : '');
          $attr['multiple'] = (boolval($field['multiple']) ? 'multiple' : '');
          $attr['type'] = 'dense outlined filled';
          switch ($field['type']) {
            case 'number':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-text-field {$attr['type']} {$attr['required']} {$attr['disabled']} ref='{$field['name']}' v-model='form.{$field['name']}' type=\"number\" label='{$field['label']}'></v-text-field></v-col>";
              break;
            case 'text':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-text-field {$attr['type']} {$attr['required']} {$attr['disabled']} ref='{$field['name']}' v-model='form.{$field['name']}' label='{$field['label']}'></v-text-field></v-col>";
              break;
            case 'textarea':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-textarea {$attr['type']} {$attr['required']} {$attr['disabled']} ref='{$field['name']}' v-model='form.{$field['name']}' counter rows='2' auto-grow label='{$field['label']}' :value='form.{$field['name']}'></v-textarea></v-col>";
              break;
            case 'date':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-text-field {$attr['type']} {$attr['required']} {$attr['disabled']} ref='{$field['name']}' v-model='form.{$field['name']}' type='date' label='{$field['label']}'></v-text-field></v-col>";
              break;
            case 'time':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-text-field {$attr['type']} {$attr['required']} {$attr['disabled']} ref='{$field['name']}' v-model='form.{$field['name']}' type='time' label='{$field['label']}'></v-text-field></v-col>";
              break;
            case 'checkbox':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-checkbox {$attr['type']} {$attr['required']} {$attr['disabled']} ref='{$field['name']}' v-model='form.{$field['name']}' label='{$field['label']}' true-value='1' false-value='0'></v-checkbox></v-col>";
              break;
            case 'radio':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-radio-group row {$attr['required']} {$attr['disabled']} label='{$field['label']}' ref='{$field['name']}' v-model='form.{$field['name']}'><v-radio v-for='item in fill.{$field['name']}' {$attr['type']} :label='item' :value='item' :key='item'></v-radio></v-radio-group></v-col>";
              break;
            case 'select':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-select {$attr['type']} {$attr['required']} {$attr['disabled']} ref='{$field['name']}' v-model='form.{$field['name']}' :items='fill.{$field['name']}' item-text='{$field['option']['data']}' item-value='{$field['option']['data']}' label='{$field['label']}'></v-select></v-col>";
              break;
            case 'combobox':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-combobox {$attr['type']} {$attr['required']} {$attr['disabled']} ref='{$field['name']}' v-model='form.{$field['name']}' :items='fill.{$field['name']}' item-text='item' item-value='item' label='{$field['label']}'></v-combobox></v-col>";
              break;
            case 'marker':
              $template .= "<v-col cols='12' md='{$field['width']}'><l-map :center='{lat:6.795535,lng:-64.379883}' style='height:350px' :zoom='5' @click='{$field['name']}_{$field['type']}'><l-tile-layer url='https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png' ></l-tile-layer><l-marker @ready='ready_{$field['name']}_{$field['type']}' :lat-lng='form.{$field['name']}'></l-marker></l-map></v-col>";
              break;
            case 'polygon':
              $template .= "<v-col cols='12' md='{$field['width']}'><l-map :center='{lat:6.795535,lng:-64.379883}' style='height:350px' :zoom='5' @click='{$field['name']}_{$field['type']}'><l-tile-layer url='https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png' ></l-tile-layer><l-polygon @ready='ready_{$field['name']}_{$field['type']}' :lat-lngs='form.{$field['name']}'></l-polygon></l-map></v-col>";
              break;
            case 'image':
              if ($attr['multiple']) {
                $template .= "<v-col cols='12' md='{$field['width']}'><v-file-input {$attr['type']} {$attr['required']} {$attr['disabled']} {$attr['multiple']} ref='{$field['name']}' v-model='form.{$field['name']}' label='{$field['label']}' prepend-icon='bi-image' color='indigo accent-4' counter :show-size='1000'>
                    <template v-slot:selection='{ index, text }'>
                      <v-chip v-if='index < 2' color='indigo accent-4' dark label small>
                        {{ text }}
                      </v-chip>
                      <span v-else-if='index === 2' class='text-overline grey--text text--darken-3 mx-2'>
                        +{{ files.length - 2 }} Imagen(es)
                      </span>
                    </template>
                  </v-file-input></v-col>";
              } else {
                $template .= "<v-col cols='12' md='{$field['width']}'><v-file-input {$attr['type']} {$attr['required']} {$attr['disabled']} {$attr['multiple']} ref='{$field['name']}' v-model='form.{$field['name']}' label='{$field['label']}' color='indigo accent-4' counter :show-size='1000'></v-file-input></v-col>";
              }
              break;
            case 'file':
              if ($attr['multiple']) {
                $template .= "<v-col cols='12' md='{$field['width']}'><v-file-input {$attr['type']} {$attr['required']} {$attr['disabled']} {$attr['multiple']} ref='{$field['name']}' v-model='form.{$field['name']}' label='{$field['label']}' color='indigo accent-4' counter :show-size='1000'>
                    <template v-slot:selection='{ index, text }'>
                      <v-chip v-if='index < 2' color='indigo accent-4' dark label small>
                        {{ text }}
                      </v-chip>
                      <span v-else-if='index === 2' class='text-overline grey--text text--darken-3 mx-2'>
                        +{{ files.length - 2 }} Imagen(es)
                      </span>
                    </template>
                  </v-file-input></v-col>";
              } else {
                $template .= "<v-col cols='12' md='{$field['width']}'><v-file-input {$attr['type']} {$attr['required']} {$attr['disabled']} {$attr['multiple']} ref='{$field['name']}' v-model='form.{$field['name']}' label='{$field['label']}' prepend-inner-icon='bi-image' color='indigo accent-4' counter :show-size='1000'></v-file-input></v-col>";
              }
              break;
            /*case 'date':
            $template .="<v-col cols='12' md='{$field['width']}'><v-date-picker dense v-model='form.{$field['name']}' label='{$field['label']}'></v-date-picker></v-col>";
            break;*/
            /*case 'time':
            $template .="<v-col cols='12' md='{$field['width']}'><v-time-picker dense v-model='form.{$field['name']}' label='{$field['label']}'></v-time-picker></v-col>";
            break;*/

            default:
              $template .= "<v-col cols='12' md='{$field['width']}'><v-text-field {$attr['type']} {$attr['required']} {$attr['disabled']} ref='{$field['name']}' v-model='form.{$field['name']}' label='{$field['label']}'></v-text-field></v-col>";
              break;
          }
        }
      }
      $template .= "</v-row><v-row><v-col cols='12' md='12' class='text-center'><v-btn type=\"submit\" color=\"success\"><v-icon>bi bi-cloud-arrow-up</v-icon> {{btn_text}}</v-btn></v-col></v-row>";
      $template .= "<v-snackbar v-model=\"alert\" >{{ message }}<template v-slot:action=\"{ attrs }\"> <v-btn color=\"success\" text v-bind=\"attrs\" @click=\"alert = false\"> Cerrar</v-btn></template></v-snackbar></v-form></v-card-text></v-card></v-col></v-row>";
    }
    if ($response['template'] == 'read') {
      $pk = '';
      $latlng = '';
      $map_type = [];

      $models['title'] = $response['name'];
      $models['list'] = [];
      $models['headers'] = [];
      $models['query'] = $response['query'];
      foreach ($response['data'] as $field) {
        if ($field['type'] == 'marker') {
          $latlng = $field['name'];
          $map_type[] = [
            'name' => $field['name'],
            'label' => $field['label'],
            'field' => $field['field'],
            'type' => $field['type']
          ];
        }
        if ($field['type'] == 'polygon') {
          $latlng = $field['name'];
          $map_type[] = [
            'name' => $field['name'],
            'label' => $field['label'],
            'field' => $field['field'],
            'type' => $field['type']
          ];
        }
        if ($field['primary_key'] == '1') {
          $pk = $field['name'];
        }
        if ($field['visible'] == true) {
          $models['headers'][] = [
            'text' => $field['label'],
            'sortable' => true,
            'value' => $field['name']
          ];
        }
      }
      $models['headers'][] = [
        'text' => '...',
        'width' => '10%'
      ];

      if ($response['type'] == 'basic') {
        $template .= "<v-data-table :headers=\"headers\" :items=\"list\" class=\"elevation-1\">
          <template v-slot:top>
            <v-toolbar flat>
              <v-toolbar-title>{{title}}</v-toolbar-title>
            </v-toolbar>
          </template>
          <template v-slot:item=\"row\">
            <tr>";
        foreach ($response['data'] as $field) {
          if ($field['visible'] == true) {
            switch ($field['filter']) {
              case '':
                $filter = '';
                break;
              case null:
                $filter = '';
                break;

              default:
                $filter = " | {$field['filter']}";
                break;
            }
            switch ($field['type']) {
              case 'checkbox':
                $template .= "<td><v-icon :color=\"row.item.{$field['name']}==1?'success':'error'\" true-value=\"1\">{{row.item.{$field['name']}==1?'bi bi-check':'bi bi-x'}}</v-icon></td>";
                break;
              default:
                $template .= "<td>{{row.item.{$field['name']}{$filter}}}</td>";
                break;
            }
          }
        }
        $template .= "
              <td>
                <v-btn @click=\"setUrl(view,row.item.{$pk})\" v-if=\"view\" color=\"teal\" icon dark x-small>
                  <v-icon>bi bi-eye</v-icon>
                </v-btn>
                <v-btn @click=\"setUrl(update,row.item.{$pk})\" v-if=\"update\" color=\"indigo\" icon dark x-small>
                  <v-icon>bi bi-pencil-square</v-icon>
                </v-btn>
                <v-btn @click=\"setUrl(remove,row.item.{$pk})\" v-if=\"remove\" color=\"red\" icon dark x-small>
                  <v-icon>bi bi-trash</v-icon>
                </v-btn>
              </td>";
        $template .= "
            </tr>
          </template>
        </v-data-table>";
      }
      if ($response['type'] == 'card') {
        $template .= "<v-row>
          <v-col cols='12' md='4' v-for='(item,i) in list'>
            <v-card>
              <v-card-text>
                <v-row>";
        foreach ($response['data'] as $field) {
          if ($field['visible'] == true) {
            switch ($field['filter']) {
              case '':
                $filter = '';
                break;
              case null:
                $filter = '';
                break;

              default:
                $filter = " | {$field['filter']}";
                break;
            }
            switch ($field['type']) {
              case 'checkbox':
                $template .= "<v-col cols='12' md='{$field['width']}'><v-icon :color=\"item.{$field['name']}==1?'success':'error'\" true-value=\"1\">{{item.{$field['name']}==1?'bi bi-check':'bi bi-x'}}</v-icon></v-col>";
                break;
              default:
                $template .= "<v-col cols='12' md='{$field['width']}'><dt><strong>{$field['label']}</strong></dt><dd>{{item.{$field['name']}{$filter}}}</dd></v-col>";
                break;
            }
          }
        }
        $template .= "
                </v-row>
              </v-card-text>
              <v-card-actions class='d-flex justify-space-between'>
                <v-btn @click=\"setUrl(view,item.{$pk})\" v-if=\"view\" color=\"teal\" icon dark x-small>
                  <v-icon>bi bi-eye</v-icon>
                </v-btn>
                <v-btn @click=\"setUrl(update,item.{$pk})\" v-if=\"update\" color=\"indigo\" icon dark x-small>
                  <v-icon>bi bi-pencil-square</v-icon>
                </v-btn>
                <v-btn @click=\"setUrl(remove,item.{$pk})\" v-if=\"remove\" color=\"red\" icon dark x-small>
                  <v-icon>bi bi-trash</v-icon>
                </v-btn>
              </v-card-actions>";
        $template .= "
            </v-card>
          </v-col>
        </v-row>";
      }
      if ($response['type'] == 'maps') {
        $template .= "<v-row>
          <v-col cols='12' md='12'>
            <v-card style='height:350px'>
              <v-card-title>{$latlng}</v-card-title>
              <l-map :center='maps.center' :zoom='maps.zoom' @click='Marker'>
                <l-tile-layer v-for='(layer,l) in maps.layers' :url='layer' ></l-tile-layer>
              ";
        foreach ($map_type as $item) {
          if ($item['type'] == 'marker') {
            $template .= "<l-marker v-for='(row,r) in list' :lat-lng='row.{$item['name']}' v-if='row.{$item['name']}.length>0'><l-popup :options={maxWidth:500,minWidth:350}><v-row>";
            foreach ($response['data'] as $field) {
              if ($field['visible'] == true) {
                switch ($field['filter']) {
                  case '':
                    $filter = '';
                    break;
                  case null:
                    $filter = '';
                    break;

                  default:
                    $filter = " | {$field['filter']}";
                    break;
                }
                switch ($field['type']) {
                  case 'checkbox':
                    $template .= "<v-col cols='12' md='{$field['width']}'>{$field['label']} <v-icon :color=\"row.{$field['name']}==1?'success':'error'\" true-value=\"1\">{{row.{$field['name']}==1?'bi bi-check':'bi bi-x'}}</v-icon></v-col>";
                    break;
                  default:
                    $template .= "<v-col cols='12' md='{$field['width']}'><dt class='font-weight-black'>{$field['label']}</dt><dd>{{row.{$field['name']}{$filter}}}</dd></v-col>";
                    break;
                }
              }
            }
            $template .= "</v-row>";
            $template .= "
                    <v-row>
                      <v-col cols='12' md='12' class='d-flex justify-space-between'>
                        <v-btn @click=\"setUrl(view,row.{$pk})\" v-if=\"view\" color=\"teal\" icon dark x-small>
                          <v-icon>bi bi-eye</v-icon>
                        </v-btn>
                        <v-btn @click=\"setUrl(update,row.{$pk})\" v-if=\"update\" color=\"indigo\" icon dark x-small>
                          <v-icon>bi bi-pencil-square</v-icon>
                        </v-btn>
                        <v-btn @click=\"setUrl(remove,row.{$pk})\" v-if=\"remove\" color=\"red\" icon dark x-small>
                          <v-icon>bi bi-trash</v-icon>
                        </v-btn>
                      </v-col>  
                    </v-row></l-popup></l-marker>";
          }
          if ($item['type'] == 'polygon') {
            $template .= "<l-polygon v-for='(row,r) in list' :lat-lngs='row.{$item['name']}' v-if='row.{$item['name']}.length>0'><l-popup :options={maxWidth:500,minWidth:350}><v-row>";
            foreach ($response['data'] as $field) {
              if ($field['visible'] == true) {
                switch ($field['filter']) {
                  case '':
                    $filter = '';
                    break;
                  case null:
                    $filter = '';
                    break;

                  default:
                    $filter = " | {$field['filter']}";
                    break;
                }
                switch ($field['type']) {
                  case 'checkbox':
                    $template .= "<v-col cols='12' md='{$field['width']}'>{$field['label']} <v-icon :color=\"row.{$field['name']}==1?'success':'error'\" true-value=\"1\">{{row.{$field['name']}==1?'bi bi-check':'bi bi-x'}}</v-icon></v-col>";
                    break;
                  default:
                    $template .= "<v-col cols='12' md='{$field['width']}'><dt class='font-weight-black'>{$field['label']}</dt><dd>{{row.{$field['name']}{$filter}}}</dd></v-col>";
                    break;
                }
              }
            }
            $template .= "</v-row>";
            $template .= "
                    <v-row>
                      <v-col cols='12' md='12' class='d-flex justify-space-between'>
                        <v-btn @click=\"setUrl(view,row.{$pk})\" v-if=\"view\" color=\"teal\" icon dark x-small>
                          <v-icon>bi bi-eye</v-icon>
                        </v-btn>
                        <v-btn @click=\"setUrl(update,row.{$pk})\" v-if=\"update\" color=\"indigo\" icon dark x-small>
                          <v-icon>bi bi-pencil-square</v-icon>
                        </v-btn>
                        <v-btn @click=\"setUrl(remove,row.{$pk})\" v-if=\"remove\" color=\"red\" icon dark x-small>
                          <v-icon>bi bi-trash</v-icon>
                        </v-btn>
                      </v-col>  
                    </v-row></l-popup></l-polygon>";
          }
        }
        $template .= "
              </l-map>
            </v-card>
          </v-col>
        </v-row>";
      }
    }
    if ($response['template'] == 'update') {
      $models['title'] = $response['name'];
      $template .= "<v-row><v-col cols='12' md='12'><v-card><v-card-title>{{title}}</v-card-title><v-card-text><v-form v-on:submit.prevent='Save()'><v-row>";
      foreach ($response['data'] as $field) {
        if ($field['visible'] == true) {
          switch ($field['type']) {
            case 'number':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-text-field dense v-model='form.{$field['name']}' type=\"number\" label='{$field['label']}'></v-text-field></v-col>";
              break;
            case 'text':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-text-field dense v-model='form.{$field['name']}' label='{$field['label']}'></v-text-field></v-col>";
              break;
            case 'textarea':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-textarea dense v-model='form.{$field['name']}' counter rows='2' auto-grow label='{$field['label']}' :value='form.{$field['name']}'></v-textarea></v-col>";
              break;
            case 'date':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-text-field dense v-model='form.{$field['name']}' type='date' label='{$field['label']}'></v-text-field></v-col>";
              break;
            case 'time':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-text-field dense v-model='form.{$field['name']}' type='time' label='{$field['label']}'></v-text-field></v-col>";
              break;
            case 'checkbox':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-checkbox dense v-model='form.{$field['name']}' label='{$field['label']}' true-value='1' false-value='0'></v-checkbox></v-col>";
              break;
            case 'radio':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-radio-group row label='{$field['label']}' v-model='form.{$field['name']}'><v-radio v-for='item in fill.{$field['name']}' dense :label='item' :value='item' :key='item'></v-radio></v-radio-group></v-col>";
              break;
            case 'select':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-select dense v-model='form.{$field['name']}' :items='fill.{$field['name']}' item-text='item' item-value='item' label='{$field['label']}'></v-select></v-col>";
              break;
            case 'combobox':
              $template .= "<v-col cols='12' md='{$field['width']}'><v-combobox dense v-model='form.{$field['name']}' :items='fill.{$field['name']}' item-text='item' item-value='item' label='{$field['label']}'></v-combobox></v-col>";
              break;
            /*case 'date':
            $template .="<v-col cols='12' md='{$field['width']}'><v-date-picker dense v-model='form.{$field['name']}' label='{$field['label']}'></v-date-picker></v-col>";
            break;*/
            /*case 'time':
            $template .="<v-col cols='12' md='{$field['width']}'><v-time-picker dense v-model='form.{$field['name']}' label='{$field['label']}'></v-time-picker></v-col>";
            break;*/

            default:
              $template .= "<v-col cols='12' md='{$field['width']}'><v-text-field dense v-model='form.{$field['name']}' label='{$field['label']}'></v-text-field></v-col>";
              break;
          }
        }
      }
      $template .= "</v-row><v-row><v-col cols='12' md='12' class='text-center'><v-btn type=\"submit\" color=\"success\"><v-icon>bi bi-cloud-arrow-up</v-icon> {{btn_text}}</v-btn></v-col></v-row>";
      $template .= "<v-snackbar v-model=\"alert\" >{{ message }}<template v-slot:action=\"{ attrs }\"> <v-btn color=\"success\" text v-bind=\"attrs\" @click=\"alert = false\"> Cerrar</v-btn></template></v-snackbar></v-form></v-card-text></v-card></v-col></v-row>";
    }
    if ($response['template'] == 'view') {
      $models['title'] = $response['name'];
      $template .= "<div><v-row><v-col cols='12' md='12'><v-card><v-card-title>{{title}}</v-card-title><v-card-text><v-row>";
      foreach ($response['data'] as $field) {
        if ($field['visible'] == true) {
          switch ($field['type']) {
            case 'number':
              $template .= "<v-col cols='12' md='{$field['width']}'><dt><strong>{$field['label']}</strong></dt><dd>{{form.{$field['name']}}}</dd></v-col>";
              break;
            case 'text':
              $template .= "<v-col cols='12' md='{$field['width']}'><dt><strong>{$field['label']}</strong></dt><dd>{{form.{$field['name']}}}</dd></v-col>";
              break;
            case 'textarea':
              $template .= "<v-col cols='12' md='{$field['width']}'><dt><strong>{$field['label']}</strong></dt><dd>{{form.{$field['name']}}}</dd></v-col>";
              break;
            case 'date':
              $template .= "<v-col cols='12' md='{$field['width']}'><dt><strong>{$field['label']}</strong></dt><dd>{{form.{$field['name']}}}</dd></v-col>";
              break;
            case 'time':
              $template .= "<v-col cols='12' md='{$field['width']}'><dt><strong>{$field['label']}</strong></dt><dd>{{form.{$field['name']}}}</dd></v-col>";
              break;
            case 'checkbox':
              $template .= "<v-col cols='12' md='{$field['width']}'><dt><strong>{$field['label']}</strong></dt><dd>{{form.{$field['name']}}}</dd></v-col>";
              break;
            case 'radio':
              $template .= "<v-col cols='12' md='{$field['width']}'><dt><strong>{$field['label']}</strong></dt><dd>{{form.{$field['name']}}}</dd></v-col>";
              break;
            case 'select':
              $template .= "<v-col cols='12' md='{$field['width']}'><dt><strong>{$field['label']}</strong></dt><dd>{{form.{$field['name']}}}</dd></v-col>";
              break;
            case 'combobox':
              $template .= "<v-col cols='12' md='{$field['width']}'><dt><strong>{$field['label']}</strong></dt><dd>{{form.{$field['name']}}}</dd></v-col>";
              break;
            /*case 'date':
            $template .="<v-col cols='12' md='{$field['width']}'><dt><strong>{$field['label']}</strong></dt><dd>{{form.{$field['name']}}}</dd></v-col>";
            break;*/
            /*case 'time':
            $template .="<v-col cols='12' md='{$field['width']}'><dt><strong>{$field['label']}</strong></dt><dd>{{form.{$field['name']}}}</dd></v-col>";
            break;*/

            default:
              $template .= "<v-col cols='12' md='{$field['width']}'><dt><strong>{$field['label']}</strong></dt><dd>{{form.{$field['name']}}}</dd></v-col>";
              break;
          }
        }
      }
      $template .= "</v-row></v-card-text><v-card></v-col></v-row>";
      $template .= "<v-snackbar v-model=\"alert\" >{{ message }}<template v-slot:action=\"{ attrs }\"> <v-btn color=\"success\" text v-bind=\"attrs\" @click=\"alert = false\"> Cerrar</v-btn></template></v-snackbar></div>";
    }

    ## DATA TEMPLATE
    $template .= "`,";
    if ($response['template'] == 'create') {
      $models['form'] = [];
      foreach ($response['data'] as $model) {
        if ($model['type'] == 'marker' || $model['type'] == 'polygon') {
          $latlng = $model['name'];
        }
        if ($model['primary_key'] == '1') {
          $pk = $model['name'];
        }
        if ($model['visible']) {
          switch ($model['default']) {
            case '--date--':
              $value = date('Y-m-d');
              break;
            case '--time--':
              $value = date('H:i:s');
              break;
            case '--datetime--':
              $value = date('Y-m-d H:i:s');
              break;

            default:
              $value = $model['default'];
              break;
          }
          $models['form'][$model['name']] = $value;
          if (!empty($model['option']['data'])) {
            $models['fill'][$model['name']] = is_array($model['option']['data']) ? $model['option']['data'] : [];
          }
        }
        $models['query'] = $response['query'];
      }
    }

    if ($response['template'] == 'update') {
      $models['form'] = [];
      $pk = null;
      foreach ($response['data'] as $model) {
        if ($model['primary_key'] == 1) {
          $pk = $model['name'];
        }
        if ($model['visible'] == true) {
          switch ($model['default']) {
            case '--date--':
              $value = date('Y-m-d');
              break;
            case '--time--':
              $value = date('H:i:s');
              break;
            case '--datetime--':
              $value = date('Y-m-d H:i:s');
              break;

            default:
              $value = $model['default'];
              break;
          }
          $models['form'][$model['name']] = $value;
          if (!empty($model['option']['data'])) {
            $models['fill'][$model['name']] = is_array($model['option']['data']) ? $model['option']['data'] : [];
          }
        }
      }
    }

    if ($response['template'] == 'view') {
      $models['form'] = [];
      $pk = null;
      foreach ($response['data'] as $model) {
        if ($model['primary_key'] == 1) {
          $pk = $model['name'];
        }
        if ($model['visible'] == true) {
          switch ($model['default']) {
            case '--date--':
              $value = date('Y-m-d');
              break;
            case '--time--':
              $value = date('H:i:s');
              break;
            case '--datetime--':
              $value = date('Y-m-d H:i:s');
              break;

            default:
              $value = $model['default'];
              break;
          }
          $models['form'][$model['name']] = $value;
          if (!empty($model['option']['data'])) {
            $models['fill'][$model['name']] = is_array($model['option']['data']) ? $model['option']['data'] : [];
          }
        }
      }
    }

    ## PROPS TEMPLATE
    $props['props'] = [];
    foreach ($response['props'] as $key => $value) {
      $props['props'][] = $key;
    }
    $models['alert'] = false;
    $models['message'] = '';
    $models['action'] = $response['action'];
    $template .= "data:()=>{return" . json_encode($models) . "},";
    $template .= "props:" . json_encode($props['props']) . ",";

    ## METHODS TEMPLATE
    $template .= "methods:{";
    if ($response['template'] == 'create') {
      $template .= "
        Save:function(){
          this.formHasErrors = false

          Object.keys(this.form_valid).forEach(f=>{
            if(!this.form_valid[f]) this.formHasErrors = true
            this.\$refs[f].validate(true)  
          })
          if(this.formHasErrors==false){
            axios.post('Module/{$response['template']}/{$response['table']}',{
              data:this.form
            }).then((response)=>{
              if(response.status==200){
                if(this.after_send.path !== null){
                  route.push({query:{p:this.after_send.path,t:'page'}})
                  this.message=this.success_message;
                  this.alert=true;
                } else {
                  this.message=this.success_message;
                  this.alert=true;
                  if(this.after_send.key !== null){
                    this.\$root.page.active = this.after_send.key
                  }
                }
              } else{
                this.message=this.error_message;
              }
            })
          } else {
            this.message='Por favor complete los campos solicitados';
            this.alert=true;
          }
        },
        Fill:function(table=null,field=null,input=null){
          if(table!==null){
            axios.post('Module/read/'+table).then((response)=>{
              if(response.data.status==500){
                this.alert = true;
                this.message = 'Ha ocurrido un error, no se pudo consulta la tabla ['+table+']';
              } else{
                this.\$set(this.fill,input,response.data)
              }
            })
          } else {
            this.\$set(this.fill,input,field);
          }
        },
      ";
      $template .= implode(',', $methods);
    }
    if ($response['template'] == 'read') {
      $template .= "
        Data:function(){
          axios.post('Module/{$response['template']}/{$response['table']}',{
            data:this.query
          }).then((response)=>{
            this.list = response.data
          })
        },
        setUrl:function(act,id){
          if(this.\$root.page.active==null){
            this.\$root.GetPage(this.\$root.p,act,id,'page')
          } else {
            //this.\$root.pk = id
            //this.\$root.page.active=act
            this.\$root.GetPage(this.\$root.p,act,id,'page')
          }
        }
      ";
    }
    if ($response['template'] == 'update') {
      $template .= "
        Data:function(){
          axios.post('Module/read/{$response['table']}',{
            data:{
              rule:[{key:'{$pk}',comparator:'Igual',value:this.\$root.pk}]
            },
            result:'row'
          }).then((response)=>{
            this.form = response.data
          })
        },
        Save:function(){
          axios.post('Module/{$response['template']}/{$response['table']}',{
            data:this.form,
            where:{{$pk}:this.\$root.pk}
          }).then((response)=>{
            if(response.status==200){
              if(this.after_send.path !== null){
                route.push({query:{p:this.after_send.path,t:'page'}})
                this.message=this.success_message;
                this.alert=true;
              } else {
                this.message=this.success_message;
                this.alert=true;
                if(this.after_send.key !== null){
                  this.\$root.page.active = this.after_send.key
                }
              }
            } else{
              this.message=this.error_message;
            }
          })
        },
        Fill:function(table=null,field=null,input=null){
          if(table!==null){
            axios.post('Module/read/{$response['table']}',{
              fields:field
            }).then((response)=>{
              if(response.data.status==500){
                this.alert = true;
                this.message = 'Ha ocurrido un error, no se pudo consulta la tabla ['+table+']';
              } else{
                this.\$set(this.fill,input,response.data.data); 
              }
            })
          } else {
            this.\$set(this.fill,input,field);
          }
        }
      ";
    }
    if ($response['template'] == 'view') {
      $template .= "
        Data:function(){
          axios.post('Module/read/{$response['table']}',{
            data:{
              rule:[{key:'{$pk}',comparator:'Igual',value:this.\$root.pk}]
            },
            result:'row'
          }).then((response)=>{
            this.form = response.data
          })
        }
      ";
    }
    $template .= "},";

    ## COMPUTED
    $template .= "computed:{";
    if ($response['template'] == 'create') {
      $template .= "form_valid(){
        return{";
      foreach ($response['data'] as $field) {
        if ($field['visible'] == true and $field['required'] == true) {
          $template .= "{$field['name']}:this.form.{$field['name']},";
        }
      }
      $template .= "}}";
    }
    $template .= "},";
    $template .= "beforeCreate(){},";
    $template .= "created(){";
    if ($response['template'] == 'create') {
      foreach ($response['data'] as $field) {
        if (!empty($field['option']['data'])) {
          $template .= "this.Fill(" . json_encode($field['option']['origin']) . "," . json_encode($field['option']['data']) . "," . json_encode($field['name']) . ");";
        }
      }
      $template .= implode(',', $created);
    }
    if ($response['template'] == 'read') {
      $template .= "this.Data()";
    }
    if ($response['template'] == 'update') {
      $template .= "this.Data()";
    }
    if ($response['template'] == 'view') {
      $template .= "this.Data()";
    }
    $template .= "
      document.title = this.title
    },";
    $template .= "beforeMount(){},";
    $template .= "mounted(){},";
    $template .= "update(){}})";
    header("Content-type: application/x-javascript");
    echo $template;
  }
  public function list($id = null)
  {
    if ($id == null) {
      $input = json_decode(file_get_contents('php://input'), true);
      if (isset($input['q'])) {
        $q = array_filter($input['q']);
      } else {
        $q = [];
      }

      if (isset($input['pagination']) and $input['pagination']['per_page'] !== 0) {
        $pagination['per_page'] = $input['pagination']['per_page'];
        $pagination['page'] = $input['pagination']['page'];
        $pagination['page_firts_result'] = round(($pagination['page'] - 1) * $pagination['per_page']);
      } else {
        $pagination = null;
      }

      $response = $this->component->select('name,codename,type,props,template')->findAll();
      for ($i = 0; $i < count($response); $i++) {
        $response[$i]['props'] = json_decode($response[$i]['props'], true);
        $response[$i]['action'] = json_decode($response[$i]['action'], true);
        $response[$i]['width'] = 12;
        $response[$i]['id'] = 0;
        $response[$i]['keyname'] = random_string('alpha', 5);
        switch ($response[$i]['template']) {
          case 'create':
            $response[$i]['default']['color'] = 'success';
            $response[$i]['default']['icon'] = 'bi bi-plus';
            break;
          case 'read':
            $response[$i]['default']['color'] = 'primary';
            $response[$i]['default']['icon'] = 'bi bi-eye';
            break;
          case 'update':
            $response[$i]['default']['color'] = 'info';
            $response[$i]['default']['icon'] = 'bi bi-pencil-square';
            break;
          case 'delete':
            $response[$i]['default']['color'] = 'error';
            $response[$i]['default']['icon'] = 'bi bi-trash';
            break;

          default:
            $response[$i]['default']['color'] = 'pink';
            $response[$i]['default']['icon'] = 'bi bi-hand-index-thumb';
            break;
        }

      }
      $results = $this->component->GetCountAll($q);
    } else {
      $pagination = null;
      $response = $this->component->where('ID', $id)->first();
      $response['data'] = json_decode($response['data']);
      $response['props'] = json_decode($response['props'], true);
      $response['action'] = json_decode($response['action'], true);
      $response['width'] = 12;
      $response['id'] = 0;
      $response['keyname'] = random_string('alpha', 5);
    }

    //echo $this->db->getLastQuery();
    if ($pagination !== null) {
      echo json_encode(['results' => $response, 'page' => $pagination['page'], 'per_page' => $pagination['per_page'], 'total_rows' => intval($results['total'])]);
    } else {
      echo json_encode(['results' => $response, 'page' => 1, 'per_page' => 1, 'total_rows' => 0]);
    }
  }
  public function get_tables($table = null)
  {
    if (!empty($table)) {
      $tables = $this->db->getFieldData($table);
      if (isset($_REQUEST['field'])) {
        $response = [];
        for ($i = 0; $i < count($tables); $i++) {
          $response[$i] = $tables[$i]->name;
        }
        $tables = $response;
      } else {
        for ($i = 0; $i < count($tables); $i++) {
          switch ($tables[$i]->type) {
            case 'int':
              $tables[$i]->type = 'number';
              break;
            case 'varchar':
              $tables[$i]->type = 'text';
              break;
            case 'text':
              $tables[$i]->type = 'textarea';
              break;
            case 'date':
              $tables[$i]->type = 'date';
              break;
            case 'time':
              $tables[$i]->type = 'time';
              break;

            default:
              $tables[$i]->type = 'text';
              break;
          }
          $tables[$i]->option = [
            'origin' => null,
            'data' => ['key' => null, 'value' => null]
          ];
          $tables[$i]->label = $tables[$i]->name;
          $tables[$i]->width = 6;
          $tables[$i]->visible = true;
          $tables[$i]->helper = null;
          $tables[$i]->filter = null;
          $tables[$i]->hidden = false;
          $tables[$i]->disabled = false;
          $tables[$i]->required = ($tables[$i]->nullable == false) ? true : false;
          $tables[$i]->multiple = false;
        }
      }
    } else {
      if (isset($_GET['multiple'])) {
        $input = json_decode(file_get_contents('php://input'), true);
        $tables = [];
        foreach ($input['tables'] as $table) {
          $get_tables = $this->db->getFieldData($table);
          for ($i = 0; $i < count($get_tables); $i++) {
            switch ($get_tables[$i]->type) {
              case 'int':
                $ff['type'] = 'number';
                break;
              case 'varchar':
                $ff['type'] = 'text';
                break;
              case 'text':
                $ff['type'] = 'textarea';
                break;
              case 'date':
                $ff['type'] = 'date';
                break;
              case 'time':
                $ff['type'] = 'time';
                break;

              default:
                $ff['type'] = 'text';
                break;

            }
            $ff['option'] = [
              'origin' => null,
              'data' => ['key' => null, 'value' => null]
            ];
            $ff['name'] = $table . "." . $get_tables[$i]->name;
            $ff['label'] = str_replace(["_"], ' ', $get_tables[$i]->name);
            $ff['primary_key'] = $get_tables[$i]->primary_key;
            $ff['nullable'] = $get_tables[$i]->nullable;
            $ff['width'] = 6;
            $ff['visible'] = true;
            $ff['helper'] = null;
            $ff['filter'] = null;
            $ff['hidden'] = false;
            $ff['disabled'] = false;
            $ff['required'] = ($ff['nullable'] == false) ? true : false;
            $ff['multiple'] = false;
            array_push($tables, $ff);
          }
        }
      } else {
        $tables = $this->db->listTables();
        $tables = array_merge(array_diff($tables, ['sys_component', 'sys_menu', 'sys_modules', 'sys_settings', 'sys_admin', 'sys_post', 'sys_element', 'migrations']));
      }
    }
    echo json_encode($tables);
  }
  public function get_fields()
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $response = [];
    $query = $this->db->query($form['query']);
    $response = $query->getFieldNames();
    echo json_encode($response);
  }
  public function create($table)
  {
    if (isset($_REQUEST['multipart']) and $_REQUEST['multipart'] == true) {
      $form['data'] = [];
      $data = $this->db->table('sys_component')->where(['ID' => $_REQUEST['sys_component']])->get()->getRowArray();
      foreach (json_decode($data['data'], true) as $field) {
        if ($field['visible'] == true) {
          if ($field['type'] == 'file' || $field['type'] == 'image') {
            if (boolval($field['multiple'])) {
              $form['data'][$field['name']] = json_encode(!empty($_FILES[$field['name']]) ? save_file($_FILES[$field['name']]) : []);
            } else {
              $form['data'][$field['name']] = json_encode(!empty($_FILES[$field['name']]) ? save_file($_FILES[$field['name']]) : '{}');
            }
          } else {
            $form['data'][$field['name']] = $_REQUEST[$field['name']];
          }
        }
      }
    } else {
      $form = json_decode(file_get_contents('php://input'), true);
      $tables = $this->db->getFieldData($table);
      foreach ($tables as $field) {
        if (isset($form['data'][$field->name])) {
          $form['data'][$field->name] = is_array($form['data'][$field->name]) ? json_encode($form['data'][$field->name]) : $form['data'][$field->name];
        }
      }
    }
    if ($this->db->table($table)->set($form['data'])->insert()) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
    }
    echo json_encode($response);
  }
  public function read($table = null)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $response = [];
    $tables = [];
    if (isset($form['data']['from']) and !empty($form['data']['from'])) {
      $query = $this->db->table($form['data']['from'][0]);
      unset($form['data']['from'][0]);
      foreach (array_values($form['data']['from']) as $table) {
        $tables[] = $table;
        $query->from($table);
      }
    } else {
      $tables[] = $table;
      $query = $this->db->table($table);
    }
    if (isset($form['data']['select']) and !empty($form['data']['select'])) {
      foreach ($form['data']['select'] as $value) {
        $query->select("{$value} AS " . str_replace('.', '_', $value));
      }
    }
    if (isset($form['data']['rule']) and count($form['data']['rule']) > 0) {
      foreach ($form['data']['rule'] as $field) {
        switch ($field['comparator']) {
          case 'Igual':
            $operator = '=';
            break;
          case 'No Igual':
            $operator = '!=';
            break;
          case 'Menor':
            $operator = '<';
            break;
          case 'Mayor':
            $operator = '>';
            break;
          case 'Menor o Igual':
            $operator = '<=';
            break;
          case 'Mayor o Igual':
            $operator = '>=';
            break;
          case 'Contiene':
            $operator = 'LIKE';
            break;

          case '=':
            $operator = '=';
            break;
          case '!=':
            $operator = '!=';
            break;
          case '<':
            $operator = '<';
            break;
          case '>':
            $operator = '>';
            break;
          case '<=':
            $operator = '<=';
            break;
          case '>=':
            $operator = '>=';
            break;
          case 'LIKE':
            $operator = 'LIKE';
            break;

          default:
            $operator = '=';
            break;
        }

        switch ($field['value']) {
          case '':
            $value = null;
            break;

          default:
            $value = (isset($field['type']) && $field['type']=='prop')?$form['props'][$field['value']]:$field['value'];
            break;
        }
        if ($operator == 'LIKE') {
          if ($field['conector'] == 'OR') {
            $query->orLike($field['key'], $value, 'both', false);
          } else {
            $query->like($field['key'], $value, 'both', false);
          }
        } else {
          if ($field['conector'] == 'OR') {
            $query->orWhere("{$field['key']} {$operator}", $value, $field['escape']);
          } else {
            $query->where("{$field['key']} {$operator}", $value, $field['escape']);
          }
        }
      }
    }
    if (isset($form['data']['group'])) {
      foreach ($form['data']['group'] as $item) {
        $query->groupStart();
        foreach ($item['rule'] as $field) {
          switch ($field['comparator']) {
            case 'Igual':
              $operator = '=';
              break;
            case 'No Igual':
              $operator = '!=';
              break;
            case 'Menor':
              $operator = '<';
              break;
            case 'Mayor':
              $operator = '>';
              break;
            case 'Menor o Igual':
              $operator = '<=';
              break;
            case 'Mayor o Igual':
              $operator = '>=';
              break;
            case 'Contiene':
              $operator = 'LIKE';
              break;

            default:
              $operator = '=';
              break;
          }
          switch ($field['value']) {
            case '':
              $value = null;
              break;

            default:
              $value = $field['value'];
              break;
          }
          if ($operator == 'LIKE') {
            if ($field['conector'] == 'OR') {
              $query->orLike($field['key'], $value, 'both', false);
            } else {
              $query->like($field['key'], $value, 'both', false);
            }
          } else {
            if ($field['conector'] == 'OR') {
              $query->orWhere("{$field['key']} {$operator}", $value);
            } else {
              $query->where("{$field['key']} {$operator}", $value);
            }
          }
        }
        $query->groupEnd();
      }
    }
    $response = $query->get()->getResultArray();
    $query_fields = $this->db->query($this->db->getLastQuery());
    if (isset($form['result']) and $form['result'] == 'row') {
      foreach ($query_fields->getFieldNames() as $field) {
        $decode = json_decode($response[0][$field->name]);
        $response[0][$field] = !is_array($decode) ? $response[0][$field] : json_decode($response[0][$field]);
      }
    } else {
      foreach ($response as $key => $value) {
        foreach ($query_fields->getFieldNames() as $field) {
          $decode = json_decode($response[$key][$field], true);
          $response[$key][$field] = !is_array($decode) ? $response[$key][$field] : json_decode($response[$key][$field], true);
        }
      }
    }
    if (isset($form['result']) and $form['result'] == 'row') {
      echo json_encode($response[0]);
    } else {
      echo json_encode($response);
    }
  }
  public function update($table)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    unset($form['data']['']);
    foreach ($form['data'] as $key => $value) {
      if (!empty($key)) {
        $convert = json_decode($form['data'][$key], true);
        $form['data'][$key] = !is_array($convert) ? $value : json_encode($form['data'][$key]);
      }
    }
    if ($this->db->table($table)->set($form['data'])->where($form['where'])->update()) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
    }
    echo json_encode($response);
  }
  public function delete($table)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    unset($form['data']['']);
    if ($this->db->table($table)->where($form['where'])->delete()) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
    }
    echo json_encode($response);
  }
  public function view($table = null)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $response = [];
    $tables = [];
    if (isset($form['data']['from']) and !empty($form['data']['from'])) {
      $query = $this->db->table($form['data']['from'][0]);
      unset($form['data']['from'][0]);
      foreach (array_values($form['data']['from']) as $table) {
        $tables[] = $table;
        $query->from($table);
      }
    } else {
      $tables[] = $table;
      $query = $this->db->table($table);
    }
    if (isset($form['data']['select']) and !empty($form['data']['select'])) {
      foreach ($form['data']['select'] as $value) {
        $query->select("{$value} AS " . str_replace('.', '_', $value));
      }
    }
    if (isset($form['data']['rule']) and count($form['data']['rule']) > 0) {
      foreach ($form['data']['rule'] as $field) {
        switch ($field['comparator']) {
          case 'Igual':
            $operator = '=';
            break;
          case 'No Igual':
            $operator = '!=';
            break;
          case 'Menor':
            $operator = '<';
            break;
          case 'Mayor':
            $operator = '>';
            break;
          case 'Menor o Igual':
            $operator = '<=';
            break;
          case 'Mayor o Igual':
            $operator = '>=';
            break;
          case 'Contiene':
            $operator = 'LIKE';
            break;

          case '=':
            $operator = '=';
            break;
          case '!=':
            $operator = '!=';
            break;
          case '<':
            $operator = '<';
            break;
          case '>':
            $operator = '>';
            break;
          case '<=':
            $operator = '<=';
            break;
          case '>=':
            $operator = '>=';
            break;
          case 'LIKE':
            $operator = 'LIKE';
            break;

          default:
            $operator = '=';
            break;
        }

        switch ($field['value']) {
          case '':
            $value = null;
            break;

          default:
            $value = $field['value'];
            break;
        }
        if ($operator == 'LIKE') {
          if ($field['conector'] == 'OR') {
            $query->orLike($field['key'], $value, 'both', false);
          } else {
            $query->like($field['key'], $value, 'both', false);
          }
        } else {
          if ($field['conector'] == 'OR') {
            $query->orWhere("{$field['key']} {$operator}", $value, $field['escape']);
          } else {
            $query->where("{$field['key']} {$operator}", $value, $field['escape']);
          }
        }
      }
    }
    if (isset($form['data']['group'])) {
      foreach ($form['data']['group'] as $item) {
        $query->groupStart();
        foreach ($item['rule'] as $field) {
          switch ($field['comparator']) {
            case 'Igual':
              $operator = '=';
              break;
            case 'No Igual':
              $operator = '!=';
              break;
            case 'Menor':
              $operator = '<';
              break;
            case 'Mayor':
              $operator = '>';
              break;
            case 'Menor o Igual':
              $operator = '<=';
              break;
            case 'Mayor o Igual':
              $operator = '>=';
              break;
            case 'Contiene':
              $operator = 'LIKE';
              break;

            default:
              $operator = '=';
              break;
          }
          switch ($field['value']) {
            case '':
              $value = null;
              break;

            default:
              $value = $field['value'];
              break;
          }
          if ($operator == 'LIKE') {
            if ($field['conector'] == 'OR') {
              $query->orLike($field['key'], $value, 'both', false);
            } else {
              $query->like($field['key'], $value, 'both', false);
            }
          } else {
            if ($field['conector'] == 'OR') {
              $query->orWhere("{$field['key']} {$operator}", $value);
            } else {
              $query->where("{$field['key']} {$operator}", $value);
            }
          }
        }
        $query->groupEnd();
      }
    }
    $query->where($form['main']);
    $response = $query->get()->getResultArray();
    $query_fields = $this->db->query($this->db->getLastQuery());
    if (isset($form['result']) and $form['result'] == 'row') {
      foreach ($query_fields->getFieldNames() as $field) {
        $decode = json_decode($response[0][$field->name]);
        $response[0][$field] = !is_array($decode) ? $response[0][$field] : json_decode($response[0][$field]);
      }
    } else {
      foreach ($response as $key => $value) {
        foreach ($query_fields->getFieldNames() as $field) {
          $decode = json_decode($response[$key][$field], true);
          $response[$key][$field] = !is_array($decode) ? $response[$key][$field] : json_decode($response[$key][$field], true);
        }
      }
    }
    if (isset($form['result']) and $form['result'] == 'row') {
      echo json_encode($response[0]);
    } else {
      echo json_encode($response);
    }
  }
}