<?php

namespace App\Controllers;

class Message extends BaseController
{
  public function get($id = null)
  {
    $form = json_decode(file_get_contents('php://input'), true);

    $sttm = $this->db->table('sys_messenger sm');
    $array = true;
    if (isset($form['select'])) { 
      $sttm->select($form['select']);
    }

    if (isset($form['where'])) {
      foreach ($form['where'] as $key => $value) {
        $sttm->where($key,$value);
      } 
    }

    if (isset($form['inner_join'])) {
      foreach ($form['inner_join'] as $key => $value) {
        $sttm->join($key,$value,"inner");
      } 
    }

    if (isset($form['left_join'])) {
      foreach ($form['left_join'] as $key => $value) {
        $sttm->join($key,$value,"left");
      } 
    }

    if (isset($form['group_by'])) {
      foreach ($form['group_by'] as $value) {
        $sttm->groupBy($value);
      } 
    }

    $results = $sttm->get()->getResultArray();

    $response = $results;
    if (isset($form['result']) && $form['result']=='row') {
      $array = false;
      $response = $results[0];
    }

    echo json($response,true,$array);
  }

  public function sendEmail($tbl)
  {
    $form = json_decode(file_get_contents('php://input'), true);

    $data = [];
    foreach ($form as $item) {
      $data[$item['key']] = is_array($item['value'])?json_encode($item['value']):$item['value'];
    }

    $att = null;

    if ($data['file']) {
      $exp = explode(',', $data['file']);
      $fileContent = $exp[1];
      $decodeFile = base64_decode($fileContent);

      $exp2 = explode(';',$exp[0]);
      $exp3 = explode('/',$exp2[0]);


      $file_name = 'file.'.$exp3[1];
      $att = WRITEPATH.'uploads/'.$file_name;
      file_put_contents($att,$decodeFile);
    }
    $content = '';

    foreach ($form as $item) {
      if ($item['key'] !== 'file') {
        $content .= '
          <dt>'.$item['label'].'</dt>
          <dd>'.$item['value'].'</dd><br/>';
      }
    }

    $st = $this->db->table($tbl)->set($data)->insert();
    $messenger = $this->db->table('sys_settings')->where(['key'=>'contact','value'=>'true'])->get()->getRowArray();
    if ($st and $messenger) {
      $config['mailType'] = 'html';
      $config['wordWrap'] = true;

      $email = service('email');
      $email->initialize($config);

      $email->setFrom('info@prominsac.com', 'Prominsac');
      $email->setTo(json_decode($messenger['config'],true));
      if ($att) {
        $email->attach($att,$file_name);
      }

      $email->setSubject('Mensaje de Contacto');
      $email->setMessage($content);

      $email->send();
      //unlink($att);
    }
  }

  public function set($id)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $data = [];
    foreach ($form as $key => $value) {
      $data[$key] = is_array($value)?json_encode($value):$value;
    }
    $where['ID'] = $id;
    $st = $this->post->set($data)->where($where)->update();
  }
}