<?php

namespace App\Controllers;

class Importer extends BaseController
{
  public function add()
  {
    $dec = file_get_contents($_FILES['file']['tmp_name']);
    $json = json_decode($dec,true);
    echo json_encode($json);
  }

  public function execute_import()
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $fields = [];
    $time = time();
    $name = isset($form['name'])?url_title($form['name'],'_'):"data_import_{$time}";
    $fields[] = [
      'name'=> "ID{$name}",
      'type'=> 'INT',
      'length'=> 11,
      'auto_increment'=>true,
      'nullable'=>false,
      'default'=>''
    ];
    $fields[] = [
      'name'=> "geometry_data",
      'type'=> 'LONGTEXT',
      'length'=> '',
      'auto_increment'=>false,
      'nullable'=>true,
      'default'=>''
    ];
    foreach ($form['data'][0]['properties'] as $key => $value) {
      if (in_array($key, $form['fields'])) {
        switch (gettype($value)) {
          case 'integer':
            $type = 'INT';
            $length = 11;
          break;
          case 'string':
            $type = 'TEXT';
            $length = '';
          break;
          case 'double':
            $v_l = explode('.',$value);
            $int = strlen($v_l[0]);
            $dec = strlen($v_l[1]);
            $ints = $int+$dec;
            $type = 'DOUBLE';
            $length = "{$ints},{$dec}";
          break;
          default:
            $type = 'TEXT';
            $length = '';
          break;
        }
        $fields[] = [
          'name'=> $key,
          'type'=> $type,
          'length'=> $length,
          'auto_increment'=>false,
          'nullable'=>true,
          'default'=>''
        ];
      }
    }
    $sql = create_table($name, $fields, ['primary'=>["ID{$name}"]], []);
    $ret = $this->db->query($sql);
    if ($ret) {
      $ins_value = [];
      foreach ($form['data'] as $item) {
        $data = [];
        foreach ($item['properties'] as $key => $value) {
          if (in_array($key, $form['fields'])) {
            $data[$key] = $value;
          }
        }
        $data['geometry_data'] = json_encode($item['geometry']['coordinates']);
        $ins_value[] = $data;
      }
      $ins = $this->db->table($name)->insertBatch($ins_value);
      if ($ins) {
        $response['code'] = 200;
        $response['message'] = "Datos importados correctamente";
      } else {
        $response['code'] = 500;
        $response['message'] = $this->db->error();
      }
    } else {
      $response['code'] = 500;
      $response['message'] = $this->db->error();
    }

    echo json_encode($response);
  }
}