Vue.component('job-form', {
    template: `
  <div>
    <v-form ref='form' v-on:submit.prevent='Send()' lazy-validation>
      <v-row>
        <v-col cols="12" md="6">
          <v-text-field v-model="message.full_name" ref="full_name" label="Nombres" outlined :rules="[rules.required]"></v-text-field>
        </v-col>
        <v-col cols="12" md="6">
          <v-text-field v-model="message.phone" type="tel" ref="phone" label="Telefono" outlined></v-text-field>
        </v-col>
        <v-col cols="12" md="12" class="my-n7">
          <v-text-field v-model="message.email" type="email" ref="email" label="Correo" outlined required :rules="[rules.required,rules.email]"></v-text-field>
        </v-col>
        <v-col cols="12" md="12" v-if="message.file">
          <v-chip color="success" close @click:close="message.file = ''">
            Documento Adjunto
          </v-chip>
        </v-col>
        <v-col cols="12" md="12">
          <v-file-input @change="RenderFile('render_file','file')" ref="render_file" label="Adjunto" outlined accept=".doc,.docx,.pdf" persistent-hint hint="Permite Doc, Docx y PDF"></v-file-input>
        </v-col>
        <v-col cols="12" md="12">
          <v-textarea v-model="message.message" ref="message" label="Mensaje" outlined auto-grow rows="2"></v-textarea>
        </v-col>
        <v-col cols="12" md="12" class="mb-n7 mt-n14">
          <v-checkbox v-model="policy" outlined>
            <template v-slot:label>
              Acepto los Términos y condiciones
            </template>
          </v-checkbox>
        </v-col>
        <v-col cols="12" md="12">
          <v-btn text plain block color="rgb(243, 118, 29)" class="text-capitalize font-weight-black" target="_blank" :href="content.policy?content.policy.link:undefined">
            <v-icon>mdi-open-in-new</v-icon> Ver Términos y condiciones
          </v-btn>
        </v-col>
        <v-col cols="12" md="12" class="d-flex align-center justify-center">
          <v-hover v-slot="{ hover }">
            <v-btn color="#f3761d" rounded :outlined="hover?false:true" :class="hover?'white--text':''" x-large :disabled="!policy" type="submit">
              Enviar
            </v-btn>
          </v-hover>
        </v-col>
      </v-row>
    </v-form>
    <v-dialog
      v-model="send"
      width="300"
    >
      <v-card>
        <v-card-text>
          <p class=" mt-4 text-h4 text-center">Mensaje Enviado</p>
        </v-card-text>
        <v-card-actions>
          <v-btn @click="send = false" block plain>Cerrar</v-btn>
        </v-card-actions>
      </v-card>
    </v-dialog>
  </div>
  `,
  data: function() {
    return {
      message: {
        full_name:'',
        phone: '',
        email: '',
        file: '',
        message: '',
      },
      file_preview: '',
      policy:false,
      content:{
        policy:null,
      },
      send:false,
      valid:false,
      rules:{
        url: v=>!!(v||'').match(/^(http|https):\/\/+[\www\d]+\.[\w]+(\/[\w\d]+)?/) || 'Please enter a valid url',
        email: v => !!(v || '').match(/@/) || 'Please enter a valid email',
        length: len => v => (v || '').length >= len || `Invalid character length, required ${len}`,
        password: v => !!(v || '').match(/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$/) || 'Password must contain an upper case letter, a numeric character, and a special character',
        required: v => !!v || 'This field is required'
      },
    }
  },
  props: ['actions'],
  methods: {
    Send: function() {
      this.$refs.form.validate()
      this.valid = this.$refs.form.validate()
      var arr = Object.keys(this.$refs)
      if (this.valid) {
        var set_form = []
        for (var i = 0; i < arr.length; i++) {
          if(arr[i]!=="form"){
            if (arr[i] == 'render_file') {
              set_form.push({... { key:'file', value:this.message.file, label:this.$refs[arr[i]].label } })
            } else {
              set_form.push({... { key:arr[i], value:this.message[arr[i]], label:this.$refs[arr[i]].label } })
            }
          }
        }
        axios.post("Message/sendEmail/jobs", set_form).then((response) => {
          this.data = response.data
          if (response.status == 200) {
            this.send = true
            this.$refs.form.reset()
            this.valid = false
          } else {
            this.send = false
          }
        })
      }
    },
    RenderFile(r,f) {
      if (this.$refs[r].lazyValue !== null) {
        const file = this.$refs[r].lazyValue
        const reader = new FileReader()
        reader.onload = (e) => {
          this.message[f] = e.target.result
        }
        reader.readAsDataURL(file)
      } else {
        this.message[f] = null
      }
    },
  },
  beforeMount(){
    axios.post("API/get/web_content", {where:{code:'link2'}}).then((response) => {
      this.content.policy = response.data[0]
    })
  },
})
Vue.component('contact-form', {
    template: `
  <div>
    <v-form ref='form' v-on:submit.prevent='Send()' lazy-validation>
      <v-row>
        <v-col cols="12" md="6">
          <v-text-field :dark="attr.dark" v-model="message.full_name" ref="full_name" label="Nombres" outlined :rules="[rules.required]"></v-text-field>
        </v-col>
        <v-col cols="12" md="6">
          <v-text-field :dark="attr.dark" v-model="message.phone" type="tel" ref="phone" label="Telefono" outlined></v-text-field>
        </v-col>
        <v-col cols="12" md="6" class="my-n7">
          <v-text-field :dark="attr.dark" v-model="message.email" type="email" ref="email" label="Correo" outlined required :rules="[rules.required,rules.email]"></v-text-field>
        </v-col>
        <v-col cols="12" md="6" class="my-n7">
          <v-text-field :dark="attr.dark" v-model="message.company" type="email" ref="company" label="Empresa" outlined required :rules="[rules.required]"></v-text-field>
        </v-col>
        <v-col cols="12" md="12">
          <v-textarea :dark="attr.dark" v-model="message.message" ref="message" label="Mensaje" outlined auto-grow rows="2"></v-textarea>
        </v-col>
        <v-col cols="12" md="12" class="mb-n7 mt-n14">
          <v-checkbox :dark="attr.dark" v-model="policy" outlined>
            <template v-slot:label>
              Acepto los Términos y condiciones
            </template>
          </v-checkbox>
        </v-col>
        <v-col cols="12" md="12">
          <v-btn text plain :color="attr.color" block class="text-capitalize font-weight-black" target="_blank" :href="content.policy?content.policy.link:undefined">
            <v-icon>mdi-open-in-new</v-icon> Ver Términos y condiciones
          </v-btn>
        </v-col>
        <v-col cols="12" md="12" class="d-flex align-center justify-center">
          <v-hover v-slot="{ hover }">
            <v-btn :dark="attr.dark" :color="attr.color" rounded :outlined="hover?false:true" :class="hover?'white--text':''" x-large :disabled="!policy" type="submit">
              Enviar
            </v-btn>
          </v-hover>
        </v-col>
      </v-row>
    </v-form>
    <v-dialog
      v-model="send"
      width="300"
    >
      <v-card>
        <v-card-text>
          <p class=" mt-4 text-h4 text-center">Mensaje Enviado</p>
        </v-card-text>
        <v-card-actions>
          <v-btn @click="send = false" block plain>Cerrar</v-btn>
        </v-card-actions>
      </v-card>
    </v-dialog>
  </div>
  `,
  data: function() {
    return {
      message: {
        full_name:'',
        phone: '',
        email: '',
        company: '',
        message: '',
      },
      policy:false,
      send:false,
      valid:false,
      content:{
        policy:null
      },
      rules:{
        url: v=>!!(v||'').match(/^(http|https):\/\/+[\www\d]+\.[\w]+(\/[\w\d]+)?/) || 'Please enter a valid url',
        email: v => !!(v || '').match(/@/) || 'Please enter a valid email',
        length: len => v => (v || '').length >= len || `Invalid character length, required ${len}`,
        password: v => !!(v || '').match(/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$/) || 'Password must contain an upper case letter, a numeric character, and a special character',
        required: v => !!v || 'This field is required'
      },
      attr:{
        dark:false,
        color:'f3761d',
      }
    }
  },
  props: ['dark', 'color'],
  methods: {
    Send: function() {
      this.$refs.form.validate()
      this.valid = this.$refs.form.validate()
      var arr = Object.keys(this.$refs)
      if (this.valid) {
        var set_form = []
        for (var i = 0; i < arr.length; i++) {
          if(arr[i]!=="form"){
            set_form.push({... { key:arr[i], value:this.message[arr[i]], label:this.$refs[arr[i]].label } })
          }
        }
        axios.post("Message/sendEmail/leads", set_form).then((response) => {
          this.data = response.data
          if (response.status == 200) {
            this.send = true
            this.$refs.form.reset()
            this.valid = false
          } else {
            this.send = false
          }
        })
      }
    },
  },
  beforeMount(){
    axios.post("API/get/web_content", {where:{code:'link2'}}).then((response) => {
      this.content.policy = response.data[0]
    })
  },
  created(){
    if (this.dark) {
      this.attr.dark = this.dark
    }
    if (this.color) {
      this.attr.color = this.color
    }
  }
})

Vue.component('service-list', {
    template: `
  <div>
    <div v-if="!screen">
      <v-row>
        <v-col cols="12" lg="4" md="6" sm="12" v-for="(item,i) in data">
          <v-hover v-slot="{ hover }">
            <v-card :rounded="'xl'" :elevation="hover?12:0">
              <v-img v-if="item.picture" :src="item.picture" :aspect-ratio="hover?1.1/1.2:1/1">
                <v-expand-transition>
                  <div style="background-color:rgba(243, 118, 29, .7);height:100%"
                    v-if="hover"
                    class="d-flex justify-center align-center v-card--reveal text-h2 white--text text-center"
                  >
                    {{item.title}}
                  </div>
                </v-expand-transition>
                <div v-if="!hover" class="d-flex justify-center align-center white--text text-center px-2" :style="{position:'absolute',backgroundColor:'rgba(28, 28, 28, .8)',fontSize: $root.clampCss(1.2),height:'25%', width:'100%',bottom:'0%',right:'0%'}">
                  {{item.title}}
                </div>
              </v-img>
            </v-card>
          </v-hover>
        </v-col>
      </v-row>
    </div>
    <div v-else>
      <v-row>
        <v-col cols="12"  md="12" v-if="screen=='loading'">
          <v-card width="100%" outlined>
            <v-card-title class="d-flex justify-center">
              <span>
                <v-progress-circular :size="70" :width="7" color="rgb(15,89,122)" indeterminate ></v-progress-circular>
              </span>
            </v-card-title>
            <v-card-title class="d-flex justify-center">
              <span class="text-h5">Loading...</span>
            </v-card-title>
          </v-card>
        </v-col>
        <v-col cols="12"  md="12" v-if="screen=='empty'">
          <v-card width="100%" outlined>
            <v-card-title class="d-flex justify-center">
              <span>
                <v-icon style="font-size:100px" color="rgb(15,89,122)">mdi-emoticon-sad-outline</v-icon>
              </span>
            </v-card-title>
            <v-card-title class="d-flex justify-center">
              <span class="text-h5">Can’t find what you’re looking for? Contact us here.</span>
            </v-card-title>
          </v-card>
        </v-col>
      </v-row>
    </div>
  </div>
  `,
  data: function() {
    return {
      data: [],
      screen: null,
      selected: null
    }
  },
  props: ['select', 'inner_join', 'left_join', 'order_by', 'group_by', 'limit', 'where', 'orwhere', 'like'],
  methods: {
    Data() {
      var params = this.$options.propsData
      this.screen = 'loading'
      axios.post("API/get/services", params).then((response) => {
        this.data = response.data
        if (response.data.length < 1) {
          this.screen = 'empty'
        } else {
          this.screen = null
        }
      })
    }
  },
  created: function() {
    this.Data()
  }
})

Vue.component('project-list', {
    template: `
  <div>
    <div v-if="!screen">
      <v-row>
        <v-col cols="12" lg="4" md="6" sm="12" v-for="(item,i) in data">
          <v-hover v-slot="{ hover }">
            <v-card :rounded="'xl'" :elevation="hover?12:0" @click="$root.Url('proyecto',item.id)">
              <v-img v-if="item.gallery" :src="item.gallery[0]" :aspect-ratio="hover?1.1/1.2:1/1">
                <v-expand-transition>
                  <div :style="{backgroundColor:i%2==0?'rgba(243, 118, 29, .7)':'rgba(28, 28, 28, .8)',color:i%2==0?'black':'white',height:'100%'}"
                    v-if="hover"
                    class="d-flex justify-center align-center v-card--reveal text-h3 text-center"
                  >
                    {{item.title}}
                  </div>
                </v-expand-transition>
                <div v-if="!hover" class="d-flex justify-center align-center white--text text-center px-2" :style="{position:'absolute',backgroundColor:i%2==0?'rgba(28, 28, 28, .8)':'rgba(243, 118, 29, .7)',fontSize: $root.clampCss(1.1),height:'25%', width:'100%',bottom:'0%',right:'0%'}">
                  {{item.title}}
                </div>
              </v-img>
            </v-card>
          </v-hover>
        </v-col>
      </v-row>
    </div>
    <div v-else>
      <v-row>
        <v-col cols="12"  md="12" v-if="screen=='loading'">
          <v-card width="100%" outlined>
            <v-card-title class="d-flex justify-center">
              <span>
                <v-progress-circular :size="70" :width="7" color="rgb(15,89,122)" indeterminate ></v-progress-circular>
              </span>
            </v-card-title>
            <v-card-title class="d-flex justify-center">
              <span class="text-h5">Loading...</span>
            </v-card-title>
          </v-card>
        </v-col>
        <v-col cols="12"  md="12" v-if="screen=='empty'">
          <v-card width="100%" outlined>
            <v-card-title class="d-flex justify-center">
              <span>
                <v-icon style="font-size:100px" color="rgb(15,89,122)">mdi-emoticon-sad-outline</v-icon>
              </span>
            </v-card-title>
            <v-card-title class="d-flex justify-center">
              <span class="text-h5">Can’t find what you’re looking for? Contact us here.</span>
            </v-card-title>
          </v-card>
        </v-col>
      </v-row>
    </div>
  </div>
  `,
  data: function() {
    return {
      data: [],
      screen: null,
      selected: null
    }
  },
  props: ['select', 'inner_join', 'left_join', 'order_by', 'group_by', 'limit', 'where', 'orwhere', 'like'],
  methods: {
    Data() {
      var params = this.$options.propsData
      this.screen = 'loading'
      axios.post("API/get/projects", params).then((response) => {
        this.data = response.data
        if (response.data.length < 1) {
          this.screen = 'empty'
        } else {
          this.screen = null
        }
      })
    }
  },
  created: function() {
    this.Data()
  }
})

Vue.component('blog-list', {
    template: `
  <div>
    <div v-if="!screen">
      <v-row>
        <v-col cols="12" lg="4" md="6" sm="12" v-for="(item,i) in data">
          <v-hover v-slot="{ hover }">
            <v-card :rounded="'xl'" :elevation="hover?12:0" :outlined="hover?false:true">
              <v-img v-if="item.picture" :src="item.picture" :aspect-ratio="hover?1/1.1:1/1">
                <v-expand-transition>
                  <div style="background-color:rgba(243, 118, 29, .7);height:100%"
                    v-if="hover"
                    class="d-flex justify-center align-center v-card--reveal text-h5 white--text text-center"
                  >
                    {{item.description}}
                  </div>
                </v-expand-transition>
                <div v-if="!hover" class="d-flex justify-center align-center white--text text-center px-2" :style="{position:'absolute',backgroundColor:'rgba(28, 28, 28, .8)',fontSize: $root.clampCss(1),height:'30%', width:'100%',bottom:'0%',right:'0%'}">
                  {{item.title}}
                </div>
              </v-img>
              <v-card-text class="d-flex justify-center align-center" v-else>
                <div>
                  <v-card-title>{{item.title}}</v-card-title>
                  <p class="text-subtitl">{{item.description}}</p>
                </div>
              </v-card-text>
              <v-expand-transition>
                <v-card-actions class="d-flex flex-column" v-if="hover">
                  <v-btn text block plain color="rgb(243, 118, 29)" @click="$root.Url('publicacion',item.id)">
                    Leer más
                  </v-btn>
                </v-card-actions>
              </v-expand-transition>
            </v-card>
          </v-hover>
        </v-col>
      </v-row>
    </div>
    <div v-else>
      <v-row>
        <v-col cols="12"  md="12" v-if="screen=='loading'">
          <v-card width="100%" outlined>
            <v-card-title class="d-flex justify-center">
              <span>
                <v-progress-circular :size="70" :width="7" color="rgb(15,89,122)" indeterminate ></v-progress-circular>
              </span>
            </v-card-title>
            <v-card-title class="d-flex justify-center">
              <span class="text-h5">Loading...</span>
            </v-card-title>
          </v-card>
        </v-col>
        <v-col cols="12"  md="12" v-if="screen=='empty'">
          <v-card width="100%" outlined>
            <v-card-title class="d-flex justify-center">
              <span>
                <v-icon style="font-size:100px" color="rgb(15,89,122)">mdi-emoticon-sad-outline</v-icon>
              </span>
            </v-card-title>
            <v-card-title class="d-flex justify-center">
              <span class="text-h5">Can’t find what you’re looking for? Contact us here.</span>
            </v-card-title>
          </v-card>
        </v-col>
      </v-row>
    </div>
  </div>
  `,
  data: function() {
    return {
      data: [],
      screen: null,
      selected: null
    }
  },
  props: ['select', 'inner_join', 'left_join', 'order_by', 'group_by', 'limit', 'where', 'orwhere', 'like'],
  methods: {
    Data() {
      var params = this.$options.propsData
      this.screen = 'loading'
      axios.post("API/get/news", params).then((response) => {
        this.data = response.data
        if (response.data.length < 1) {
          this.screen = 'empty'
        } else {
          this.screen = null
        }
      })
    }
  },
  created: function() {
    this.Data()
  }
})

Vue.component('page-home', {
  template: `
  <div>
    <v-container fluid class="pa-0 mb-0" v-if="content.hero">
      <v-img :src="content.hero.picture" height="100vh" width="100vw"  position="center bottom" gradient="0deg, rgba(0,0,0,.33), rgba(0,0,0,.7)">
        <v-row class="fill-height" no-gutters>
          <v-col cols="12" md="6" class="d-flex align-end px-8">
            <p class="white--text" v-html="content.hero.description"></p>
          </v-col>
          <v-col cols="12" class="d-flex align-center px-8">
            <v-hover v-slot="{ hover }">
              <v-btn color="#f3761d" rounded class="font-weight-black" x-large>
                <span :class="hover?'black--text':'white--text'">
                  {{content.hero.text}}
                </span>
              </v-btn>
            </v-hover>
          </v-col>
        </v-row>
      </v-img>
    </v-container>

    <v-container fluid class="pa-0 mt-n6" v-if="content.service">
      <v-sheet min-height="100vh" color="rgb(28,28,28)">
        <v-row class="pt-4 px-4 px-sm-4 px-md-16 px-lg-16">
          <v-col cols="12" md="8" >
            <div>
              <p class="my-auto" :style="{fontSize: $root.clampCss(1.5),fontWeight:800,color:'#f3761d'}">{{content.service.title}}</p>
              <p class="my-auto" :style="{fontSize: $root.clampCss(1.6),color:'white'}">{{content.service.description}}</p>
            </div>
          </v-col>
          <v-col cols="12" md="4" v-if="content.service.text" class="d-flex align-center justify-end">
            <v-hover v-slot="{ hover }">
              <v-btn color="#f3761d" rounded :class="hover?'font-weight-black white--text text-capitalize':'font-weight-black text-capitalize'" :href="content.service.link?content.service.link:undefined">
                {{content.service.text}}
              </v-btn>
            </v-hover>
          </v-col>
        </v-row>
        <v-row class="pt-4 pb-5 px-4 px-sm-4 px-md-16 px-lg-16">
          <v-col cols="12">
            <service-list :where="{id:content.service.content}""></service-list>
          </v-col>
        </v-row>
        <v-row class="pt-4 pb-5 px-4 px-sm-4 px-md-16 px-lg-16">
          <v-col cols="12" md="4" v-if="content.service.text">
            <v-hover v-slot="{ hover }">
              <v-btn color="#f3761d" rounded :class="hover?'font-weight-black white--text text-capitalize':'font-weight-black text-capitalize'" :href="content.service.link?content.service.link:undefined">
                {{content.service.text}}
              </v-btn>
            </v-hover>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>

    <v-container fluid class="pa-0 mt-n6" v-if="content.project">
      <v-sheet min-height="100vh">
        <v-row no-gutters class="fill-height pt-4 px-4 px-sm-4 px-md-16 px-lg-16">
          <v-col cols="12" md="6" class="d-flex align-center pa-0">
            <div>
              <p class="my-auto" :style="{fontSize: $root.clampCss(1.5),fontWeight:800,color:'#f3761d'}">{{content.project.title}}</p>
              <p class="my-auto" :style="{fontSize: $root.clampCss(1.6)}">{{content.project.description}}</p>
              <v-hover v-slot="{ hover }" v-if="content.project.text">
                <v-btn color="#f3761d" rounded :outlined="hover?false:true" :class="hover?'font-weight-black white--text text-capitalize mt-5':'font-weight-black text-capitalize mt-5'" :href="content.project.link?content.project.link:undefined" x-large>
                  {{content.project.text}}
                </v-btn>
              </v-hover>
            </div>
          </v-col>
          <v-col cols="12" md="6" class="d-flex align-center justify-center" >
            <v-card color="#f3761d" tile height="100%" width="100%">
              <v-carousel
                :continuous="true"
                :cycle="true"
                show-arrows
                hide-delimiter-background
                delimiter-icon="mdi-minus"
                height="100%"
              >
                <v-carousel-item
                  v-for="(slide, i) in content.project_gallery"
                  :key="i"
                >
                  <v-img
                    :src="slide"
                    height="100%"
                    tile
                  >
                    <v-row
                      class="fill-height"
                      align="center"
                      justify="center"
                    >
                      <div class="text-h2">
                      </div>
                    </v-row>
                  </v-img>
                </v-carousel-item>
              </v-carousel>
            </v-card>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>
  </div>
  `,
  data: function() {
    return {
      loader:{
        scroll:0
      },
      content:{
        hero:null,
        service:null,
        project:null,
        project_gallery:[],
      },
      modal: {
        start: false,
        end: false,
        video: false,
        sale:0,
        charter:0,
        size:{
          x:self.innerWidth,
          y:self.innerHeight
        },
      },
      similars:[],
      form: {
        date_start: (new Date(Date.now() - (new Date()).getTimezoneOffset() * 60000)).toISOString().substr(0, 10),
        date_end: "",
        type: ''
      }
    }
  },
  props: ['actions'],
  methods: {
    handleScroll: function() {
      this.loader.scroll = window.scrollY
      this.modal.video = this.loader.scroll>0?false:true
    },
    handleSize: function() {
      this.modal.size.x = self.innerWidth
      this.modal.size.y = self.innerHeight
    },
    minDate: function() {
      return (new Date(Date.now() - (new Date()).getTimezoneOffset() * 60000)).toISOString().substr(0, 10)
    },
  },
  beforeMount(){
    axios.post("API/get/web_content", {where:{code:'hero'}}).then((response) => {
      this.content.hero = response.data[0]
    })
    axios.post("API/get/web_content", {where:{code:'service'}}).then((response) => {
      this.content.service = response.data[0]
    })
    axios.post("API/get/web_content", {where:{code:'project'}}).then((response) => {
      this.content.project = response.data[0]
      axios.post("API/get/projects", {where:{id:this.content.project.content}}).then((res) => {
        for (var d = 0; d < res.data.length; d++) {
          for (var i = 0; i < res.data[d].gallery.length; i++) {
            this.content.project_gallery.push(res.data[d].gallery[i])
          }
        }
      })
    })
  },
  created(){
    document.title = "Home"
    window.addEventListener('scroll', this.handleScroll);
    window.addEventListener("resize", this.handleSize);
  },
  destroyed () {
    window.removeEventListener('scroll', this.handleScroll);
    window.removeEventListener("resize", this.handleSize);
  }
})

Vue.component('page-servicios', {
template: `
  <div>
    <v-divider dark class="my-6"></v-divider>
    <v-container fluid class="pa-0 mb-0 mt-16">
      <v-sheet height="30vh">
        <v-row class="fill-height" no-gutters>
          <v-col cols="12" md="12" class="d-flex justify-center align-center px-8">
            <div>
              <p class="text-h5 text-center">Servicios</p>
              <p class="text-h4 text-center">Somos expertos en lo que hacemos</p>
            </div>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>

    <v-container fluid class="pa-0">
      <v-sheet :color="i%2==0?'rgb(248, 248, 248)':'rgb(28,28,28)'" v-for="(item,i) in content.services">
        <v-row class="pt-4 px-4 px-sm-4 px-md-16 px-lg-16 fill-height py-6">
          <v-col cols="12" md="5" :class="'d-flex align-center '+(i%2==0?'order-2':'order-1')">
            <v-card height="100%" :rounded="'xl'">
              <v-img :src="item.picture"></v-img>
            </v-card>
          </v-col>
          <v-col cols="12" md="7" :class="'d-flex align-center '+(i%2==0?'order-1':'order-2')">
            <div  :class="i%2==0?'':'white--text'">
              <div class="font-weight-bold" :style="{fontSize:$root.clampCss(1.5)}">{{item.title}}</div>
              <div class="" :style="{fontSize:$root.clampCss(.9)}" v-html="item.content"></div>
            </div>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>
    <v-container fluid class="pa-0">
      <v-sheet min-height="100vh" color="rgb(243, 118, 29)">
        <v-row class="pt-4 px-4 px-sm-4 px-md-16 px-lg-16 fill-height py-6">
          <v-col cols="12" md="6">
            <v-card height="100%" class="d-flex align-center" flat tile color="transparent">
              <v-card-text>
                <p class="text-center text-h4 font-weight-black white--text">
                  Nos adaptamos a ti
                </p>
                <p class="white--text text-title">
                  Quienes formamos parte de Proyectos y Mantenimientos Integrales S.A.C, damos lo mejor de cada uno a quienes confían en nosotros, apuntando a desarrollar una sociedad estratégica a largo plazo con los clientes. <br/><br/>
                  Procuramos ser reconocidos por nuestra experiencia en el mercado de servicios, idoneidad empresarial, cumplimiento de los plazos, comprometidos con la seguridad, calidad y el medio ambiente y con un alto compromiso de responsabilidad social
                </p>
              </v-card-text>
            </v-card>
          </v-col>
          <v-col cols="12" md="6" class="d-flex align-center">
            <v-card height="100%" class="d-flex align-center" flat>
              <v-card-text>
                <p class="text-center text-h6 font-weight-black">
                  Escríbenos y un asesor se contactará contigo
                </p>
                <contact-form :dark="false" color="rgb(243, 118, 29)"></contact-form>
              </v-card-text>
            </v-card>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>
  </div>
  `,
  data: function() {
    return {
      loader:{
        scroll:0
      },
      content:{
        services:[],
      },
      modal: {
        size:{
          x:self.innerWidth,
          y:self.innerHeight
        },
      },
    }
  },
  props: ['actions'],
  methods: {
    handleScroll: function() {
      this.loader.scroll = window.scrollY
      this.modal.video = this.loader.scroll>0?false:true
    },
    handleSize: function() {
      this.modal.size.x = self.innerWidth
      this.modal.size.y = self.innerHeight
    },
    minDate: function() {
      return (new Date(Date.now() - (new Date()).getTimezoneOffset() * 60000)).toISOString().substr(0, 10)
    },
  },
  beforeMount(){
    axios.post("API/get/services").then((response) => {
      this.content.services = response.data
    })
  },
  created(){
    document.title = "Servicios"
    window.addEventListener('scroll', this.handleScroll);
    window.addEventListener("resize", this.handleSize);
  },
  destroyed () {
    window.removeEventListener('scroll', this.handleScroll);
    window.removeEventListener("resize", this.handleSize);
  }
})

Vue.component('page-proyectos', {
template: `
  <div>
    <v-divider dark class="my-6"></v-divider>
    <v-container fluid class="pa-0 mb-0 mt-16">
      <v-sheet height="30vh">
        <v-row class="fill-height" no-gutters>
          <v-col cols="12" md="12" class="d-flex justify-center align-center px-8">
            <div>
              <p class="text-h4 text-center">Proyectos</p>
              <p class="text-h3 text-center">Nuestro Trabajo habla por nosotros</p>
            </div>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>

    <v-container fluid class="pa-0">
      <v-sheet>
        <v-row class="pt-4 px-4 px-sm-4 px-md-16 px-lg-16 fill-height py-6">
          <v-col cols="12" md="12">
            <project-list></project-list>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>
  </div>
  `,
  data: function() {
    return {
      loader:{
        scroll:0
      },
      content:{
        services:[],
      },
      modal: {
        size:{
          x:self.innerWidth,
          y:self.innerHeight
        },
      },
    }
  },
  props: ['actions'],
  methods: {
    handleScroll: function() {
      this.loader.scroll = window.scrollY
      this.modal.video = this.loader.scroll>0?false:true
    },
    handleSize: function() {
      this.modal.size.x = self.innerWidth
      this.modal.size.y = self.innerHeight
    },
    minDate: function() {
      return (new Date(Date.now() - (new Date()).getTimezoneOffset() * 60000)).toISOString().substr(0, 10)
    },
  },
  beforeMount(){
  },
  created(){
    document.title = "Proyectos"
    window.addEventListener('scroll', this.handleScroll);
    window.addEventListener("resize", this.handleSize);
  },
  destroyed () {
    window.removeEventListener('scroll', this.handleScroll);
    window.removeEventListener("resize", this.handleSize);
  }
})

Vue.component('page-proyecto', {
template: `
  <div>
    <v-divider dark class="my-6"></v-divider>
    <v-container fluid class="pa-0 mb-4 mt-16">
      <v-sheet height="30vh">
        <v-row class="fill-height" no-gutters>
          <v-col cols="12" md="12" class="d-flex justify-center align-center px-8">
            <div>
              <p class="text-h5 text-center">Proyectos</p>
              <p class="text-h4 text-center">{{project.title}}</p>
            </div>
          </v-col>
          <v-col cols="12" md="12" class="d-flex align-center px-8">
            <v-hover v-slot="{ hover }">
              <v-btn color="#f3761d" rounded :outlined="hover?false:true" :class="hover?'font-weight-black white--text':'font-weight-black'" x-large @click="history.back()">
                <v-icon>mdi-chevron-left</v-icon> Volver
              </v-btn>
            </v-hover>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>

    <v-container fluid class="pa-0">
      <v-sheet color="rgb(28,28,28)">
        <v-row class="pt-4 fill-height py-6">
          <v-col cols="12" md="6" class="d-flex align-center px-6">
            <div>
              <p class="white--text" :style="{fontSize:$root.clampCss(1.6)}">{{project.title}}</p>

              <v-divider dark class="my-4"></v-divider>

              <dt :style="{fontSize:$root.clampCss(1),color:'rgb(243, 118, 29)'}">Descripcion</dt>
              <dd class="white--text" :style="{fontSize:$root.clampCss(.9)}" v-html="project.description"></dd>

              <v-divider dark class="my-4"></v-divider>

              <dt :style="{fontSize:$root.clampCss(1),color:'rgb(243, 118, 29)'}">Cliente</dt>
              <dd class="white--text" :style="{fontSize:$root.clampCss(.9)}">{{project.client}}</dd>

              <v-divider dark class="my-4"></v-divider>

              <dt :style="{fontSize:$root.clampCss(1),color:'rgb(243, 118, 29)'}">Especialidad</dt>
              <dd class="white--text" :style="{fontSize:$root.clampCss(.9)}">{{project.specialty}}</dd>

              <v-divider dark class="my-4"></v-divider>

              <dt :style="{fontSize:$root.clampCss(1),color:'rgb(243, 118, 29)'}">Lugar y Año</dt>
              <dd class="white--text" :style="{fontSize:$root.clampCss(.9)}">{{project.location}} - {{project.year}}</dd>
            </div>
          </v-col>
          <v-col cols="12" md="6">
            <v-carousel
              :continuous="true"
              show-arrows
              hide-delimiter-background
              delimiter-icon="mdi-minus"
              height="100%"
            >
              <v-carousel-item
                v-for="(slide, i) in project.gallery"
                :key="i"
              >
                <v-img
                  :src="slide"
                  height="100%"
                  tile
                >
                  <v-row
                    class="fill-height"
                    align="center"
                    justify="center"
                  >
                    <div class="text-h2">
                    </div>
                  </v-row>
                </v-img>
              </v-carousel-item>
            </v-carousel>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>
  </div>
  `,
  data: function() {
    return {
      loader:{
        scroll:0
      },
      project:null,
      modal: {
        size:{
          x:self.innerWidth,
          y:self.innerHeight
        },
      },
    }
  },
  props: ['actions'],
  methods: {
    handleScroll: function() {
      this.loader.scroll = window.scrollY
      this.modal.video = this.loader.scroll>0?false:true
    },
    handleSize: function() {
      this.modal.size.x = self.innerWidth
      this.modal.size.y = self.innerHeight
    },
    minDate: function() {
      return (new Date(Date.now() - (new Date()).getTimezoneOffset() * 60000)).toISOString().substr(0, 10)
    },
  },
  beforeMount(){
    axios.post("API/get/projects",{where:{id:this.$root.url.id}}).then((response) => {
      this.project = response.data[0]
    })
  },
  created(){
    document.title = "Proyectos"
    window.addEventListener('scroll', this.handleScroll);
    window.addEventListener("resize", this.handleSize);
  },
  destroyed () {
    window.removeEventListener('scroll', this.handleScroll);
    window.removeEventListener("resize", this.handleSize);
  }
})

Vue.component('page-blog', {
template: `
  <div>
    <v-divider dark class="my-6"></v-divider>
    <v-container fluid class="pa-0 mb-0 mt-16">
      <v-sheet height="35vh" color="rgb(127, 127, 127)">
        <v-row class="fill-height" no-gutters>
          <v-col cols="12" md="12" class="d-flex justify-start align-end px-8">
            <div>
              <p class="text-h4 white--text">Noticias</p>
              <p class="text-h3 white--text">Entérate de las novedades</p>
            </div>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>

    <v-container fluid class="pa-0">
      <v-sheet>
        <v-row class="pt-4 px-4 px-sm-4 px-md-16 px-lg-16 fill-height py-6">
          <v-col cols="12" md="9">
            <blog-list></blog-list>
          </v-col>
          <v-col cols="12" md="3">
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>
  </div>
  `,
  data: function() {
    return {
      loader:{
        scroll:0
      },
      content:{
        services:[],
      },
      modal: {
        size:{
          x:self.innerWidth,
          y:self.innerHeight
        },
      },
    }
  },
  props: ['actions'],
  methods: {
    handleScroll: function() {
      this.loader.scroll = window.scrollY
      this.modal.video = this.loader.scroll>0?false:true
    },
    handleSize: function() {
      this.modal.size.x = self.innerWidth
      this.modal.size.y = self.innerHeight
    },
    minDate: function() {
      return (new Date(Date.now() - (new Date()).getTimezoneOffset() * 60000)).toISOString().substr(0, 10)
    },
  },
  beforeMount(){
  },
  created(){
    document.title = "Blog"
    window.addEventListener('scroll', this.handleScroll);
    window.addEventListener("resize", this.handleSize);
  },
  destroyed () {
    window.removeEventListener('scroll', this.handleScroll);
    window.removeEventListener("resize", this.handleSize);
  }
})

Vue.component('page-publicacion', {
template: `
  <div>
    <v-divider dark class="my-6"></v-divider>
    <v-container fluid class="pa-0 mb-0 mt-16" v-if="blog">
      <v-sheet height="30vh" color="rgb(51, 51, 51)">
        <v-row class="fill-height" no-gutters>
          <v-col cols="12" md="12" class="d-flex justify-center align-center px-8">
            <div>
              <p class="text-h4 text-center white--text">{{blog.title}}</p>
              <p class="text-h5 text-center white--text">{{blog.created | date}}</p>
            </div>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>

    <v-container fluid class="pa-0" v-if="blog">
      <v-sheet>
        <v-row class="pt-4 fill-height py-6" no-gutters>
          <v-col cols="12" md="8">
            <v-card flat>
              <v-card-title>
                <v-list-item class="grow">
                  <v-list-item-avatar color="grey darken-3">
                    <v-img
                      class="elevation-6"
                      alt=""
                      src="https://avataaars.io/?avatarStyle=Transparent&topType=ShortHairShortCurly&accessoriesType=Prescription02&hairColor=Black&facialHairType=Blank&clotheType=Hoodie&clotheColor=White&eyeType=Default&eyebrowType=DefaultNatural&mouthType=Default&skinColor=Light"
                    ></v-img>
                  </v-list-item-avatar>

                  <v-list-item-content>
                    <v-list-item-title>{{blog.full_name}}</v-list-item-title>
                  </v-list-item-content>

                  <!--v-row align="center" justify="end" >
                    <v-icon class="mr-1">
                      mdi-heart
                    </v-icon>
                    <span class="subheading mr-2">256</span>
                    <span class="mr-1">·</span>
                    <v-icon class="mr-1">
                      mdi-eye-outline
                    </v-icon>
                    <span class="subheading">45</span>
                  </v-row-->
                </v-list-item>
              </v-card-title>
              <v-card-text>
                <p v-html="blog.content"></p>
              </v-card-text>
            </v-card>
          </v-col>
          <v-col cols="12" md="4">
            <v-card flat>
              <v-card-text>
                <p class="text-h4" style="color:rgb(243, 118, 29)">
                  Últimas noticias
                </p>
                <v-list three-line>
                  <v-list-item v-for="(item,i) in similars" :key="item.title" link @click="Data(item.id)">
                    <v-list-item-content>
                      <v-list-item-title v-html="item.title"></v-list-item-title>
                      <v-list-item-subtitle v-html="item.description"></v-list-item-subtitle>
                    </v-list-item-content>
                  </v-list-item>
                </v-list>
              </v-card-text>
            </v-card>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>
  </div>
  `,
  data: function() {
    return {
      loader:{
        scroll:0
      },
      blog:null,
      similars:[],
      modal: {
        size:{
          x:self.innerWidth,
          y:self.innerHeight
        },
      },
    }
  },
  props: ['actions'],
  methods: {
    Data:function(id=null) {
      if (id==null) {
        id = this.$root.url.id
      }

      let where = {
        where:{
          'news.id':id
        },
        select:'news.*, users.full_name',
        inner_join:{
          users:'news.author=users.id'
        }
      }
      let where_similar = {
        where:{
          'news.id <>':id
        },
        select:'news.*, users.full_name',
        inner_join:{
          users:'news.author=users.id'
        }
      }
      axios.post("API/get/news",where).then((response) => {
        this.blog = response.data[0]
      })
      axios.post("API/get/news",where_similar).then((response) => {
        this.similars = response.data
      })
    },
    handleScroll: function() {
      this.loader.scroll = window.scrollY
      this.modal.video = this.loader.scroll>0?false:true
    },
    handleSize: function() {
      this.modal.size.x = self.innerWidth
      this.modal.size.y = self.innerHeight
    },
    minDate: function() {
      return (new Date(Date.now() - (new Date()).getTimezoneOffset() * 60000)).toISOString().substr(0, 10)
    },
  },
  beforeMount(){
    this.Data()
  },
  created(){
    document.title = "Blog"
    window.addEventListener('scroll', this.handleScroll);
    window.addEventListener("resize", this.handleSize);
  },
  destroyed () {
    window.removeEventListener('scroll', this.handleScroll);
    window.removeEventListener("resize", this.handleSize);
  }
})

Vue.component('page-trabajo', {
template: `
  <div>
    <v-divider dark class="my-6"></v-divider>
    <v-container fluid class="pa-0 mt-16">
      <v-sheet height="100vh" color="rgb(248, 248, 248)">
        <v-row class="pt-4 px-4 px-sm-4 px-md-16 px-lg-16 fill-height py-6">
          <v-col cols="12" md="6">
            <v-card height="100%" class="d-flex align-end" tile img="public/content/bg.jpg">
              <v-card-text>
                <p class="text-center text-h4 font-weight-black">
                  Envianos tu información y nos comunicaremos contigo
                </p>
              </v-card-text>
            </v-card>
          </v-col>
          <v-col cols="12" md="6" class="d-flex align-center">
            <job-form></job-form>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>
  </div>
  `,
  data: function() {
    return {
      loader:{
        scroll:0
      },
      content:{
        services:[],
      },
      modal: {
        size:{
          x:self.innerWidth,
          y:self.innerHeight
        },
      },
    }
  },
  props: ['actions'],
  methods: {
    handleScroll: function() {
      this.loader.scroll = window.scrollY
      this.modal.video = this.loader.scroll>0?false:true
    },
    handleSize: function() {
      this.modal.size.x = self.innerWidth
      this.modal.size.y = self.innerHeight
    },
    minDate: function() {
      return (new Date(Date.now() - (new Date()).getTimezoneOffset() * 60000)).toISOString().substr(0, 10)
    },
  },
  beforeMount(){
  },
  created(){
    document.title = "Trabaja con Nosotros"
    window.addEventListener('scroll', this.handleScroll);
    window.addEventListener("resize", this.handleSize);
  },
  destroyed () {
    window.removeEventListener('scroll', this.handleScroll);
    window.removeEventListener("resize", this.handleSize);
  }
})

Vue.component('page-contacto', {
template: `
  <div>
    <v-divider dark class="my-6"></v-divider>
    <v-container fluid class="pa-0 mt-16">
      <v-sheet height="100vh" color="rgb(248, 248, 248)">
        <v-row class="pt-4 px-4 px-sm-4 px-md-16 px-lg-16 fill-height py-6">
          <v-col cols="12" md="6">
            <v-card height="100%" class="d-flex align-center" flat tile color="transparent" v-if="content.map">
              <l-map :center="content.map.content" :zoom="18" style="z-index:1">
                <l-tile-layer url="https://mt1.google.com/vt/lyrs=r&x={x}&y={y}&z={z}" layer-type="base" />
                  <l-marker :lat-lng="content.map.content">
                    <l-icon
                      :icon-size="[64,64]"
                      :icon-anchor="[32,64]"
                      icon-url="public/content/iconmap.png" >
                    </l-icon>
                  </l-marker>
              </l-map>
            </v-card>
          </v-col>
          <v-col cols="12" md="6" class="d-flex align-center">
            <v-card color="#d5dde8" height="100%" class="d-flex align-center" tile>
              <v-card-text>
                <p class="text-center text-h5 font-weight-black">
                  Escríbenos y un asesor se contactará contigo
                </p>
                <contact-form :dark="false" color="#f3761d"></contact-form>
              </v-card-text>
            </v-card>
          </v-col>
        </v-row>
      </v-sheet>
    </v-container>
  </div>
  `,
  data: function() {
    return {
      loader:{
        scroll:0
      },
      content:{
        map:null,
      },
      modal: {
        size:{
          x:self.innerWidth,
          y:self.innerHeight
        },
      },
    }
  },
  props: ['actions'],
  methods: {
    handleScroll: function() {
      this.loader.scroll = window.scrollY
      this.modal.video = this.loader.scroll>0?false:true
    },
    handleSize: function() {
      this.modal.size.x = self.innerWidth
      this.modal.size.y = self.innerHeight
    },
    minDate: function() {
      return (new Date(Date.now() - (new Date()).getTimezoneOffset() * 60000)).toISOString().substr(0, 10)
    },
  },
  beforeMount(){
    axios.post("API/get/web_content", {where:{code:'map1'}}).then((response) => {
      this.content.map = response.data[0]
    })
  },
  created(){
    document.title = "Contáctanos"
    window.addEventListener('scroll', this.handleScroll);
    window.addEventListener("resize", this.handleSize);
  },
  destroyed () {
    window.removeEventListener('scroll', this.handleScroll);
    window.removeEventListener("resize", this.handleSize);
  }
})