Vue.component('settings', {
    template: `
  <v-row align="center" class="fill-height">
    <v-item-group v-model="window" class="shrink mr-6" mandatory tag="v-flex">
      <v-item :key="'menu'" v-slot="{ active, toggle }">
        <div>
          <v-btn :color="active?'primary':''" :input-value="'menu'" icon @click="toggle">
            <v-icon>mdi-menu</v-icon>
          </v-btn>
        </div>
      </v-item>
      <v-item v-for="setting in items" :key="setting.key" v-slot="{ active, toggle }">
        <div>
          <v-btn :color="active?'primary':''" :input-value="setting.key" icon @click="toggle">
            <v-icon>{{setting.icon}}</v-icon>
          </v-btn>
        </div>
      </v-item>
    </v-item-group>
    <v-col>
      <v-window v-model="window" class="elevation-1" vertical>
        <v-window-item v-for="win in items" :key="win.key">
          <v-card flat>
            <v-card-text>
              <v-row class="mb-4" align="center">
                <v-avatar color="primary" class="mr-4"><v-icon>{{win.icon}}</v-icon></v-avatar>
                <strong class="text-h6">{{ win.name }}</strong>
                <v-spacer></v-spacer>
                <v-btn icon>
                  <v-icon>ri-settings-5-line</v-icon>
                </v-btn>
              </v-row>
              <component :is="win.key" @loading-screen="emitLoader" :key="win.key"></component>
            </v-card-text>
          </v-card>
        </v-window-item>
        <v-window-item key="0">
          <v-card flat>
            <v-card-text>
              <v-row class="mb-4" align="center">
                <v-avatar color="primary" class="mr-4"><v-icon>mdi-menu</v-icon></v-avatar>
                <strong class="text-h6">Menus</strong>
                <v-spacer></v-spacer>
                <v-btn icon>
                  <v-icon>ri-settings-5-line</v-icon>
                </v-btn>
              </v-row>
              <component :is="'set-menu'" @loading-screen="emitLoader" :key="'set-menu'"></component>
            </v-card-text>
          </v-card>
        </v-window-item>
      </v-window>
    </v-col>
  </v-row>
  `,
    data: () => {
        return {
            items: [],
            window: ''
        }
    },
    props: ['action', 'title'],
    methods: {
        Data: function() {
            axios.post('Settings/get')
                .then((response) => {
                    this.items = response.data
                })
        },
        editItem(item) {
            this.editedIndex = this.desserts.indexOf(item)
            this.editedItem = Object.assign({}, item)
            this.dialog = true
        },
        emitLoader(t) {
            if (t == false) {
                this.$emit('loading-screen', false)
            } else {
                this.$emit('loading-screen')
            }
        },
    },
    created: function() {
        this.Data();
    },
    mounted: function() {
        this.$emit('loading-screen', false)
    }
})
Vue.component('security', {
    template: `
  <v-form ref='form' v-on:submit.prevent='Save()'>
    <v-row>
      <v-col cols="12" md="3">
        <v-switch v-model="form.value" inset :label="'Seguridad '+(form.value?'Activada':'Desactivada')" color="success"></v-switch>
      </v-col>
    </v-row>
    <v-row>
      <v-col cols="12" md="12" class="d-flex justify-center">
        <v-icon :color="form.value?'success':'error'" size="50">{{form.value?'ri-lock-line':'ri-lock-unlock-line'}}</v-icon>
      </v-col>
    </v-row>
    <v-divider class="mb-3"></v-divider>
    <v-row v-if="form.value">
      <v-col cols="12" md="6">
        <v-select v-model="form.config.table" label="Tabla de Usuarios" @change="getFields(form.config.table)" :items="option.tables" item-text="name" item-value="name"></v-select>
      </v-col>
      <v-col cols="12" md="3">
        <v-select v-model="form.config.fields.id" label="ID" :items="option.fields" item-text="name" item-value="name"></v-select>
      </v-col>
      <v-col cols="12" md="3">
        <v-select v-model="form.config.fields.role" label="Rol" :items="option.fields" item-text="name" item-value="name"></v-select>
      </v-col>
      <v-col cols="12" md="3">
        <v-select v-model="form.config.fields.name" label="Nombre" :items="option.fields" item-text="name" item-value="name"></v-select>
      </v-col>
      <v-col cols="12" md="3">
        <v-select v-model="form.config.fields.user" label="Usuario" :items="option.fields" item-text="name" item-value="name"></v-select>
      </v-col>
      <v-col cols="12" md="3">
        <v-select v-model="form.config.fields.email" label="Correo" :items="option.fields" item-text="name" item-value="name"></v-select>
      </v-col>
      <v-col cols="12" md="3">
        <v-select v-model="form.config.fields.password" label="Clave" :items="option.fields" :items="option.fields" item-text="name" item-value="name"></v-select>
      </v-col>
      <v-col cols="12" md="12" class="d-flex justify-center">
        <v-btn v-model="form.config.allow_register" :color="form.config.allow_register?'green':'red'" :outlined="!form.config.allow_register" @click="form.config.allow_register=!form.config.allow_register">
          <v-icon>{{form.config.allow_register?'bi-check':'bi-x'}}</v-icon>Permitir Registro
        </v-btn>
      </v-col>
    </v-row>
    <v-fab-transition class="m-t-3">
      <v-btn
        type="submit"
        color="success"
        fab
      >
        <v-icon>bi bi-cloud-arrow-up</v-icon>
      </v-btn>
    </v-fab-transition>
  </v-form>
  `,
    data: () => {
        return {
            form: {
                value: false,
                config: {
                    table: '',
                    fields: {
                        id: '',
                        role: '',
                        name: '',
                        user: '',
                        email: '',
                        password: ''
                    },
                    allow_register: true
                }
            },
            option: {
                tables: [],
                fields: [],
            }
        }
    },
    methods: {
        Data: function() {
            axios.post('Settings/get/security')
                .then((response) => {
                    this.form = response.data
                    this.form.value = response.data.value == 'true' ? true : false
                })
        },
        Save: function() {
            axios.post('Settings/set/security', {
                    data: this.form
                })
                .then((response) => {
                    this.tables = response.data
                })
        },
        getFields: function(table) {
            axios.post('Database/get/' + table + '/t')
                .then((response) => {
                    this.option.fields = response.data.fields
                })
        }
    },
    created: function() {
        this.Data();
        axios.post('Database/get/null/f')
            .then((response) => {
                this.option.tables = response.data
                this.form.config.table = !this.form.config.table ? response.data[0].name : this.form.config.table
                this.getFields(this.form.config.table)
            })
    }
})
Vue.component('interface', {
    template: `
  <v-form ref='form' v-on:submit.prevent='Save()'>
    <v-subheader>MENU SUPERIOR</v-subheader>
    <v-row>
      <v-col cols="12" md="8">
        <v-text-field v-model="$root.settings.interface.config.nav.color" label="Color"></v-text-field>
      </v-col>
      <v-col cols="12" md="4">
        <v-switch :color="$root.settings.interface.config.nav.color" v-model="$root.settings.interface.config.nav.dark" :true-value="true" :false-value="false" label="Texto Claro"></v-switch>
      </v-col>
      <v-col cols="12" md="12">
        <!--v-simple-table>
          <template v-slot:default>
            <thead>
              <tr>
                <th class="text-left">
                  Propiedad
                </th>
                <th class="text-left">
                  Valor
                </th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <th class="text-left">
                  color
                </th>
                <td class="text-left">
                  red
                </td>
              </tr>
            </tbody>
          </template>
        </v-simple-table-->
      </v-col>
    </v-row>
    <v-subheader>MENU LATERAL</v-subheader>
    <v-row>
      <v-col cols="12" md="8">
        <v-text-field v-model="$root.settings.interface.config.sidebar.color" label="Color"></v-text-field>
      </v-col>
      <v-col cols="12" md="4">
        <v-switch :color="$root.settings.interface.config.sidebar.color" v-model="$root.settings.interface.config.sidebar.dark" :true-value="true" :false-value="false" label="Texto Claro"></v-switch>
      </v-col>
      <v-col cols="12" md="12">
        <!--v-simple-table>
          <template v-slot:default>
            <thead>
              <tr>
                <th class="text-left">
                  Propiedad
                </th>
                <th class="text-left">
                  Valor
                </th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <th class="text-left">
                  color
                </th>
                <td class="text-left">
                  red
                </td>
              </tr>
            </tbody>
          </template>
        </v-simple-table-->
      </v-col>
    </v-row>
    <v-subheader>INICIO DE SESION</v-subheader>
    <v-row>
      <v-col cols="12" md="8">
        <v-text-field v-model="$root.settings.interface.config.session.color" label="Color"></v-text-field>
      </v-col>
      <v-col cols="12" md="4">
        <v-switch :color="$root.settings.interface.config.session.color" v-model="$root.settings.interface.config.session.dark" :true-value="true" :false-value="false" label="Texto Claro"></v-switch>
      </v-col>
      <v-col cols="12" md="6">
        <v-text-field v-model="params.session.key" label="Parametro"></v-text-field>
      </v-col>
      <v-col cols="12" md="6">
        <v-text-field v-model="params.session.value" label="Valor" append-icon="bi-plus" @click:append="addParam('session')"></v-text-field>
      </v-col>
      <v-col cols="12" md="12">
        <v-simple-table dense>
          <template v-slot:default>
            <thead>
              <tr>
                <th class="text-left">
                  Propiedad
                </th>
                <th class="text-left">
                  Valor
                </th>
                <th width="10%" class="text-left"></th>
              </tr>
            </thead>
            <tbody>
              <tr v-for="key in Object.keys($root.settings.interface.config.session.style)">
                <th class="text-left">
                  {{key}}
                </th>
                <td class="text-left">
                  <v-text-field v-model="$root.settings.interface.config.session.style[key]" label="Parametro"></v-text-field>
                </td>
                <td class="text-left">
                  <v-btn fab color="red" x-small @click="delParam('session',key)">
                    <v-icon>bi-trash</v-icon>
                  </v-btn>
                </td>
              </tr>
            </tbody>
          </template>
        </v-simple-table>
      </v-col>
    </v-row>
    <v-subheader>LOGO</v-subheader>
    <v-row>
      <v-col cols="12" :md="6">
        <v-file-input @change="RenderFile('logo','file')" ref="ref_logo_file" label="Logo" accept="image/*"></v-file-input>
      </v-col>
      <v-col cols="12" :md="6">
        <v-file-input @change="RenderFile('logo','variant')" ref="ref_logo_variant" label="Variante" accept="image/*"></v-file-input>
      </v-col>
      <v-col cols="12" :md="6">
        <v-text-field v-model="$root.settings.interface.config.logo.width" label="Ancho"></v-text-field>
      </v-col>
      <v-col cols="12" :md="6">
        <v-text-field v-model="$root.settings.interface.config.logo.height" label="Alto"></v-text-field>
      </v-col>
      <v-col cols="12" md="12" v-if="$root.settings.interface.config.logo.file">
        <v-img :src="$root.settings.interface.config.logo.file" :width="$root.settings.interface.config.logo.width" :height="$root.settings.interface.config.logo.height" contain></v-img>
      </v-col>
      <v-col cols="12" md="12" v-if="$root.settings.interface.config.logo.variant">
        <v-img :src="$root.settings.interface.config.logo.variant" :width="$root.settings.interface.config.logo.width" :height="$root.settings.interface.config.logo.height" contain></v-img>
      </v-col>
    </v-row>
    <v-row>
      <v-col cols="12" md="12" class="d-flex justify-center">
        <v-btn v-model="$root.settings.interface.value" :color="$root.settings.interface.value?'green':'red'" :outlined="!$root.settings.interface.value" @click="$root.settings.interface.value=!$root.settings.interface.value,$root.DarkMode($root.settings.interface.value)">
          <v-icon>{{$root.settings.interface.value?'bi-check':'bi-x'}}</v-icon>Modo Oscuro
        </v-btn>
      </v-col>
    </v-row>
    <v-fab-transition class="m-t-3">
      <v-btn
        type="submit"
        color="success"
        fab
      >
        <v-icon>bi bi-cloud-arrow-up</v-icon>
      </v-btn>
    </v-fab-transition>
  </v-form>
  `,
    data: () => {
        return {
            params: {
                nav: {
                    key: '',
                    value: ''
                },
                sidebar: {
                    key: '',
                    value: ''
                },
                logo: {
                    file: '',
                    variant: '',
                    width: null,
                    height: null
                },
                session: {
                    key: '',
                    value: ''
                }
            }
        }
    },
    methods: {
        Save: function() {
            this.$emit('loading-screen')
            axios.post('Settings/set/interface', {
                data: this.$root.settings.interface
            }).then((response) => {
                this.$emit('loading-screen', false)
            })
        },
        addParam: function(b) {
            this.$set(this.$root.settings.interface.config[b].style, this.params[b].key, this.params[b].value)
        },
        delParam: function(b, p) {
            this.$delete(this.$root.settings.interface.config[b].style, p)
        },
        RenderFile(f,t) {
            var from = 'ref_'+f+'_'+t
            if (this.$refs[from].lazyValue !== null) {
                const file = this.$refs[from].lazyValue
                const reader = new FileReader()
                reader.onload = (e) => {
                    this.$root.settings.interface.config[f][t] = e.target.result
                }
                reader.readAsDataURL(file)
            } else {
                this.$root.settings.interface.config[f][t] = null
            }
        }
    }
})
Vue.component('contact', {
    template: `
  <v-form ref='form' v-on:submit.prevent='Save()'>
    <v-row>
      <v-col cols="12" md="3">
        <v-switch v-model="form.value" inset :label="'Mensajeria '+(form.value?'Activada':'Desactivada')" color="success"></v-switch>
      </v-col>
    </v-row>
    <v-row v-if="form.value">
      <v-col cols="12" md="12">
        <v-chip color="success" v-for="(item,i) in form.config" close @click:close="$delete(form.config,i)">
          {{item}}

        </v-chip>
      </v-col>
      <v-col cols="12" md="12">
        <v-text-field type="email" v-model="email" inset label="Correo" append-icon="mdi-plus" @click:append="Add()"></v-text-field>
      </v-col>
    </v-row>
    <v-row>
      <v-col cols="12" md="12" class="d-flex justify-center">
        <v-icon :color="form.value?'success':'error'" size="50">{{form.value?'mdi-email-check-outline':'mdi-email-outline'}}</v-icon>
      </v-col>
    </v-row>
    <v-divider class="mb-3"></v-divider>
    <v-fab-transition class="m-t-3">
      <v-btn
        type="submit"
        color="success"
        fab
      >
        <v-icon>bi bi-cloud-arrow-up</v-icon>
      </v-btn>
    </v-fab-transition>
  </v-form>
  `,
  data: () => {
    return {
      form: {
        value: false,
        config: [],
      },
      email:''
    }
  },
  methods: {
    Data: function() {
      axios.post('Settings/get/contact')
      .then((response) => {
        this.form = response.data
        console.log(this.form)
      })
    },
    Save: function() {
      axios.post('Settings/set/contact', {
        data: this.form
      })
      .then((response) => {
        this.tables = response.data
      })
    },
    Add: function() {
      this.form.config.push(this.email)
      this.email = ''
    }
  },
  created: function() {
    this.Data();
  }
})
Vue.component('main-screen', {
    template: `
  <v-form ref='form' v-on:submit.prevent='Save()'>
    <v-row>
      <v-col cols="12" md="12">
        <v-sheet fluid>
          <v-row dense>
            <v-col cols="12" md="12">
              <v-card flat outlined class="mb-3">
                <v-card-title class="d-flex justify-space-between">
                  <v-btn rounded small color="primary" @click="form.config.push({...{id:$root.GenerateID('alnum',8),props:{md:'12'},content:[]}})">
                    <v-icon>ri-insert-row-bottom</v-icon> {{$t('action.add')}} {{$t('section.section')}}
                  </v-btn>
                </v-card-title>
                <v-card-text>
                  <draggable :list="form.config" group="components" handle=".move-component">
                    <v-col v-for="(col,c) in form.config" :key="col.id" cols="12" :md="col.props.md">
                      <v-card flat outlined>
                        <v-card-title class="d-flex justify-space-between">
                          <v-btn fab x-small color="primary" @click="selectActive('node',[c])">
                            <v-icon>bi-node-plus</v-icon>
                          </v-btn>
                          <v-btn x-small color="teal" icon class="move-component">
                            <v-icon>ri-drag-drop-line</v-icon>
                          </v-btn>
                          <v-menu offset-y>
                            <template v-slot:activator="{ on, attrs }">
                              <v-btn color="primary" v-bind="attrs" v-on="on" fab x-small>
                                <v-icon>ri-list-settings-line</v-icon>
                              </v-btn>
                            </template>
                            <v-list dense>
                              <v-list-item link @click="selectActive('col',[c])">
                                <v-list-item-icon><v-icon>bi-sliders</v-icon></v-list-item-icon>
                                <v-list-item-title>{{$t('action.setting')}}</v-list-item-title>
                              </v-list-item>
                              <v-divider></v-divider>
                              <v-list-item link @click="$delete(form.config,c)">
                                <v-list-item-icon><v-icon color="red">bi-trash</v-icon></v-list-item-icon>
                                <v-list-item-title>{{$t('action.delete')}}</v-list-item-title>
                              </v-list-item>
                            </v-list>
                          </v-menu>
                        </v-card-title>
                        <v-card-text>
                          <draggable :list="form.config[c].content" group="items" handle=".move-item" class="row">
                            <v-col v-for="(item,i) in col.content" :key="item.id" cols="12" md="12">
                              <v-card flat outlined>
                                <v-card-title>{{item.name}}</v-card-title>
                                <v-card-subtitle>Componente: {{item.id}}</v-card-subtitle>
                                <v-card-actions class="d-flex justify-space-between">
                                  <v-btn icon x-small color="error" @click="$delete(form.config[c].content,i)">
                                    <v-icon>ri-delete-column</v-icon>
                                  </v-btn>
                                  <v-btn icon x-small color="cyan" class="move-item">
                                    <v-icon>ri-drag-drop-line</v-icon>
                                  </v-btn>
                                </v-card-actions>
                              </v-card>
                            </v-col>
                          </draggable>
                        </v-card-text>
                        <v-card-actions class="d-flex justify-space-between">
                        </v-card-actions>
                      </v-card>
                    </v-col>
                  </draggable>
                </v-card-text>
              </v-card>
            </v-col>
          </v-row>
        </v-sheet>
      </v-col>
      <v-dialog v-model="toggle.set_col" persistent width="30%">
        <v-card v-if="active.length>0 && toggle.set_col">
          <v-card-title>{{$t('action.setting')}}</v-card-title>
          <v-card-text>
            <v-select dense v-model="form.config[active[0]].props.md" label="Ancho" :items="['auto',2,3,4,5,6,7,8,9,10,11,12]"></v-select>
          </v-card-text>
          <v-card-actions>
            <v-btn rounded color="red ligthen-2" @click="deselectActive('col')" block>
              <v-icon>bi-x</v-icon> {{$t('action.close')}}
            </v-btn>
          </v-card-actions>
        </v-card>
      </v-dialog>
      <!--v-dialog v-model="toggle.set_component" persistent width="50%">
        <v-card v-if="active.length>0 && toggle.set_component">
          <v-card-title>{{$t('action.setting')}} {{form.content[active[0]].content[active[1]].content[active[2]].name}}</v-card-title>
          <v-card-text>
            <div v-if="form.content[active[0]].content[active[1]].content[active[2]].template=='create'">
              <div v-if="form.content[active[0]].content[active[1]].content[active[2]].props.after_send.path==null">
                <v-row>
                  <v-col cols="12" md="12" v-if="form.active!==null">
                    <v-select v-model="form.content[active[0]].content[active[1]].content[active[2]].props.after_send.key" :items="form.content" item-text="name" item-value="id" label="Activar Pantalla"></v-select>
                  </v-col>
                </v-row>
              </div>
            </div>
            <div v-if="form.content[active[0]].content[active[1]].content[active[2]].template=='read'">
              <div v-if="form.active!==null">
                <v-select v-model="form.content[active[0]].content[active[1]].content[active[2]].props.view" clearable clear-icon="ri-close-circle-line" :items="form.content" label="Ver" item-text="name" item-value="id"></v-select>
                <v-select v-model="form.content[active[0]].content[active[1]].content[active[2]].props.update" clearable clear-icon="ri-close-circle-line" :items="form.content" label="Editar" item-text="name" item-value="id"></v-select>
              </div>
              <div v-else>
                <v-select v-model="form.content[active[0]].content[active[1]].content[active[2]].props.view" clearable clear-icon="ri-close-circle-line" :items="modules" label="Ver" item-text="title" item-value="slug"></v-select>
                <v-select v-model="form.content[active[0]].content[active[1]].content[active[2]].props.update" clearable clear-icon="ri-close-circle-line" :items="modules" label="Editar" item-text="title" item-value="slug"></v-select>
              </div>
              <v-btn :color="form.content[active[0]].content[active[1]].content[active[2]].props.remove?'error':'primary'" :outlined="form.content[active[0]].content[active[1]].content[active[2]].props.remove" @click="form.content[active[0]].content[active[1]].content[active[2]].props.remove=!form.content[active[0]].content[active[1]].content[active[2]].props.remove">
                <v-icon>{{form.content[active[0]].content[active[1]].content[active[2]].props.remove?'ri-delete-bin-7-line':'ri-delete-bin-2-line'}}</v-icon>
                {{form.content[active[0]].content[active[1]].content[active[2]].props.remove?'Eliminar Activado':'Eliminar Desactivado'}}
              </v-btn>
              <div v-if="form.content[active[0]].content[active[1]].content[active[2]].type == 'maps'">
                <v-row>
                  <v-col cols="12" md="4">
                    <v-text-field v-model="form.content[active[0]].content[active[1]].content[active[2]].props.maps.center.lat" number label="Centro Lat"></v-text-field>
                  </v-col>
                  <v-col cols="12" md="4">
                    <v-text-field v-model="form.content[active[0]].content[active[1]].content[active[2]].props.maps.center.lng" number label="Centro Lng"></v-text-field>
                  </v-col>
                  <v-col cols="12" md="4">
                    <v-text-field v-model="form.content[active[0]].content[active[1]].content[active[2]].props.maps.zoom" number label="Zoom" min="1"></v-text-field>
                  </v-col>
                  <v-col cols="12" md="auto" v-if="item.props.maps.geojson.length>0" v-for="(geo,z) in item.props.maps.geojson">
                    <v-card close close-icon="mdi-delete" @click:close="$delete(item.props.maps.geojson,z)">
                      <v-card-title>
                        {{geo.path}}
                        <v-spacer></v-spacer>
                        <v-btn icon @click="$delete(z,geo)">
                          <v-icon>ri-delete-bin-7-line</v-icon>
                        </v-btn>
                      </v-card-title>
                      <v-card-subtitle>ID Pantalla: {{geo.id}}</v-card-subtitle>
                      <v-card-text>
                        <span>Tooltip: {{(geo.tooltip?'Si':'No')}}</span>
                        <span>Campo ID: {{(geo.id?geo.id:'No Definido')}}</span>
                        <span>Color: {{(geo.color?geo.color:'No Definido')}}</span>
                      </v-card-text>
                    </v-card>
                  </v-col>
                  <v-col cols="12" md="4">
                    <v-text-field ref="set_geojson" name="path" label="Link"></v-text-field>
                  </v-col>
                  <v-col cols="12" md="4">
                    <v-text-field ref="set_geojson" name="id" label="ID"></v-text-field>
                  </v-col>
                  <v-col cols="12" md="4">
                    <v-checkbox ref="set_geojson" name="tooltip" :true-value="true" :false-value="false" label="Tooltip"></v-checkbox>
                  </v-col>
                  <v-col cols="12" md="4">
                    <v-text-field ref="set_geojson" name="color" label="Color"></v-text-field>
                  </v-col>
                  <v-col cols="12" md="4">
                    <v-select ref="set_geojson" name="screen" :items="form.content" item-value="id" item-text="name" label="Activar Pantalla"></v-select>
                  </v-col>
                  <v-col cols="12" md="4">
                    <v-btn @click="addGeoJSON($refs.set_geojson,active[0],active[1],active[2])">
                      <v-icon>ri-add-fill</v-icon> GeoJSON
                    </v-btn>
                  </v-col>
                </v-row>
              </div>
            </div>
            <div v-if="form.content[active[0]].content[active[1]].content[active[2]].template=='update'">
              <div v-if="form.content[active[0]].content[active[1]].content[active[2]].props.after_send.path==null">
                <v-row>
                  <v-col cols="12" md="12" v-if="form.active!==null">
                    <v-select v-model="form.content[active[0]].content[active[1]].content[active[2]].props.after_send.key" :items="form.content" item-text="name" item-value="id" label="Activar Pantalla"></v-select>
                  </v-col>
                </v-row>
              </div>
            </div>
          </v-card-text>
          <v-card-actions>
            <v-btn rounded color="red ligthen-2" @click="deselectActive('component')" block>
              <v-icon>bi-x</v-icon> {{$t('action.close')}}
            </v-btn>
          </v-card-actions>
        </v-card>
      </v-dialog-->
      <v-dialog v-model="toggle.set_node" persistent width="50%">
        <v-card v-if="active.length>0 && toggle.set_node">
          <v-card-title>{{$t('action.add')}} {{$t('section.component')}}</v-card-title>
          <v-card-text>
          <v-list dense>
            <v-list-item-group>
              <v-list-item v-for="(component,c) in components" :key="component.codename+'-'+component.keyname" @click="cloneNode(component)">
                <v-list-item-icon v-if="component.template=='create'"><v-icon>ri-add-line</v-icon></v-list-item-icon>
                <v-list-item-icon v-else-if="component.template=='read'"><v-icon>ri-list-check-2</v-icon></v-list-item-icon>
                <v-list-item-icon v-else-if="component.template=='update'"><v-icon>ri-edit-line</v-icon></v-list-item-icon>
                <v-list-item-icon v-else-if="component.template=='delete'"><v-icon>ri-delete-bin-2-line</v-icon></v-list-item-icon>
                <v-list-item-icon v-else-if="component.template=='view'"><v-icon>ri-eye-line</v-icon></v-list-item-icon>
                <v-list-item-icon v-else-if="component.template=='chart'"><v-icon>{{'ri-'+component.type+'-chart-line'}}</v-icon></v-list-item-icon>
                <v-list-item-icon v-else><v-icon>bi-node-plus</v-icon></v-list-item-icon>
                <v-list-item-content>{{component.name}}</v-list-item-content>
              </v-list-item>
            </v-list-item-group>
          </v-list>
          </v-card-text>
          <v-card-actions>
            <v-btn rounded color="red ligthen-2" @click="deselectActive('node')" block>
              <v-icon>bi-x</v-icon> {{$t('action.close')}}
            </v-btn>
          </v-card-actions>
        </v-card>
      </v-dialog>
    </v-row>
    <v-fab-transition class="m-t-3">
      <v-btn
        type="submit"
        color="success"
        fab
      >
        <v-icon>bi bi-cloud-arrow-up</v-icon>
      </v-btn>
    </v-fab-transition>
  </v-form>
  `,
    data: () => {
        return {
            form: {
                value: false,
                config: []
            },
            toggle: {
                tab: '',
                set_col: false,
                set_component: false,
                set_node: false
            },
            active: [],
            components: []
        }
    },
    methods: {
        Data: function() {
            axios.post('Settings/get/main-screen')
                .then((response) => {
                    this.form = response.data
                })
        },
        Save: function() {
            this.$emit('loading-screen')
            axios.post('Settings/set/main-screen', {
                    data: this.form
                })
                .then((response) => {
                    this.$emit('loading-screen', false)
                })
        },
        getPost: function() {
            axios.post('Post/get')
                .then((response) => {
                    this.posts = response.data
                })
        },
        selectActive(s = 'btn', a = []) {
            this.toggle['set_' + s] = true
            this.active = a
        },
        deselectActive(s = 'btn') {
            this.toggle['set_' + s] = false
            this.active = []
        },
        cloneNode(node) {
            node.id = this.$root.GenerateID('alnum', 8)
            this.form.config[this.active[0]].content.push({...node
            })
        },
    },
    created: function() {
        this.Data();
        axios.post('Component/get')
            .then((response) => {
                this.components = response.data
            })
    }
})
Vue.component('set-menu', {
    template: `
  <v-form ref='form' v-on:submit.prevent='Save()'>
    <v-row>
      <v-col cols="12" md="4">
        <v-list dense>
          <v-list-item v-for="menu in menus" link @click="form = menu">
            <v-list-item-icon>
              <v-icon>
                {{menu.type=='left'?'mdi-arrow-collapse-left':'mdi-arrow-collapse-up'}}
              </v-icon>
            </v-list-item-icon>
            <v-list-item-content>
              {{menu.role}} / {{menu.type}} / {{menu.source}}
            </v-list-item-content>
          </v-list-item>
        </v-list>
      </v-col>
      <v-col cols="12" md="4">
        <v-row v-if="form">
          <v-col cols="12" md="12">
            <v-card v-for="(menu,m) in form.modules" class="mb-2">
              <v-card-text>
                <v-row>
                  <v-col cols="12" md="12" class="d-flex justify-space-between">
                    <span><v-icon>{{menu.icon}}</v-icon> {{menu.title}}</span>
                    <v-spacer></v-spacer>
                    <v-btn color="primary" fab x-small @click="selected.parent==m?selected.parent=null:selected.parent=m">
                      <v-icon>mdi-square-edit-outline</v-icon>
                    </v-btn>
                    <v-btn color="error" fab x-small @click="$delete(form.modules,m)">
                      <v-icon>mdi-delete-outline</v-icon>
                    </v-btn>
                  </v-col>
                </v-row>
              </v-card-text>
              <v-card-text v-if="selected.parent==m">
                <v-row>
                  <v-col cols="12" md="12">
                    <v-text-field label="title" v-model="menu.title" outlined dense></v-text-field>
                  </v-col>
                  <v-col cols="12" md="12">
                    <v-text-field label="icon" v-model="menu.icon" outlined dense></v-text-field>
                  </v-col>
                  <v-col cols="12" md="12">
                    <v-text-field label="active" v-model="menu.active" outlined dense></v-text-field>
                  </v-col>
                </v-row>
                <v-row v-if="menu.items.length>0">
                  <v-col cols="12" md="12">
                    <v-card v-for="(child,c) in menu.items"  @click="selected.child==c?selected.child=null:selected.child=c">
                      <v-card-text>
                        <v-row>
                          <v-col cols="12" md="12" class="d-flex justify-space-between">
                            <span><v-icon>{{child.icon}}</v-icon> {{child.title}}</span>
                            <v-spacer></v-spacer>
                            <v-btn color="error" fab x-small @click="$delete(menu.items,c)">
                              <v-icon>mdi-delete-outline</v-icon>
                            </v-btn>
                          </v-col>
                        </v-row>
                      </v-card-text>
                    </v-card>
                  </v-col>
                </v-row>
              </v-card-text>
            </v-card>
          </v-col>
        </v-row>
      </v-col>
      <v-col cols="12" md="4">
        <v-row>
          <v-col cols="12" md="6">
            <v-btn color="primary" small @click="form.modules.push({... element })" block>Agregar Elemento</v-btn>
          </v-col>
          <v-col cols="12" md="12">
            <v-list dense v-if="form.type == 'nav'">
              <v-list-item v-for="(item,i) in pages" @click="cloneNode(item,form.type)" link>
                <v-list-item-icon><v-icon>{{item.data.icon}}</v-icon></v-list-item-icon>
                <v-list-item-content>{{item.data.title}}</v-list-item-content>
              </v-list-item>
            </v-list>
            <v-list dense v-else>
              <v-list-item v-for="(item,i) in modules" @click="cloneNode(item,form.type)" link>
                <v-list-item-icon><v-icon>{{item.cover}}</v-icon></v-list-item-icon>
                <v-list-item-content>{{item.title}}</v-list-item-content>
              </v-list-item>
            </v-list>
          </v-col>
        </v-row>
      </v-col>
    </v-row>
    <v-row>
      <v-col cols="12" md="12" class="d-flex justify-center">
        <v-icon :color="form.value?'success':'error'" size="50">{{form.value?'mdi-email-check-outline':'mdi-email-outline'}}</v-icon>
      </v-col>
    </v-row>
    <v-divider class="mb-3"></v-divider>
    <v-fab-transition class="m-t-3">
      <v-btn
        type="submit"
        color="success"
        fab
      >
        <v-icon>bi bi-cloud-arrow-up</v-icon>
      </v-btn>
    </v-fab-transition>
  </v-form>
  `,
  data: () => {
    return {
      menus: [],
      modules: [],
      pages: [],
      selected: {
        parent:null,
        child:null
      },
      element: {
        icon: "mdi-menu",
        slug: "",
        active: "",
        items: [],
        title: "Menu Element"
      },
      form: ""
    }
  },
  methods: {
    Data: function() {
      axios.post('Menu/get_list')
      .then((response) => {
        console.log(response.data)
        this.menus = response.data.menu
        this.pages = response.data.modules
      })
      axios.post('Post/get')
      .then((response) => {
        this.modules = response.data
      })
    },
    Save: function() {
      axios.post('Menu/set/'+this.form.ID, {
        data: this.form
      })
      .then((response) => {
        this.Data()
      })
    },
    cloneNode: function(el,type) {
      var element
      if (type == 'nav') {
        element = {
          icon: el.data.icon,
          slug: el.controller,
          active: '',
          items: [],
          title: el.data.title
        }
      } else {
        element = {
          icon: el.cover,
          slug: el.slug,
          active: el.active,
          items: [],
          title: el.title
        }
      }
      if (this.selected.parent!==null) {
        this.form.modules[this.selected.parent].items.push({... element })
      } else {
        this.form.modules.push({... element })
      }
      axios.post('Settings/set/contact', {
        data: this.form
      })
      .then((response) => {
        this.tables = response.data
      })
    }
  },
  created: function() {
    this.Data();
  }
})