Vue.component('message-button',{
  template: `
  <v-menu :close-on-content-click="true" offset-x>
    <template v-slot:activator="{ on, attrs }">
      <v-badge dot color="success" offset-x="15" offset-y="15" bordered :value="unread">
        <v-btn icon v-bind="attrs" v-on="on" depressed>
          <v-icon>bi-chat-left</v-icon>
        </v-btn>
      </v-badge>
    </template>

    <v-card>
      <v-virtual-scroll :items="messages" height="300" width="300" :item-height="300/4">
        <template v-slot:default="{ item }">
          <v-list-item link @click="$root.Url('message-open',item.ID)">
            <v-list-item-avatar>
              <v-img src="https://cdn.vuetifyjs.com/images/lists/1.jpg"></v-img>
            </v-list-item-avatar>

            <v-list-item-content>
              <v-list-item-title>{{item.subject}}</v-list-item-title>
              <v-list-item-subtitle>{{item.content}}</v-list-item-subtitle>
            </v-list-item-content>
          </v-list-item>
        </template>
      </v-virtual-scroll>
      <v-card-actions>
        <v-btn text plain block small @click="$root.Url('message-inbox')">
          <v-icon>bi-inboxes</v-icon> Buzón de Mensajes
        </v-btn>
      </v-card-actions>
    </v-card>
  </v-menu>
  `,
  data:()=>{
    return {
      unread:false,
      sess:'',
      messages:[]
    }
  },
  props:['current_setting','current_session'],
  methods:{
    Unread:function() {
      console.log(this.sess)

    },
  },
  created:function(){
    axios.post('Session').then((response) => {
      this.sess = response.data

      var params = {}
      var tab = {
        "sm.type":'chat',
        read:0,
        receiver:this.sess[this.current_setting.id]
      }
      var left_join = {}

      Vue.set(tab,'receiver',1)
      Vue.set(left_join,'users',"users.id_user=sm.receiver")


      Vue.set(left_join,'products',"products.id_product=sm.reference")

      Vue.set(params,'where',tab)
      Vue.set(params,'left_join',left_join)
      axios.post('Message/get',params)
      .then((response)=>{
        this.messages = response.data
        if(this.messages.length>0){
          this.unread = true
        }
      })
    })
  }
})
Vue.component('message-menu',{
  template: `
  <div>
    <v-btn v-for="item in items" @click="$root.Url(item.hash)" block 
      :text="item.hash=='message-'+tab?false:true" 
      :style="item.hash=='message-'+tab?{fontWeight:900}:null"
      color="success"
    >
      <v-icon>{{item.icon}}</v-icon>&nbsp;&nbsp;&nbsp;{{item.name}}
    </v-btn>
  </div>
  `,
  data:()=>{
    return {
      items:[
        /*{
          icon:'bi-pencil-square',
          name:'Redactar',
          hash:'message-write',
        },*/
        {
          icon:'bi-box-arrow-in-down',
          name:'Recibidos',
          hash:'message-inbox',
        },
        {
          icon:'bi-box-arrow-in-up',
          name:'Enviados',
          hash:'message-outbox',
        },
      ]
    }
  },
  props:['tab'],
  methods:{
  },
  created:function(){
  }
})
Vue.component('message-lead',{
  template: `
  <v-list nav>
    <v-list-item link v-for="message in messages" @click="$root.Url('message-open',tab+'_'+message.ID)">
      <v-list-item-content color="#385F73" dark>
        <v-list-item-title class="text-h5">
          {{message.first_name}} {{message.last_name}}
          <v-chip outlined small color="success">{{message.name}}</v-chip> 
          <v-chip v-if="message.read==0 && tab=='inbox'" small color="error">Nuevo</v-chip>
        </v-list-item-title>

        <v-list-item-subtitle style="font-weight:900">
          {{message.subject}}
        </v-list-item-subtitle>

        <v-list-item-subtitle>
          {{message.content | truncate(200)}}
        </v-list-item-subtitle>
      </v-list-item-content>

      <v-list-item-action>
        <v-list-item-action-text>
          {{message.message_date | date}}
        </v-list-item-action-text>
  
      </v-list-item-action>
    </v-list-item>
  </v-list>
  `,
  data:()=>{
    return {
      messages:[]
    }
  },
  props:['tab'],
  methods:{
  },
  created:function(){
    var params = {}
    var tab = {
      "sm.type":'chat'
    }
    var left_join = {}
    if(this.tab == "inbox"){
      Vue.set(tab,'receiver',1)
      Vue.set(left_join,'users',"users.id_user=sm.receiver")
    }
    if(this.tab == "outbox"){
      Vue.set(tab,'sender',1)
      Vue.set(left_join,'users',"users.id_user=sm.receiver")
    }

    Vue.set(left_join,'products',"products.id_product=sm.reference")

    Vue.set(params,'where',tab)
    Vue.set(params,'left_join',left_join)

    axios.post('Message/get',params)
    .then((response)=>{
      this.messages = response.data
      this.$emit('loading-screen',false)
    })
  }
})
Vue.component('message-inbox',{
  template: `
  <v-sheet fluid>
    <v-toolbar flat>
      <v-toolbar-title>Buzón de mensajes</v-toolbar-title>
    </v-toolbar>
    <v-row>
      <v-col cols="12" md="3">
        <message-menu tab="inbox"></message-menu>
      </v-col>
      <v-col cols="12" md="9">
        <v-divider style="margin-top:10px;margin-bottom:10px"></v-divider>
        <message-lead tab="inbox"></message-lead>
      </v-col>
    </v-row>
  </v-sheet>
  `,
  data:()=>{
    return {
    }
  },
  props:['title','message'],
  methods:{
    Message:function(owner=null) {
      var params = {}
      var tab = {
        "sm.type":'chat',
      }
      var left_join = {}
      if(this.tab == "inbox"){
        Vue.set(tab,'sender',owner)
        Vue.set(left_join,'users',"users.id_user=sm.receiver")
      }
      if(this.tab == "outbox"){
        Vue.set(tab,'receiver',owner)
        Vue.set(left_join,'users',"users.id_user=sm.sender")
      }

      Vue.set(params,'where',tab)
      Vue.set(params,'left_join',left_join)

      this.client = owner

      axios.post('Message/get',params)
      .then((response)=>{
        this.messages = response.data
      })
    },
    Tab:function() {
      this.$emit('loading-screen')
      var params = {}
      var tab = {
        "sm.type":'chat'
      }
      var left_join = {}
      if(this.tab == "inbox"){
        Vue.set(tab,'receiver',1)
        Vue.set(left_join,'users',"users.id_user=sm.receiver")
        Vue.set(params,'group_by',['sender'])
      }
      if(this.tab == "outbox"){
        Vue.set(tab,'sender',1)
        Vue.set(left_join,'users',"users.id_user=sm.sender")
        Vue.set(params,'group_by',['receiver'])
      }

      Vue.set(params,'where',tab)
      Vue.set(params,'left_join',left_join)

      axios.post('Message/get',params)
      .then((response)=>{
        this.clients = response.data
        this.$emit('loading-screen',false)
      })
    },
  },
  created:function(){
    this.$emit('loading-screen',false)
  }
})

Vue.component('message-outbox',{
  template: `
  <v-sheet fluid>
    <v-toolbar flat>
      <v-toolbar-title>Buzón de mensajes</v-toolbar-title>
    </v-toolbar>
    <v-row>
      <v-col cols="12" md="3">
        <message-menu tab="outbox"></message-menu>
      </v-col>
      <v-col cols="12" md="9">
        <v-divider style="margin-top:10px;margin-bottom:10px"></v-divider>
        <message-lead tab="outbox"></message-lead>
      </v-col>
    </v-row>
  </v-sheet>
  `,
  data:()=>{
    return {
    }
  },
  props:['title','message'],
  methods:{
    Message:function(owner=null) {
      var params = {}
      var tab = {
        "sm.type":'chat',
      }
      var left_join = {}
      if(this.tab == "inbox"){
        Vue.set(tab,'sender',owner)
        Vue.set(left_join,'users',"users.id_user=sm.receiver")
      }
      if(this.tab == "outbox"){
        Vue.set(tab,'receiver',owner)
        Vue.set(left_join,'users',"users.id_user=sm.sender")
      }

      Vue.set(params,'where',tab)
      Vue.set(params,'left_join',left_join)

      this.client = owner

      axios.post('Message/get',params)
      .then((response)=>{
        this.messages = response.data
      })
    },
    Tab:function() {
      this.$emit('loading-screen')
      var params = {}
      var tab = {
        "sm.type":'chat'
      }
      var left_join = {}
      if(this.tab == "inbox"){
        Vue.set(tab,'receiver',1)
        Vue.set(left_join,'users',"users.id_user=sm.receiver")
        Vue.set(params,'group_by',['sender'])
      }
      if(this.tab == "outbox"){
        Vue.set(tab,'sender',1)
        Vue.set(left_join,'users',"users.id_user=sm.sender")
        Vue.set(params,'group_by',['receiver'])
      }

      Vue.set(params,'where',tab)
      Vue.set(params,'left_join',left_join)

      axios.post('Message/get',params)
      .then((response)=>{
        this.clients = response.data
        this.$emit('loading-screen',false)
      })
    },
  },
  created:function(){
    this.$emit('loading-screen',false)
  }
})

Vue.component('message-open',{
  template: `
  <v-sheet fluid>
    <v-toolbar flat>
      <v-toolbar-title>Buzón de mensajes</v-toolbar-title>
    </v-toolbar>
    <v-row>
      <v-col cols="12" md="3">
        <message-menu tab="open"></message-menu>
      </v-col>
      <v-col cols="12" md="9" >
        <v-divider style="margin-top:10px;margin-bottom:10px"></v-divider>
        <v-row>
          <v-col cols="12" md="6">
            <dt style="font-weight:900,margin-bottom:25px">Producto</dt>
            <dd>
              {{message.name}}
              <v-divider></v-divider>
              <small>{{message.description}}</small>
            </dd>
          </v-col>
        </v-row>
        <v-divider></v-divider>
        <v-row>
          <v-col cols="12" md="12">
            <dt style="font-weight:900,margin-bottom:25px">Mensaje</dt>
            <dd>
              {{message.content}}
            </dd>
          </v-col>
        </v-row>
        {{message}}
      </v-col>
    </v-row>
  </v-sheet>
  `,
  data:()=>{
    return {
      message:{
        message_sender:"",
        message_receiver:"",
        name:"",
        description:"",
        content:""
      },
      tab:''
    }
  },
  props:['title','message'],
  methods:{
    Message:function(ref) {
      var exp_id = ref.split('_')

      this.tab = exp_id[0]
      var id = exp_id[1]

      var params = {}
      var tab = {
        "sm.type":'chat',
        ID:id
      }

      var select = [
        "CONCAT(s.first_name,' ',s.last_name) AS message_sender",
        "CONCAT(r.first_name,' ',r.last_name) AS message_receiver",
        "p.name AS name",
        "p.description",
        "sm.content",
      ]

      var left_join = {}

      Vue.set(left_join,'users r',"r.id_user=sm.receiver")
      Vue.set(left_join,'users s',"s.id_user=sm.sender")

      Vue.set(left_join,'products p',"p.id_product=sm.reference")

      Vue.set(params,'where',tab)
      Vue.set(params,'left_join',left_join)
      Vue.set(params,'select',select)

      Vue.set(params,'result','row')

      axios.post('Message/get',params)
      .then((response)=>{
        //this.message = response.data
      })
    },

  },
  created:function(){
    this.$emit('loading-screen',false)
    this.Message(this.$root.url.id)
  }
})