Vue.component('web-navbar',{
  template: `
  <header id="header" class="header fixed-top d-flex align-items-center">

    <div class="d-flex align-items-center justify-content-between">
      <a href="index.html" class="logo d-flex align-items-center">
        <img src="public/theme/assets/img/logo.png" alt="">
        <span class="d-none d-lg-block">Control Panel</span>
      </a>
      <i class="bi bi-list toggle-sidebar-btn"></i>
    </div><!-- End Logo -->

    <div class="search-bar">
      <form class="search-form d-flex align-items-center" method="POST" action="#">
        <input type="text" name="query" placeholder="Search" title="Enter search keyword">
        <button type="submit" title="Search"><i class="bi bi-search"></i></button>
      </form>
    </div><!-- End Search Bar -->

    <nav class="header-nav ms-auto">
      <ul class="d-flex align-items-center">

        <li class="nav-item d-block d-lg-none">
          <a class="nav-link nav-icon search-bar-toggle " href="#">
            <i class="bi bi-search"></i>
          </a>
        </li><!-- End Search Icon-->

        <li class="nav-item dropdown">

          <a class="nav-link nav-icon" href="#" data-bs-toggle="dropdown">
            <i class="bi bi-bell"></i>
            <span class="badge bg-primary badge-number">4</span>
          </a><!-- End Notification Icon -->

          <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow notifications">
            <li class="dropdown-header">
              You have 4 new notifications
              <a href="#"><span class="badge rounded-pill bg-primary p-2 ms-2">View all</span></a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="notification-item">
              <i class="bi bi-exclamation-circle text-warning"></i>
              <div>
                <h4>Lorem Ipsum</h4>
                <p>Quae dolorem earum veritatis oditseno</p>
                <p>30 min. ago</p>
              </div>
            </li>

            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="notification-item">
              <i class="bi bi-x-circle text-danger"></i>
              <div>
                <h4>Atque rerum nesciunt</h4>
                <p>Quae dolorem earum veritatis oditseno</p>
                <p>1 hr. ago</p>
              </div>
            </li>

            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="notification-item">
              <i class="bi bi-check-circle text-success"></i>
              <div>
                <h4>Sit rerum fuga</h4>
                <p>Quae dolorem earum veritatis oditseno</p>
                <p>2 hrs. ago</p>
              </div>
            </li>

            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="notification-item">
              <i class="bi bi-info-circle text-primary"></i>
              <div>
                <h4>Dicta reprehenderit</h4>
                <p>Quae dolorem earum veritatis oditseno</p>
                <p>4 hrs. ago</p>
              </div>
            </li>

            <li>
              <hr class="dropdown-divider">
            </li>
            <li class="dropdown-footer">
              <a href="#">Show all notifications</a>
            </li>

          </ul><!-- End Notification Dropdown Items -->

        </li><!-- End Notification Nav -->

        <li class="nav-item dropdown">

          <a class="nav-link nav-icon" href="#" data-bs-toggle="dropdown">
            <i class="bi bi-chat-left-text"></i>
            <span class="badge bg-success badge-number">3</span>
          </a><!-- End Messages Icon -->

          <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow messages">
            <li class="dropdown-header">
              You have 3 new messages
              <a href="#"><span class="badge rounded-pill bg-primary p-2 ms-2">View all</span></a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="message-item">
              <a href="#">
                <img src="public/theme/assets/img/messages-1.jpg" alt="" class="rounded-circle">
                <div>
                  <h4>Maria Hudson</h4>
                  <p>Velit asperiores et ducimus soluta repudiandae labore officia est ut...</p>
                  <p>4 hrs. ago</p>
                </div>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="message-item">
              <a href="#">
                <img src="public/theme/assets/img/messages-2.jpg" alt="" class="rounded-circle">
                <div>
                  <h4>Anna Nelson</h4>
                  <p>Velit asperiores et ducimus soluta repudiandae labore officia est ut...</p>
                  <p>6 hrs. ago</p>
                </div>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="message-item">
              <a href="#">
                <img src="public/theme/assets/img/messages-3.jpg" alt="" class="rounded-circle">
                <div>
                  <h4>David Muldon</h4>
                  <p>Velit asperiores et ducimus soluta repudiandae labore officia est ut...</p>
                  <p>8 hrs. ago</p>
                </div>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="dropdown-footer">
              <a href="#">Show all messages</a>
            </li>

          </ul><!-- End Messages Dropdown Items -->

        </li><!-- End Messages Nav -->

        <li class="nav-item dropdown pe-3">

          <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
            <img src="public/theme/assets/img/profile-img.jpg" alt="Profile" class="rounded-circle">
            <span class="d-none d-md-block dropdown-toggle ps-2">{{$root.session.name}}</span>
          </a><!-- End Profile Iamge Icon -->

          <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
            <li class="dropdown-header">
              <h6>Kevin Anderson</h6>
              <span>Web Designer</span>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
              <a class="dropdown-item d-flex align-items-center" href="users-profile.html">
                <i class="bi bi-person"></i>
                <span>My Profile</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
              <a class="dropdown-item d-flex align-items-center" href="users-profile.html">
                <i class="bi bi-gear"></i>
                <span>Account Settings</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
              <a class="dropdown-item d-flex align-items-center" href="pages-faq.html">
                <i class="bi bi-question-circle"></i>
                <span>Need Help?</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
              <a class="dropdown-item d-flex align-items-center" href="#">
                <i class="bi bi-box-arrow-right"></i>
                <span>Sign Out</span>
              </a>
            </li>

          </ul><!-- End Profile Dropdown Items -->
        </li><!-- End Profile Nav -->

      </ul>
    </nav><!-- End Icons Navigation -->
  </header>
  `,
  data:()=>{
    return {
      data:[],
    }
  },
  props:["role"],
  methods:{
    LogOut:function() {
      var c = confirm('Â¿Desea cerrar sesiÃ³n?');
      if (c==true) {
        axios.post('Session/LogOut')
        .then((response)=>{
          App.GetSession()
        })
      }
    }
  }
})
Vue.component('sidebar',{
  template: `
  <v-navigation-drawer app>
    <v-list dense nav>
      <v-list-item v-for="(item,i) in menu" :key="item.data.title" link>
        <v-list-item-icon>
          <v-icon>{{ item.data.icon }}</v-icon>
        </v-list-item-icon>
        <v-list-item-content @click="$router.replace({query:{p:item.controller}}).catch(() => {})">
          <v-list-item-title class="text-h6">
            {{item.data.title}}
          </v-list-item-title>
        </v-list-item-content>
      </v-list-item>
    </v-list>
  </v-navigation-drawer>
  `,
  data:()=>{
    return {
      data:[],
    }
  },
  props:['menu'],
  methods:{
    LogOut:function() {
      var c = confirm('¿Desea cerrar sesión?');
      if (c==true) {
        axios.post('Session/LogOut')
        .then((response)=>{
          App.GetSession()
        })
      }
    }
  }
})
Vue.component('menu-add',{
  template: `
  <form>
    <div class="row mb-3">
      <div class="col-md-6">
        <label>Rol</label>
        <select v-if="$root.session.role=='admin'" class="form-control" v-model="form.role">
          <option value="business">Negocio</option>
        </select>
        <select v-else class="form-control" v-model="form.role">
          <option v-for="item in list.roles" :value="item.ID">{{item.role}}</option>
        </select>
      </div>
      <div class="col-md-6">
        <label>Tipo</label>
        <select class="form-control" v-model="form.type">
          <option value="nav">Menu Superior</option>
          <option value="left">Menu Lateral</option>
          <option value="foot">Menu Footer</option>
        </select>
      </div>
    </div>
    <div class="row mb-3">
      <div class="col-md-12">
        <div class="table-responsive">
          <table class="table table-striped table-sm">
            <thead>
              <tr>
                <th scope="col">Modulo</th>
                <th scope="col">Controller</th>
                <th scope="col"></th>
              </tr>
            </thead>
            <tbody>
              <tr v-for="module in val.modules">
                <th scope="row">{{module.name}}</th>
                <td>{{module.controller}}</td>
                <td><input type="checkbox" v-model="form.modules" :value="module.controller"></td></td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
    <button type="button" class="btn btn-info btn-fill pull-right text-uppercase" @click="Save()">
      <i class="nc-icon nc-cloud-upload-94"></i> Guardar
    </button>
    <div class="clearfix"></div>
  </form>
  `,
  data:()=>{
    return {
      form:{
        role:'owner',
        type:'nav',
        modules:[]
      },
      val:{
        modules:[]
      },
      list:{
        roles:[]
      }
    }
  },
  methods:{
    Save:function() {
      axios.post('Menu/Add',{
        data:this.form
      })
      .then((response)=>{
        if (response.data==true) {
          router.push({query:{p:App.p,a:'list'}})
        }else{
          alert('Los datos no pudieron ser guardados, intente mas tarde.')
        }
      })
    }
  },
  created:function() {
    axios.post('Module')
    .then((response)=>{
      this.val.modules = response.data
    })
    axios.post('Role')
    .then((response)=>{
      this.list.roles = response.data
    })
  }
})
Vue.component('menu-edit',{
  template: `
  <form>
    <div class="row mb-3">
      <div class="col-md-6">
        <label>Rol</label>
        <select class="form-control" v-model="form.role">
          <option value="owner">Propietario</option>
          <option value="building">Administrador</option>
          <option value="admin">Sys Admin</option>
        </select>
      </div>
      <div class="col-md-6">
        <label>Tipo</label>
        <select class="form-control" v-model="form.type">
          <option value="nav">Menu Superior</option>
          <option value="left">Menu Lateral</option>
          <option value="foot">Menu Footer</option>
        </select>
      </div>
    </div>
    <div class="row mb-3">
      <div class="col-md-12">
        <div class="table-responsive">
          <table class="table table-striped table-sm">
            <thead>
              <tr>
                <th scope="col">Modulo</th>
                <th scope="col">Controller</th>
                <th scope="col"></th>
              </tr>
            </thead>
            <tbody>
              <tr v-for="module in val.modules">
                <th scope="row">{{module.name}}</th>
                <td>{{module.controller}}</td>
                <td><input type="checkbox" v-model="form.modules" :value="module.controller"></td></td>
              </tr>
            </tbody>
          </table>
        </div>
        {{form}}
      </div>
    </div>
    <button type="button" class="btn btn-info btn-fill pull-right text-uppercase" @click="Save()">
      <i class="nc-icon nc-cloud-upload-94"></i> Guardar
    </button>
    <div class="clearfix"></div>
  </form>
  `,
  data:()=>{
    return {
      form:{
        role:'owner',
        type:'nav',
        modules:[]
      },
      val:{
        modules:[]
      }
    }
  },
  props:["pk"],
  methods:{
    Save:function() {
      axios.post('Menu/Update/'+this.pk,{
        data:this.form
      })
      .then((response)=>{
        if (response.data==true) {
          router.push({query:{p:App.p,a:'list'}})
          router.go()
        }else{
          alert('Los datos no pudieron ser guardados, intente mas tarde.')
        }
      })
    }
  },
  created:function() {
    axios.post('Module')
    .then((response)=>{
      this.val.modules = response.data
    })
    axios.post('Menu/index/'+this.pk)
    .then((response)=>{
      this.form.role = response.data.role
      this.form.type = response.data.type
      this.form.modules = response.data.modules
    })
  }
})
Vue.component('menu-list',{
  template: `
  <table class="table table-hover table-striped">
    <thead>
      <tr>
        <th>Rol</th>
        <th>Tipo</th>
        <th>Modulos</th>
        <th width="5%"><i class="nc-icon nc-stre-down"></i></th>
      </tr>
    </thead>
    <tbody>
      <tr v-for="item in data">
        <th class="font-weigth-bold text-danger">{{item.role}}</th>
        <td>{{item.type}}</td>
        <td>
          <span v-for="span in item.modules" class="badge badge-pill badge-info">{{span}}</span>
        </td>
        <td>
          <button type="button" class="btn btn-info btn-sm" @click="$router.push({query:{p:this.App.p,a:'edit',pk:item.ID}})">
            <i class="nc-icon nc-ruler-pencil"></i>
          </button>
        </td>
      </tr>
    </tbody>
  </table>
  `,
  data:()=>{
    return {
      data:[]
    }
  },
  methods:{
    Load:function() {
      axios.post('Menu')
      .then((response)=>{
        this.data = response.data
      })
    }
  },
  created:function() {
    this.Load()
  }
})