<?php
namespace App\Models;

use CodeIgniter\Model;

class ComponentModel extends Model
{
	protected $table = 'sys_component';
	protected $primaryKey = 'ID';

	protected $useAutoIncrement = true;

	protected $returnType = 'array';
	protected $useSoftDeletes = false;

	protected $allowedFields = [
		'name',
		'codename',
		'template',
		'type',
		'table',
		'data',
		'props',
		'attr',
		'query'
	];

	protected $useTimestamps = false;
	protected $createdField = 'created_at';
	protected $updatedField = '';
	protected $deletedField = '';

	protected $validationRules = [];
	protected $validationMessages = [];
	protected $skipValidation = false;

	public function GetAll($query = [])
	{
		foreach ($query as $key => $value) {
			if (is_string($key) and isset($value['fields'])) {
				$this->groupStart();
				if (is_array($value['fields']) and is_string($value['value'])) {
					$st = 0;
					foreach ($value['fields'] as $field) {
						if ($st == 0) {
							$this->like($field, $value['value']);
						} else {
							$this->orLike($field, $value['value']);
						}
						$st++;
					}
				}
				if (is_string($value['fields']) and is_array($value['value'])) {
					$st = 0;
					foreach ($value['value'] as $k => $v) {
						if ($st == 0) {
							$this->like("{$value['fields']}", "{$v}");
						} else {
							$this->orLike("{$value['fields']}", "{$v}");
						}
						$st++;
					}
				}
				if (is_string($value['fields']) and is_string($value['value'])) {
					$this->like($value['fields'], $value['fields']);
				}
				$this->groupEnd();
			} elseif (is_string($value)) {
				$this->groupStart();
				$this->where($key, $value);
				$this->groupEnd();
			} elseif (is_array($value)) {
				$this->groupStart();
				$st = 0;
				foreach ($value as $field => $val) {
					if ($st == 0) {
						$this->where($key, $val);
					} else {
						$this->orWhere($key, $val);
					}
					$st++;
				}
				$this->groupEnd();
			}
		}
		return $this->find();
	}

	public function GetID($id)
	{
		$this->where('ID', $id);
		return $this->first();
	}

	public function GetCountAll($query = '')
	{
		$this->select('COUNT(*) as total');
		foreach ($query as $key => $value) {
			if (is_string($key) and isset($value['fields'])) {
				$this->groupStart();
				if (is_array($value['fields']) and is_string($value['value'])) {
					$st = 0;
					foreach ($value['fields'] as $field) {
						if ($st == 0) {
							$this->like($field, $value['value']);
						} else {
							$this->orLike($field, $value['value']);
						}
						$st++;
					}
				}
				if (is_string($value['fields']) and is_array($value['value'])) {
					$st = 0;
					foreach ($value['value'] as $k => $v) {
						if ($st == 0) {
							$this->like("{$value['fields']}", "{$v}");
						} else {
							$this->orLike("{$value['fields']}", "{$v}");
						}
						$st++;
					}
				}
				if (is_string($value['fields']) and is_string($value['value'])) {
					$this->like($value['fields'], $value['fields']);
				}
				$this->groupEnd();
			} elseif (is_string($value)) {
				$this->groupStart();
				$this->where($key, $value);
				$this->groupEnd();
			} elseif (is_array($value)) {
				$this->groupStart();
				$st = 0;
				foreach ($value as $field => $val) {
					if ($st == 0) {
						$this->where($key, $val);
					} else {
						$this->orWhere($key, $val);
					}
					$st++;
				}
				$this->groupEnd();
			}
		}

		return $this->first();
	}
}

?>