<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Menu extends Migration
{
    public function up()
    {
        $this->forge = \Config\Database::forge();
        $this->forge->addField([
            'ID'=>[
                'type' => 'INT',
                'constraint' => 5,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'role'=>[
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => true,
            ],
            'type' =>[
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => true,
            ],
            'source' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => true,
            ],
            'modules'=>[
                'type' => 'TEXT',
                'null' => true,
            ]
        ]);
        $this->forge->addKey('ID', true);
        $this->forge->createTable('sys_menu');
    }

    public function down()
    {
        $this->forge->dropTable('sys_menu');
    }
}
