<?php

namespace App\Controllers;

class Security extends BaseController
{
  public function get($id = null)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $tables = $this->db->listTables();
    $tables = array_merge(array_diff($tables, ['sys_component', 'sys_menu', 'sys_modules', 'admin', 'sys_post', 'element']));

    $response = [];

    if (!empty($id)) {
      $response = [
        'name' => $id,
        'fields' => $this->db->getFieldData($id)
      ];
    } else {
      foreach ($tables as $table) {
        $response[] = [
          'name' => $table,
          'fields' => $this->db->getFieldData($table)
        ];
      }
    }
    echo json_encode($response);
  }
  public function add()
  {
    $form = json_decode(file_get_contents('php://input'), true);

    $sql = create_table($form['data']['name'], $form['data']['fields'], $form['data']['index'], $form['data']['keys']);
    $ret = $this->db->query($sql);

    if ($ret) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
      $response['message'] = $this->db->error();
    }
    echo json_encode($response);
    //echo json_encode($sql);
  }

  public function table_export($table = null, $data = false)
  {
    if (!empty($table)) {
      // disable caching
      $now = gmdate("D, d M Y H:i:s");
      $date = date("d-m-Y");
      $filename = "{$table}-{$date}.csv";
      header("Expires: Tue, 03 Jul 2001 06:00:00 GMT");
      header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");
      header("Last-Modified: {$now} GMT");

      // force download  
      header("Content-Type: application/force-download");
      header("Content-Type: application/octet-stream");
      header("Content-Type: application/download");

      // disposition / encoding on response body
      header("Content-Disposition: attachment;filename={$filename}");
      /*header("Content-Transfer-Encoding: binary");*/

      $tables = $this->db->getFieldData($table);
      $csv_header = [];
      $csv_data = [];
      $qry = $data == true ? $this->db->table($table)->get()->getResultArray() : null;
      foreach ($tables as $fields) {
        $csv_header[] = $fields->name;
      }
      if ($qry !== null) {
        $r = 0;
        foreach ($qry as $row) {
          foreach ($csv_header as $h) {
            $value[$r][$h] = $row[$h];
          }
          $csv_data[] = implode(';', array_values($value[$r]));
          $r++;
        }
      }
      $header = implode(';', $csv_header);
      $data = implode('\n', $csv_data);
      echo "{$header}\n{$data}";
      /*//ob_start();
      $df = fopen("php://output", 'w');
      fputcsv($df, $csv_header);
      fclose($df);
      //ob_get_clean();
      die();*/

    }
  }

  public function table_import($table = null)
  {
    if (!empty($table)) {
      $path = 'public/import_test.csv';
      $cc = file_get_contents($path);
      $ln = explode("\n", $cc);
      $head = explode(';', $ln[0]);
      $l = 1;
      for ($l = 1; $l < count($ln); $l++) {
        $nl = explode(';', $ln[$l]);
        $c = 0;
        $data = [];
        foreach ($head as $h) {
          $data[$h] = $nl[$c];
          $c++;
        }
        if ($this->db->table($table)->set($data)->insert()) {
          $response['status'] = 200;
        } else {
          $response['status'] = 500;
          $response['message'] = $this->db->error();
        }
        echo json_encode($response);
        $l++;
      }
      /*$file = fopen($path,'r');
      foreach (fgetcsv($file) as $row) {
      var_dump($row);
      }
      while (($row = fgetcsv($file))!== false) {
      }*/
    }
  }
  public function get_fields()
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $response = [];
    $query = $this->db->query($form['query']);
    $response = $query->getFieldNames();
    echo json_encode($response);
  }
  public function create($table)
  {
    if (isset($_REQUEST['multipart']) and $_REQUEST['multipart'] == true) {
      $form['data'] = [];
      $data = $this->db->table('sys_component')->where(['ID' => $_REQUEST['sys_component']])->get()->getRowArray();
      foreach (json_decode($data['data'], true) as $field) {
        if ($field['visible'] == true) {
          if ($field['type'] == 'file' || $field['type'] == 'image') {
            if (boolval($field['multiple'])) {
              $form['data'][$field['name']] = json_encode(!empty($_FILES[$field['name']]) ? save_file($_FILES[$field['name']]) : []);
            } else {
              $form['data'][$field['name']] = json_encode(!empty($_FILES[$field['name']]) ? save_file($_FILES[$field['name']]) : '{}');
            }
          } else {
            $form['data'][$field['name']] = $_REQUEST[$field['name']];
          }
        }
      }
    } else {
      $form = json_decode(file_get_contents('php://input'), true);
      $tables = $this->db->getFieldData($table);
      foreach ($tables as $field) {
        if (isset($form['data'][$field->name])) {
          $form['data'][$field->name] = is_array($form['data'][$field->name]) ? json_encode($form['data'][$field->name]) : $form['data'][$field->name];
        }
      }
    }
    if ($this->db->table($table)->set($form['data'])->insert()) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
    }
    echo json_encode($response);
  }
  public function read($table = null)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $response = [];
    $tables = [];
    if (isset($form['data']['from']) and !empty($form['data']['from'])) {
      $query = $this->db->table($form['data']['from'][0]);
      unset($form['data']['from'][0]);
      foreach (array_values($form['data']['from']) as $table) {
        $tables[] = $table;
        $query->from($table);
      }
    } else {
      $tables[] = $table;
      $query = $this->db->table($table);
    }
    if (isset($form['data']['select']) and !empty($form['data']['select'])) {
      foreach ($form['data']['select'] as $value) {
        $query->select("{$value} AS " . str_replace('.', '_', $value));
      }
    }
    if (isset($form['data']['rule']) and count($form['data']['rule']) > 0) {
      foreach ($form['data']['rule'] as $field) {
        switch ($field['comparator']) {
          case 'Igual':
            $operator = '=';
            break;
          case 'No Igual':
            $operator = '!=';
            break;
          case 'Menor':
            $operator = '<';
            break;
          case 'Mayor':
            $operator = '>';
            break;
          case 'Menor o Igual':
            $operator = '<=';
            break;
          case 'Mayor o Igual':
            $operator = '>=';
            break;
          case 'Contiene':
            $operator = 'LIKE';
            break;

          case '=':
            $operator = '=';
            break;
          case '!=':
            $operator = '!=';
            break;
          case '<':
            $operator = '<';
            break;
          case '>':
            $operator = '>';
            break;
          case '<=':
            $operator = '<=';
            break;
          case '>=':
            $operator = '>=';
            break;
          case 'LIKE':
            $operator = 'LIKE';
            break;

          default:
            $operator = '=';
            break;
        }

        switch ($field['value']) {
          case '':
            $value = null;
            break;

          default:
            $value = $field['value'];
            break;
        }
        if ($operator == 'LIKE') {
          if ($field['conector'] == 'OR') {
            $query->orLike($field['key'], $value, 'both', false);
          } else {
            $query->like($field['key'], $value, 'both', false);
          }
        } else {
          if ($field['conector'] == 'OR') {
            $query->orWhere("{$field['key']} {$operator}", $value, $field['escape']);
          } else {
            $query->where("{$field['key']} {$operator}", $value, $field['escape']);
          }
        }
      }
    }
    if (isset($form['data']['group'])) {
      foreach ($form['data']['group'] as $item) {
        $query->groupStart();
        foreach ($item['rule'] as $field) {
          switch ($field['comparator']) {
            case 'Igual':
              $operator = '=';
              break;
            case 'No Igual':
              $operator = '!=';
              break;
            case 'Menor':
              $operator = '<';
              break;
            case 'Mayor':
              $operator = '>';
              break;
            case 'Menor o Igual':
              $operator = '<=';
              break;
            case 'Mayor o Igual':
              $operator = '>=';
              break;
            case 'Contiene':
              $operator = 'LIKE';
              break;

            default:
              $operator = '=';
              break;
          }
          switch ($field['value']) {
            case '':
              $value = null;
              break;

            default:
              $value = $field['value'];
              break;
          }
          if ($operator == 'LIKE') {
            if ($field['conector'] == 'OR') {
              $query->orLike($field['key'], $value, 'both', false);
            } else {
              $query->like($field['key'], $value, 'both', false);
            }
          } else {
            if ($field['conector'] == 'OR') {
              $query->orWhere("{$field['key']} {$operator}", $value);
            } else {
              $query->where("{$field['key']} {$operator}", $value);
            }
          }
        }
        $query->groupEnd();
      }
    }
    $response = $query->get()->getResultArray();
    $query_fields = $this->db->query($this->db->getLastQuery());
    if (isset($form['result']) and $form['result'] == 'row') {
      foreach ($query_fields->getFieldNames() as $field) {
        $decode = json_decode($response[0][$field->name]);
        $response[0][$field] = !is_array($decode) ? $response[0][$field] : json_decode($response[0][$field]);
      }
    } else {
      foreach ($response as $key => $value) {
        foreach ($query_fields->getFieldNames() as $field) {
          $decode = json_decode($response[$key][$field], true);
          $response[$key][$field] = !is_array($decode) ? $response[$key][$field] : json_decode($response[$key][$field], true);
        }
      }
    }
    if (isset($form['result']) and $form['result'] == 'row') {
      echo json_encode($response[0]);
    } else {
      echo json_encode($response);
    }
  }
  public function update($table)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    unset($form['data']['']);
    foreach ($form['data'] as $key => $value) {
      if (!empty($key)) {
        $convert = json_decode($form['data'][$key], true);
        $form['data'][$key] = !is_array($convert) ? $value : json_encode($form['data'][$key]);
      }
    }
    if ($this->db->table($table)->set($form['data'])->where($form['where'])->update()) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
    }
    echo json_encode($response);
  }

  public function delete($table){
    $form = json_decode(file_get_contents('php://input'), true);
    unset($form['data']['']);
    if ($this->db->table($table)->where($form['where'])->delete()) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
    }
    echo json_encode($response);
  }

  public function SendToken()
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $config['mailType'] = 'html';
    $config['wordWrap'] = true;
    $token = rand(12345,99999);

    $content = "
      <html>
        <body>
          <p>Su codigo de seguridad es: {$token}<strong></strong></p>
        </body>
      </html>
    ";

    $email = service('email');
    $email->initialize($config);

    $email->setFrom('security@solankoyachts.com', 'Security Token');
    $email->setTo($form['data']['email']);

    $email->setSubject('Security Token');
    $email->setMessage($content);

    $logged = false;

    if ($email->send()) {
      $ret['success'] = true;
      $ret['message'] = "Codigo enviado al correo";
      $ret['token'] = $token;
    } else {
      $ret['success'] = false;
      $ret['message'] = "Intente mas tarde";
    }
    echo json_encode($ret);
  }
}