<?php

namespace App\Controllers;

class Database extends BaseController
{
  public function get($id = null, $fields = 't')
  {
    $id = $id == null || $id == 'null' ? null : $id;
    $form = json_decode(file_get_contents('php://input'), true);
    $tables = $this->db->listTables();
    $tables = array_merge(array_diff($tables, ['sys_component', 'sys_menu', 'sys_modules', 'sys_settings', 'sys_admin', 'sys_post', 'sys_element', 'migrations']));

    $response = [];

    if (!empty($id)) {
      if ($fields == 't') {
        $response = [
          'name' => $id,
          'fields' => $this->db->getFieldData($id)
        ];
      } else {
        $response = [
          'name' => $id
        ];
      }
    } else {
      foreach ($tables as $table) {
        if ($fields == 't') {
          $response[] = [
            'name' => $table,
            'fields' => $this->db->getFieldData($table)
          ];
        } else {
          $response[] = [
            'name' => $table
          ];
        }
      }
    }
    echo json_encode($response);
  }
  public function add()
  {
    $form = json_decode(file_get_contents('php://input'), true);

    $sql = create_table($form['data']['name'], $form['data']['fields'], $form['data']['index'], $form['data']['keys']);
    $ret = $this->db->query($sql);

    if ($ret) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
      $response['message'] = $this->db->error();
    }
    echo json_encode($response);
  }

  public function fields($table=null)
  {
    $tables = [];
    if (empty($table)) {
      $input = json_decode(file_get_contents('php://input'), true);
      foreach ($input['tables'] as $table) {
        $get_tables = $this->db->getFieldData($table);
        for ($i = 0; $i < count($get_tables); $i++) {
          switch ($get_tables[$i]->type) {
            case 'int':
              $ff['type'] = 'number';
              break;
            case 'varchar':
              $ff['type'] = 'text';
              break;
            case 'text':
              $ff['type'] = 'textarea';
              break;
            case 'date':
              $ff['type'] = 'date';
              break;
            case 'time':
              $ff['type'] = 'time';
              break;

            default:
              $ff['type'] = 'text';
              break;

          }
          $ff['option'] = [
            'origin' => null,
            'data' => ['key' => null, 'value' => null]
          ];
          $ff['name'] = $table . "." . $get_tables[$i]->name;
          $ff['label'] = str_replace(["_"], ' ', $get_tables[$i]->name);
          $ff['primary_key'] = $get_tables[$i]->primary_key;
          $ff['nullable'] = $get_tables[$i]->nullable;
          $ff['width'] = 6;
          $ff['visible'] = true;
          $ff['helper'] = null;
          $ff['filter'] = null;
          $ff['hidden'] = false;
          $ff['disabled'] = false;
          $ff['required'] = ($ff['nullable'] == false) ? true : false;
          $ff['multiple'] = false;
          array_push($tables, $ff);
        }
      }
    } else {
      $get_tables = $this->db->getFieldData($table);
      for ($i = 0; $i < count($get_tables); $i++) {
        switch ($get_tables[$i]->type) {
          case 'int':
            $ff['type'] = 'number';
            break;
          case 'varchar':
            $ff['type'] = 'text';
            break;
          case 'text':
            $ff['type'] = 'textarea';
            break;
          case 'date':
            $ff['type'] = 'date';
            break;
          case 'time':
            $ff['type'] = 'time';
            break;

          default:
            $ff['type'] = 'text';
            break;

        }
        $ff['option'] = [
          'origin' => null,
          'data' => ['key' => null, 'value' => null]
        ];
        $ff['name'] = $get_tables[$i]->name;
        $ff['label'] = str_replace(["_"], ' ', $get_tables[$i]->name);
        $ff['primary_key'] = $get_tables[$i]->primary_key;
        $ff['nullable'] = $get_tables[$i]->nullable;
        $ff['width'] = 6;
        $ff['visible'] = true;
        $ff['helper'] = null;
        $ff['filter'] = null;
        $ff['hidden'] = false;
        $ff['disabled'] = false;
        $ff['required'] = ($ff['nullable'] == false) ? true : false;
        $ff['multiple'] = false;
        array_push($tables, $ff);
      }
    }
    echo json_encode($tables);
  }

  public function table_export($table = null, $data = false)
  {
    if (!empty($table)) {
      // disable caching
      $now = gmdate("D, d M Y H:i:s");
      $date = date("d-m-Y");
      $filename = "{$table}-{$date}.csv";
      header("Expires: Tue, 03 Jul 2001 06:00:00 GMT");
      header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");
      header("Last-Modified: {$now} GMT");

      // force download  
      header("Content-Type: application/force-download");
      header("Content-Type: application/octet-stream");
      header("Content-Type: application/download");

      // disposition / encoding on response body
      header("Content-Disposition: attachment;filename={$filename}");
      /*header("Content-Transfer-Encoding: binary");*/

      $tables = $this->db->getFieldData($table);
      $csv_header = [];
      $csv_data = [];
      $qry = $data == true ? $this->db->table($table)->get()->getResultArray() : null;
      foreach ($tables as $fields) {
        $csv_header[] = $fields->name;
      }
      if ($qry !== null) {
        $r = 0;
        foreach ($qry as $row) {
          foreach ($csv_header as $h) {
            $value[$r][$h] = $row[$h];
          }
          $csv_data[] = implode(';', array_values($value[$r]));
          $r++;
        }
      }
      $header = implode(';', $csv_header);
      $data = implode('\n', $csv_data);
      echo "{$header}\n{$data}";
      /*//ob_start();
      $df = fopen("php://output", 'w');
      fputcsv($df, $csv_header);
      fclose($df);
      //ob_get_clean();
      die();*/

    }
  }

  public function table_import($table = null)
  {
    if (!empty($table)) {
      $path = 'public/import_test.csv';
      $cc = file_get_contents($path);
      $ln = explode("\n", $cc);
      $head = explode(';', $ln[0]);
      $l = 1;
      for ($l = 1; $l < count($ln); $l++) {
        $nl = explode(';', $ln[$l]);
        $c = 0;
        $data = [];
        foreach ($head as $h) {
          $data[$h] = $nl[$c];
          $c++;
        }
        if ($this->db->table($table)->set($data)->insert()) {
          $response['status'] = 200;
        } else {
          $response['status'] = 500;
          $response['message'] = $this->db->error();
        }
        echo json_encode($response);
        $l++;
      }
      /*$file = fopen($path,'r');
      foreach (fgetcsv($file) as $row) {
      var_dump($row);
      }
      while (($row = fgetcsv($file))!== false) {
      }*/
    }
  }

  public function render_create($table)
  {
    if (isset($_REQUEST['multipart']) and $_REQUEST['multipart'] == true) {
      $form['data'] = [];
      $data = $this->db->table('sys_component')->where(['ID' => $_REQUEST['sys_component']])->get()->getRowArray();
      foreach (json_decode($data['data'], true) as $field) {
        if ($field['visible'] == true) {
          if ($field['type'] == 'file' || $field['type'] == 'image') {
            if (boolval($field['multiple'])) {
              $form['data'][$field['name']] = json_encode(!empty($_FILES[$field['name']]) ? save_file($_FILES[$field['name']]) : []);
            } else {
              $form['data'][$field['name']] = !empty($_FILES[$field['name']]) ? save_file($_FILES[$field['name']]) : null;
            }
          } else {
            $form['data'][$field['name']] = is_array($_REQUEST[$field['name']])?json_encode($_REQUEST[$field['name']]):$_REQUEST[$field['name']];
          }
        }
      }
    } else {
      $data = json_decode(file_get_contents('php://input'), true);
      $form['data'] = [];
      foreach ($data as $key => $value) {
        $form['data'][$key] = is_array($value) ? json_encode($value) : $value;
      }
    }
    if ($this->db->table($table)->set($form['data'])->insert()) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
      $response['message'] = $this->db->error();
    }
    echo json_encode($response);
  }

  public function render_read($table = null)
  {
    #header('Access-Control-Allow-Origin: *')
    $form = json_decode(file_get_contents('php://input'), true);
    $response = [];
    $tables = [];
    if (isset($form['data']['from']) and !empty($form['data']['from'])) {
      $query = $this->db->table($table);
      foreach (array_values($form['data']['from']) as $table) {
        $tables[] = $table;
        $query->from($table);
      }
    } else {
      $tables[] = $table;
      $query = $this->db->table($table);
    }
    if (isset($form['data']['select']) and !empty($form['data']['select'])) {
      foreach ($form['data']['select'] as $value) {
        $query->select("{$value} AS " . str_replace('.', '_', $value));
      }
    }
    if (isset($form['data']['rule']) and count($form['data']['rule']) > 0) {
      foreach ($form['data']['rule'] as $field) {
        switch ($field['comparator']) {
          case 'Igual':
            $operator = '=';
            break;
          case 'No Igual':
            $operator = '!=';
            break;
          case 'Menor':
            $operator = '<';
            break;
          case 'Mayor':
            $operator = '>';
            break;
          case 'Menor o Igual':
            $operator = '<=';
            break;
          case 'Mayor o Igual':
            $operator = '>=';
            break;
          case 'Contiene':
            $operator = 'LIKE';
            break;

          case '=':
            $operator = '=';
            break;
          case '!=':
            $operator = '!=';
            break;
          case '<':
            $operator = '<';
            break;
          case '>':
            $operator = '>';
            break;
          case '<=':
            $operator = '<=';
            break;
          case '>=':
            $operator = '>=';
            break;
          case 'LIKE':
            $operator = 'LIKE';
            break;

          default:
            $operator = '=';
            break;
        }

        switch ($field['value']) {
          case '':
            $value = null;
            break;

          default:
            $value = $field['value'];
            break;
        }
        if ($operator == 'LIKE') {
          if (isset($field['conector']) and $field['conector'] == 'OR') {
            $query->orLike($field['key'], $value, 'both', $field['escape']);
          } else {
            $query->like($field['key'], $value, 'both', $field['escape']);
          }
        } else {
          if (isset($field['conector']) and $field['conector'] == 'OR') {
            $query->orWhere("{$field['key']} {$operator}", $value, $field['escape']);
          } else {
            $query->where("{$field['key']} {$operator}", $value, $field['escape']);
          }
        }
      }
    }
    if (isset($form['data']['group'])) {
      foreach ($form['data']['group'] as $item) {
        $query->groupStart();
        foreach ($item['rule'] as $field) {
          switch ($field['comparator']) {
            case 'Igual':
              $operator = '=';
              break;
            case 'No Igual':
              $operator = '!=';
              break;
            case 'Menor':
              $operator = '<';
              break;
            case 'Mayor':
              $operator = '>';
              break;
            case 'Menor o Igual':
              $operator = '<=';
              break;
            case 'Mayor o Igual':
              $operator = '>=';
              break;
            case 'Contiene':
              $operator = 'LIKE';
              break;

            default:
              $operator = '=';
              break;
          }
          switch ($field['value']) {
            case '':
              $value = null;
              break;

            default:
              $value = $field['value'];
              break;
          }
          if ($operator == 'LIKE') {
            if ($field['conector'] == 'OR') {
              $query->orLike($field['key'], $value, 'both', false);
            } else {
              $query->like($field['key'], $value, 'both', false);
            }
          } else {
            if ($field['conector'] == 'OR') {
              $query->orWhere("{$field['key']} {$operator}", $value);
            } else {
              $query->where("{$field['key']} {$operator}", $value);
            }
          }
        }
        $query->groupEnd();
      }
    }
    $response = $query->get()->getResultArray();
    if (isset($form['result']) and $form['result'] == 'row') {
      echo json($response[0],true,false);
    } else {
      echo json($response);
    }
  }

  public function render_update($table)
  {
    if (isset($_REQUEST['multipart']) and $_REQUEST['multipart'] == true) {
      $form['data'] = [];
      $data = $this->db->table('sys_component')->where(['ID' => $_REQUEST['sys_component']])->get()->getRowArray();
      $form['where'] = [];
      foreach (json_decode($data['data'], true) as $field) {
        if ($field['primary_key']=='1') {
          $form['where'][$field['name']] = $_REQUEST[$field['name']];
        }
        if ($field['visible'] == true) {
          if ($field['type'] == 'file' || $field['type'] == 'image') {
            if (boolval($field['multiple'])) {
              $form['data'][$field['name']] = json_encode(!empty($_FILES[$field['name']]) ? save_file($_FILES[$field['name']]) : []);
            } else {
              $form['data'][$field['name']] = !empty($_FILES[$field['name']]) ? save_file($_FILES[$field['name']]) : null;
            }
          } else {
            $form['data'][$field['name']] = is_array($_REQUEST[$field['name']])?json_encode($_REQUEST[$field['name']]):$_REQUEST[$field['name']];
          }
        }
      }
    } else {
      $data = json_decode(file_get_contents('php://input'), true);
      $form['data'] = [];
      $form['where'] = $data['where'];
      foreach ($data['data'] as $key => $value) {
        $form['data'][$key] = is_array($value) ? json_encode($value) : $value;
      }
    }
    if ($this->db->table($table)->set($form['data'])->where($form['where'])->update()) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
      $response['message'] = $this->db->error();
    }
    echo json_encode($response);
  }

  public function delete($table)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    unset($form['data']['']);
    if ($this->db->table($table)->where($form['where'])->delete()) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
    }
    echo json_encode($response);
  }

  public function render_view($table = null)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $response = [];
    $tables = [];
    if (isset($form['data']['from']) and !empty($form['data']['from'])) {
      $query = $this->db->table($table);
      foreach (array_values($form['data']['from']) as $table) {
        $tables[] = $table;
        $query->from($table);
      }
    } else {
      $tables[] = $table;
      $query = $this->db->table($table);
    }
    if (isset($form['data']['select']) and !empty($form['data']['select'])) {
      foreach ($form['data']['select'] as $value) {
        $query->select("{$value} AS " . str_replace('.', '_', $value));
      }
    }
    if (isset($form['data']['rule']) and count($form['data']['rule']) > 0) {
      foreach ($form['data']['rule'] as $field) {
        switch ($field['comparator']) {
          case 'Igual':
            $operator = '=';
            break;
          case 'No Igual':
            $operator = '!=';
            break;
          case 'Menor':
            $operator = '<';
            break;
          case 'Mayor':
            $operator = '>';
            break;
          case 'Menor o Igual':
            $operator = '<=';
            break;
          case 'Mayor o Igual':
            $operator = '>=';
            break;
          case 'Contiene':
            $operator = 'LIKE';
            break;

          case '=':
            $operator = '=';
            break;
          case '!=':
            $operator = '!=';
            break;
          case '<':
            $operator = '<';
            break;
          case '>':
            $operator = '>';
            break;
          case '<=':
            $operator = '<=';
            break;
          case '>=':
            $operator = '>=';
            break;
          case 'LIKE':
            $operator = 'LIKE';
            break;

          default:
            $operator = '=';
            break;
        }

        switch ($field['value']) {
          case '':
            $value = null;
            break;

          default:
            $value = $field['value'];
            break;
        }
        if ($operator == 'LIKE') {
          if ($field['conector'] == 'OR') {
            $query->orLike($field['key'], $value, 'both', false);
          } else {
            $query->like($field['key'], $value, 'both', false);
          }
        } else {
          if ($field['conector'] == 'OR') {
            $query->orWhere("{$field['key']} {$operator}", $value, $field['escape']);
          } else {
            $query->where("{$field['key']} {$operator}", $value, $field['escape']);
          }
        }
      }
    }
    if (isset($form['data']['group'])) {
      foreach ($form['data']['group'] as $item) {
        $query->groupStart();
        foreach ($item['rule'] as $field) {
          switch ($field['comparator']) {
            case 'Igual':
              $operator = '=';
              break;
            case 'No Igual':
              $operator = '!=';
              break;
            case 'Menor':
              $operator = '<';
              break;
            case 'Mayor':
              $operator = '>';
              break;
            case 'Menor o Igual':
              $operator = '<=';
              break;
            case 'Mayor o Igual':
              $operator = '>=';
              break;
            case 'Contiene':
              $operator = 'LIKE';
              break;

            default:
              $operator = '=';
              break;
          }
          switch ($field['value']) {
            case '':
              $value = null;
              break;

            default:
              $value = $field['value'];
              break;
          }
          if ($operator == 'LIKE') {
            if ($field['conector'] == 'OR') {
              $query->orLike($field['key'], $value, 'both', false);
            } else {
              $query->like($field['key'], $value, 'both', false);
            }
          } else {
            if ($field['conector'] == 'OR') {
              $query->orWhere("{$field['key']} {$operator}", $value);
            } else {
              $query->where("{$field['key']} {$operator}", $value);
            }
          }
        }
        $query->groupEnd();
      }
    }
    $query->where($form['main']);
    $response = $query->get()->getResultArray();

    if (isset($form['result']) and $form['result'] == 'row') {
      echo json($response[0],true,false);
    } else {
      echo json($response);
    }
  }
}